/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.rename;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.swing.event.CaretEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.lib.editor.codetemplates.SyncDocumentRegion;
import org.netbeans.lib.editor.util.swing.MutablePositionRegion;
import org.netbeans.lib.editor.util.swing.PositionRegion;
import org.netbeans.modules.editor.highlights.spi.Highlight;
import org.netbeans.modules.editor.highlights.spi.Highlighter;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstantRenamePerformer
implements DocumentListener,
KeyListener {
    private SyncDocumentRegion region;
    private Document doc;
    private JTextComponent target;
    private MutablePositionRegion mainRegion;
    private boolean inSync;

    private InstantRenamePerformer(JTextComponent jTextComponent, Set<Highlight> set, int n) throws BadLocationException {
        this.target = jTextComponent;
        this.doc = jTextComponent.getDocument();
        MutablePositionRegion mutablePositionRegion = null;
        ArrayList<MutablePositionRegion> arrayList = new ArrayList<MutablePositionRegion>();
        ArrayList<RenameHighlight> arrayList2 = new ArrayList<RenameHighlight>();
        for (Highlight highlight : set) {
            Position position;
            Position position2 = NbDocument.createPosition((Document)this.doc, (int)highlight.getStart(), (Position.Bias)Position.Bias.Backward);
            MutablePositionRegion mutablePositionRegion2 = new MutablePositionRegion(position2, position = NbDocument.createPosition((Document)this.doc, (int)highlight.getEnd(), (Position.Bias)Position.Bias.Forward));
            if (this.isIn(mutablePositionRegion2, n)) {
                mutablePositionRegion = mutablePositionRegion2;
            } else {
                arrayList.add(mutablePositionRegion2);
            }
            arrayList2.add(new RenameHighlight((PositionRegion)mutablePositionRegion2));
        }
        if (mutablePositionRegion == null) {
            throw new IllegalArgumentException("No highlight contains the caret.");
        }
        arrayList.add(0, mutablePositionRegion);
        this.region = new SyncDocumentRegion(this.doc, arrayList);
        if (this.doc instanceof BaseDocument) {
            ((BaseDocument)this.doc).setPostModificationDocumentListener((DocumentListener)this);
        }
        jTextComponent.addKeyListener(this);
        jTextComponent.putClientProperty(InstantRenamePerformer.class, this);
        Highlighter.getDefault().setHighlights(this.getFileObject(), "instant-rename", arrayList2);
        jTextComponent.select(mutablePositionRegion.getStartOffset(), mutablePositionRegion.getEndOffset());
    }

    private FileObject getFileObject() {
        DataObject dataObject = (DataObject)this.doc.getProperty("stream");
        if (dataObject == null) {
            return null;
        }
        return dataObject.getPrimaryFile();
    }

    public static void performInstantRename(JTextComponent jTextComponent, Set<Highlight> set, int n) throws BadLocationException {
        new InstantRenamePerformer(jTextComponent, set, n);
    }

    private boolean isIn(MutablePositionRegion mutablePositionRegion, int n) {
        return mutablePositionRegion.getStartOffset() <= n && n <= mutablePositionRegion.getEndOffset();
    }

    @Override
    public synchronized void insertUpdate(DocumentEvent documentEvent) {
        if (this.inSync) {
            return;
        }
        this.inSync = true;
        this.region.sync(0);
        this.inSync = false;
        this.target.repaint();
    }

    @Override
    public synchronized void removeUpdate(DocumentEvent documentEvent) {
        if (this.inSync) {
            return;
        }
        if (this.doc.getProperty("doc-replace-selection-property") != null) {
            return;
        }
        this.inSync = true;
        this.region.sync(0);
        this.inSync = false;
        this.target.repaint();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void caretUpdate(CaretEvent caretEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27 && keyEvent.getModifiers() == 0 || keyEvent.getKeyCode() == 10 && keyEvent.getModifiers() == 0) {
            this.release();
            keyEvent.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    private void release() {
        this.target.putClientProperty(InstantRenamePerformer.class, null);
        if (this.doc instanceof BaseDocument) {
            ((BaseDocument)this.doc).setPostModificationDocumentListener(null);
        }
        this.target.removeKeyListener(this);
        Highlighter.getDefault().setHighlights(this.getFileObject(), "instant-rename", Collections.emptyList());
        this.region = null;
        this.doc = null;
        this.target = null;
        this.mainRegion = null;
    }

    private static final class RenameHighlight
    implements Highlight {
        private PositionRegion region;
        private static final Coloring COLORING = new Coloring(null, null, new Color(138, 191, 236));

        public RenameHighlight(PositionRegion positionRegion) {
            this.region = positionRegion;
        }

        public int getStart() {
            return this.region.getStartOffset();
        }

        public int getEnd() {
            return this.region.getEndOffset();
        }

        public Coloring getColoring() {
            return COLORING;
        }
    }
}

