/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import java.awt.Color;
import java.awt.Font;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.modules.java.editor.semantic.ColoringAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ColoringManager {
    private static Map<ColoringAttributes, Coloring> type2Coloring;
    private static final Font ITALIC;
    private static final Font BOLD;
    private static final Font BOLDITALIC;

    public static Coloring getColoring(Collection<ColoringAttributes> collection) {
        if ((collection = EnumSet.copyOf(collection)).contains((Object)ColoringAttributes.UNUSED)) {
            collection.removeAll(EnumSet.of(ColoringAttributes.ABSTRACT, new ColoringAttributes[]{ColoringAttributes.FIELD, ColoringAttributes.LOCAL_VARIABLE, ColoringAttributes.PARAMETER, ColoringAttributes.CLASS, ColoringAttributes.PRIVATE, ColoringAttributes.PACKAGE_PRIVATE, ColoringAttributes.PROTECTED, ColoringAttributes.PUBLIC, ColoringAttributes.UNDEFINED}));
        }
        if (collection.contains((Object)ColoringAttributes.UNDEFINED)) {
            collection.removeAll(EnumSet.of(ColoringAttributes.ABSTRACT, new ColoringAttributes[]{ColoringAttributes.FIELD, ColoringAttributes.LOCAL_VARIABLE, ColoringAttributes.PARAMETER, ColoringAttributes.CLASS, ColoringAttributes.PRIVATE, ColoringAttributes.PACKAGE_PRIVATE, ColoringAttributes.PROTECTED, ColoringAttributes.PUBLIC}));
        }
        Coloring coloring = new Coloring(null, 0, null, null);
        for (ColoringAttributes coloringAttributes : ColoringAttributes.values()) {
            if (!collection.contains((Object)coloringAttributes)) continue;
            Coloring coloring2 = type2Coloring.get((Object)coloringAttributes);
            Coloring coloring3 = coloring2.apply(coloring);
            Font font = coloring.getFont();
            Font font2 = coloring2.getFont();
            Font font3 = null;
            if (font == null) {
                font3 = font2;
            } else if (font2 == null) {
                font3 = font;
            } else {
                int n = font.getStyle() | font2.getStyle();
                font3 = font.deriveFont(n);
            }
            coloring = new Coloring(font3, 2, coloring3.getForeColor(), coloring3.getBackColor(), coloring3.getUnderlineColor(), coloring3.getStrikeThroughColor(), coloring3.getWaveUnderlineColor());
        }
        return coloring;
    }

    static {
        ITALIC = SettingsDefaults.defaultFont.deriveFont(2);
        BOLD = SettingsDefaults.defaultFont.deriveFont(1);
        BOLDITALIC = SettingsDefaults.defaultFont.deriveFont(3);
        type2Coloring = new HashMap<ColoringAttributes, Coloring>();
        type2Coloring.put(ColoringAttributes.UNUSED, new Coloring(null, 0, Color.GRAY, null));
        type2Coloring.put(ColoringAttributes.ABSTRACT, new Coloring(null, 0, null, null));
        type2Coloring.put(ColoringAttributes.FIELD, new Coloring(BOLD, 2, new Color(9, 134, 24), null));
        type2Coloring.put(ColoringAttributes.LOCAL_VARIABLE, new Coloring(null, 0, null, null));
        type2Coloring.put(ColoringAttributes.PARAMETER, new Coloring(null, 2, new Color(160, 96, 1), null));
        type2Coloring.put(ColoringAttributes.METHOD, new Coloring(BOLD, 2, null, null));
        type2Coloring.put(ColoringAttributes.CONSTRUCTOR, new Coloring(BOLD, 2, null, null));
        type2Coloring.put(ColoringAttributes.CLASS, new Coloring(null, 0, null, null));
        type2Coloring.put(ColoringAttributes.DEPRECATED, new Coloring(null, 0, null, null, null, new Color(64, 64, 64)));
        type2Coloring.put(ColoringAttributes.STATIC, new Coloring(ITALIC, 2, null, null));
        type2Coloring.put(ColoringAttributes.PRIVATE, new Coloring(null, 0, null, null));
        type2Coloring.put(ColoringAttributes.PACKAGE_PRIVATE, new Coloring(null, 0, null, null));
        type2Coloring.put(ColoringAttributes.PROTECTED, new Coloring(null, 0, null, null));
        type2Coloring.put(ColoringAttributes.PUBLIC, new Coloring(null, 0, null, null));
        type2Coloring.put(ColoringAttributes.TYPE_PARAMETER_DECLARATION, new Coloring(null, 0, null, Color.LIGHT_GRAY));
        type2Coloring.put(ColoringAttributes.TYPE_PARAMETER_USE, new Coloring(null, 0, null, Color.GREEN));
        type2Coloring.put(ColoringAttributes.UNDEFINED, new Coloring(null, 0, Color.RED, null));
        type2Coloring.put(ColoringAttributes.MARK_OCCURRENCES, new Coloring(null, 0, null, new Color(236, 235, 163)));
    }
}

