/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import com.sun.source.tree.CatchTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.modules.editor.highlights.spi.Highlight;
import org.netbeans.modules.java.editor.semantic.ColoringAttributes;
import org.netbeans.modules.java.editor.semantic.MarkOccurencesHighlighter;
import org.netbeans.modules.java.editor.semantic.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodExitDetector
extends CancellableTreePathScanner<Boolean, Stack<Tree>> {
    private CompilationInfo info;
    private Document doc;
    private Set<Highlight> highlights;
    private Collection<TypeMirror> exceptions;
    private Stack<Map<TypeMirror, List<Highlight>>> exceptions2HighlightsStack;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Highlight> process(CompilationInfo compilationInfo, Document document, MethodTree methodTree, Collection<Tree> collection) {
        this.info = compilationInfo;
        this.doc = document;
        this.highlights = new HashSet<Highlight>();
        this.exceptions2HighlightsStack = new Stack();
        this.exceptions2HighlightsStack.push(null);
        try {
            Object object;
            HashSet<Highlight> hashSet = new HashSet<Highlight>();
            CompilationUnitTree compilationUnitTree = compilationInfo.getCompilationUnit();
            Boolean bl = (Boolean)this.scan(TreePath.getPath(compilationUnitTree, (Tree)methodTree), null);
            if (this.isCanceled()) {
                Set<Highlight> set = Collections.emptySet();
                return set;
            }
            if (collection == null) {
                int n;
                hashSet.addAll(this.highlights);
                if (bl != Boolean.TRUE && (n = Utilities.findLastBracket(methodTree, compilationUnitTree, compilationInfo.getTrees().getSourcePositions(), document)) != -1) {
                    hashSet.add(Utilities.createHighlight(compilationUnitTree, compilationInfo.getTrees().getSourcePositions(), document, n, n + 1, EnumSet.of(ColoringAttributes.MARK_OCCURRENCES), MarkOccurencesHighlighter.ES_COLOR));
                }
            }
            ArrayList<Object> arrayList = null;
            if (collection != null) {
                arrayList = new ArrayList<Object>();
                for (Tree map2 : collection) {
                    if (this.isCanceled()) {
                        object = Collections.emptySet();
                        return object;
                    }
                    object = compilationInfo.getTrees().getTypeMirror(TreePath.getPath(compilationUnitTree, map2));
                    if (object == null) continue;
                    arrayList.add(object);
                }
            }
            Types types = compilationInfo.getTypes();
            assert (this.exceptions2HighlightsStack.size() == 1) : this.exceptions2HighlightsStack.size();
            Map<TypeMirror, List<Highlight>> map = this.exceptions2HighlightsStack.peek();
            if (map != null) {
                for (TypeMirror typeMirror : map.keySet()) {
                    if (this.isCanceled()) {
                        Set<Highlight> set = Collections.emptySet();
                        return set;
                    }
                    boolean set = true;
                    if (arrayList != null) {
                        set = false;
                        for (TypeMirror typeMirror2 : arrayList) {
                            set |= types.isAssignable(typeMirror, typeMirror2);
                        }
                    }
                    if (!set) continue;
                    hashSet.addAll((Collection)map.get(typeMirror));
                }
            }
            object = hashSet;
            return object;
        }
        finally {
            this.info = null;
            this.doc = null;
            this.highlights = null;
            this.exceptions2HighlightsStack = null;
        }
    }

    private void addToExceptionsMap(TypeMirror typeMirror, Highlight highlight) {
        List<Highlight> list;
        if (highlight == null) {
            return;
        }
        Map<TypeMirror, List<Highlight>> map = this.exceptions2HighlightsStack.peek();
        if (map == null) {
            map = new HashMap<TypeMirror, List<Highlight>>();
            this.exceptions2HighlightsStack.pop();
            this.exceptions2HighlightsStack.push(map);
        }
        if ((list = map.get(typeMirror)) == null) {
            list = new ArrayList<Highlight>();
            map.put(typeMirror, list);
        }
        list.add(highlight);
    }

    private void doPopup() {
        Map<TypeMirror, List<Highlight>> map = this.exceptions2HighlightsStack.pop();
        if (map == null) {
            return;
        }
        Map<TypeMirror, List<Highlight>> map2 = this.exceptions2HighlightsStack.pop();
        if (map2 == null) {
            this.exceptions2HighlightsStack.push(map);
            return;
        }
        for (TypeMirror typeMirror : map.keySet()) {
            List<Highlight> list = map.get(typeMirror);
            List<Highlight> list2 = map2.get(typeMirror);
            if (list == null) continue;
            if (list2 == null) {
                map2.put(typeMirror, list);
                continue;
            }
            list2.addAll(list);
        }
        this.exceptions2HighlightsStack.push(map2);
    }

    private Highlight createHighlight(TreePath treePath) {
        return Utilities.createHighlight(this.info.getCompilationUnit(), this.info.getTrees().getSourcePositions(), this.doc, treePath, EnumSet.of(ColoringAttributes.MARK_OCCURRENCES), MarkOccurencesHighlighter.ES_COLOR);
    }

    public Boolean visitTry(TryTree tryTree, Stack<Tree> stack) {
        this.exceptions2HighlightsStack.push(null);
        Boolean bl = (Boolean)this.scan(tryTree.getBlock(), stack);
        boolean bl2 = true;
        for (CatchTree catchTree : tryTree.getCatches()) {
            Boolean bl3 = (Boolean)this.scan(catchTree, stack);
            bl2 &= bl3 == Boolean.TRUE;
        }
        Boolean bl4 = (Boolean)this.scan(tryTree.getFinallyBlock(), stack);
        this.doPopup();
        if (bl == Boolean.TRUE && bl2) {
            return Boolean.TRUE;
        }
        return bl4;
    }

    public Boolean visitReturn(ReturnTree returnTree, Stack<Tree> stack) {
        Highlight highlight;
        if (this.exceptions == null && (highlight = this.createHighlight(this.getCurrentPath())) != null) {
            this.highlights.add(highlight);
        }
        super.visitReturn(returnTree, stack);
        return Boolean.TRUE;
    }

    public Boolean visitCatch(CatchTree catchTree, Stack<Tree> stack) {
        TypeMirror typeMirror = this.info.getTrees().getTypeMirror(new TreePath(new TreePath(this.getCurrentPath(), catchTree.getParameter()), catchTree.getParameter().getType()));
        Types types = this.info.getTypes();
        if (typeMirror != null) {
            HashSet<TypeMirror> hashSet = new HashSet<TypeMirror>();
            Map<TypeMirror, List<Highlight>> map = this.exceptions2HighlightsStack.peek();
            if (map != null) {
                for (TypeMirror typeMirror2 : map.keySet()) {
                    if (!types.isAssignable(typeMirror2, typeMirror)) continue;
                    hashSet.add(typeMirror2);
                }
                for (TypeMirror typeMirror2 : hashSet) {
                    map.remove(typeMirror2);
                }
            }
        }
        this.scan(catchTree.getParameter(), stack);
        return (Boolean)this.scan(catchTree.getBlock(), stack);
    }

    public Boolean visitMethodInvocation(MethodInvocationTree methodInvocationTree, Stack<Tree> stack) {
        Element element = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), methodInvocationTree.getMethodSelect()));
        if (element == null) {
            System.err.println("Warning: decl == null");
            System.err.println("tree=" + methodInvocationTree);
        }
        if (element != null && element.getKind() == ElementKind.METHOD) {
            for (TypeMirror typeMirror : ((ExecutableElement)element).getThrownTypes()) {
                this.addToExceptionsMap(typeMirror, this.createHighlight(this.getCurrentPath()));
            }
        }
        super.visitMethodInvocation(methodInvocationTree, stack);
        return null;
    }

    public Boolean visitThrow(ThrowTree throwTree, Stack<Tree> stack) {
        this.addToExceptionsMap(this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), throwTree.getExpression())), this.createHighlight(this.getCurrentPath()));
        super.visitThrow(throwTree, stack);
        return Boolean.TRUE;
    }

    public Boolean visitNewClass(NewClassTree newClassTree, Stack<Tree> stack) {
        Element element = this.info.getTrees().getElement(this.getCurrentPath());
        if (element != null && element.getKind() == ElementKind.CONSTRUCTOR) {
            for (TypeMirror typeMirror : ((ExecutableElement)element).getThrownTypes()) {
                this.addToExceptionsMap(typeMirror, this.createHighlight(this.getCurrentPath()));
            }
        }
        super.visitNewClass(newClassTree, stack);
        return null;
    }

    public Boolean visitMethod(MethodTree methodTree, Stack<Tree> stack) {
        this.scan(methodTree.getModifiers(), stack);
        this.scan(methodTree.getReturnType(), stack);
        this.scan(methodTree.getTypeParameters(), stack);
        this.scan(methodTree.getParameters(), stack);
        this.scan(methodTree.getThrows(), stack);
        return (Boolean)this.scan(methodTree.getBody(), stack);
    }

    public Boolean visitIf(IfTree ifTree, Stack<Tree> stack) {
        this.scan(ifTree.getCondition(), stack);
        Boolean bl = (Boolean)this.scan(ifTree.getThenStatement(), stack);
        Boolean bl2 = (Boolean)this.scan(ifTree.getElseStatement(), stack);
        if (bl == Boolean.TRUE && bl2 == Boolean.TRUE) {
            return Boolean.TRUE;
        }
        return null;
    }
}

