/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.api.timers.TimesCollector;
import org.netbeans.modules.editor.highlights.spi.Highlight;
import org.netbeans.modules.editor.highlights.spi.Highlighter;
import org.netbeans.modules.java.editor.semantic.ColoringAttributes;
import org.netbeans.modules.java.editor.semantic.OccurrencesMarkProvider;
import org.netbeans.modules.java.editor.semantic.RemoveUnusedImportFix;
import org.netbeans.modules.java.editor.semantic.ScanningCancellableTask;
import org.netbeans.modules.java.editor.semantic.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticHighlighter
extends ScanningCancellableTask<CompilationInfo> {
    private FileObject file;
    static ErrorDescriptionSetter ERROR_DESCRIPTION_SETTER = new ErrorDescriptionSetter(){

        @Override
        public void setErrors(Document document, List<ErrorDescription> list) {
            HintsController.setErrors((Document)document, (String)"semantic-highlighter", list);
        }
    };

    SemanticHighlighter(FileObject fileObject) {
        this.file = fileObject;
    }

    public Document getDocument() {
        try {
            DataObject dataObject = DataObject.find((FileObject)this.file);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie == null) {
                return null;
            }
            return editorCookie.getDocument();
        }
        catch (IOException iOException) {
            Logger.getLogger(SemanticHighlighter.class.getName()).log(Level.INFO, "SemanticHighlighter: Cannot find DataObject for file: " + FileUtil.getFileDisplayName((FileObject)this.file), iOException);
            return null;
        }
    }

    @Override
    public void run(CompilationInfo compilationInfo) {
        this.resume();
        Document document = this.getDocument();
        if (document == null) {
            Logger.getLogger(SemanticHighlighter.class.getName()).log(Level.INFO, "SemanticHighlighter: Cannot get document!");
            return;
        }
        Set<Highlight> set = this.process(compilationInfo, document);
        if (this.isCancelled()) {
            return;
        }
        Highlighter.getDefault().setHighlights(this.file, "semantic", set);
        OccurrencesMarkProvider.get(document).setSematic(set);
    }

    private void removeImport(Document document, int n, int n2) {
        try {
            boolean bl;
            int n3 = document.getLength();
            while (n > 0 && "\t ".indexOf(document.getText(n - 1, 1).charAt(0)) != -1) {
                --n;
            }
            boolean bl2 = bl = n == 0 || "\n".equals(document.getText(n - 1, 1));
            while (n2 < n3 && "\t ".indexOf(document.getText(n2, 1).charAt(0)) != -1) {
                ++n2;
            }
            if (bl && "\n".equals(document.getText(n2, 1))) {
                ++n2;
            }
            document.remove(n, n2 - n);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
    }

    Set<Highlight> process(CompilationInfo compilationInfo, Document document) {
        Iterable<Tree> iterable;
        DetectorVisitor detectorVisitor = new DetectorVisitor(compilationInfo, document);
        long l = System.currentTimeMillis();
        HashSet<Highlight> hashSet = new HashSet<Highlight>();
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        CompilationUnitTree compilationUnitTree = compilationInfo.getCompilationUnit();
        this.scan(detectorVisitor, (Tree)compilationUnitTree, null);
        if (this.isCancelled()) {
            return Collections.emptySet();
        }
        ArrayList<TreePathHandle> arrayList2 = new ArrayList<TreePathHandle>();
        RemoveUnusedImportFix removeUnusedImportFix = RemoveUnusedImportFix.create(this.file, arrayList2);
        for (Element element : detectorVisitor.type2Highlight.keySet()) {
            if (this.isCancelled()) {
                return Collections.emptySet();
            }
            iterable = (TreePath)detectorVisitor.type2Highlight.get(element);
            if (element == null || element.getSimpleName() == null) continue;
            Highlight highlight = Utilities.createHighlight(compilationUnitTree, compilationInfo.getTrees().getSourcePositions(), document, iterable, EnumSet.of(ColoringAttributes.UNUSED), Color.GRAY);
            if (highlight != null) {
                hashSet.add(highlight);
            }
            long l2 = compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationUnitTree, ((TreePath)iterable).getLeaf());
            int n = (int)compilationInfo.getCompilationUnit().getLineMap().getLineNumber(l2);
            TreePathHandle treePathHandle = TreePathHandle.create(iterable, (CompilationInfo)compilationInfo);
            RemoveUnusedImportFix removeUnusedImportFix2 = RemoveUnusedImportFix.create(this.file, treePathHandle);
            arrayList2.add(treePathHandle);
            arrayList.add(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.VERIFIER, (String)"Unused import", (LazyFixList)new FixAllImportsFixList(removeUnusedImportFix2, removeUnusedImportFix, arrayList2), (Document)document, (int)n));
        }
        for (Element element : detectorVisitor.type2Uses.keySet()) {
            if (this.isCancelled()) {
                return Collections.emptySet();
            }
            iterable = (List)detectorVisitor.type2Uses.get(element);
            for (Use use : iterable) {
                if (use.spec == null) continue;
                if (use.type.contains((Object)UseTypes.Element) && Utilities.isPrivateElement(element)) {
                    if ((element.getKind().isField() || SemanticHighlighter.isLocalVariableClosure(element)) && !this.hasAllTypes((List<Use>)iterable, (Collection<UseTypes>)EnumSet.of(UseTypes.READ, UseTypes.WRITE))) {
                        use.spec.add(ColoringAttributes.UNUSED);
                    }
                    if (!(element.getKind() != ElementKind.CONSTRUCTOR && element.getKind() != ElementKind.METHOD || this.hasAllTypes((List<Use>)iterable, (Collection<UseTypes>)EnumSet.of(UseTypes.EXECUTE)))) {
                        use.spec.add(ColoringAttributes.UNUSED);
                    }
                    if ((element.getKind().isClass() || element.getKind().isInterface()) && !this.hasAllTypes((List<Use>)iterable, (Collection<UseTypes>)EnumSet.of(UseTypes.CLASS_USE))) {
                        use.spec.add(ColoringAttributes.UNUSED);
                    }
                }
                EnumSet<ColoringAttributes> enumSet = EnumSet.copyOf(use.spec);
                Highlight highlight = Utilities.createHighlight(compilationUnitTree, compilationInfo.getTrees().getSourcePositions(), document, use.tree, enumSet, null);
                if (highlight == null) continue;
                hashSet.add(highlight);
            }
        }
        if (this.isCancelled()) {
            return Collections.emptySet();
        }
        ERROR_DESCRIPTION_SETTER.setErrors(document, arrayList);
        TimesCollector.getDefault().reportTime(((DataObject)document.getProperty("stream")).getPrimaryFile(), "semantic", "Semantic", System.currentTimeMillis() - l);
        return hashSet;
    }

    private boolean hasAllTypes(List<Use> list, Collection<UseTypes> collection) {
        EnumSet<UseTypes> enumSet = EnumSet.copyOf(collection);
        for (Use use : list) {
            if (collection.isEmpty()) {
                return true;
            }
            collection.removeAll(use.type);
        }
        return collection.isEmpty();
    }

    private static boolean isLocalVariableClosure(Element element) {
        return element.getKind() == ElementKind.PARAMETER || element.getKind() == ElementKind.LOCAL_VARIABLE || element.getKind() == ElementKind.EXCEPTION_PARAMETER;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DetectorVisitor
    extends CancellableTreePathScanner<Void, EnumSet<UseTypes>> {
        private CompilationInfo info;
        private Document doc;
        private Map<Element, List<Use>> type2Uses;
        private Map<Element, TreePath> type2Highlight;
        private SourcePositions sourcePositions;
        private static final Set<Tree.Kind> LITERALS = EnumSet.of(Tree.Kind.BOOLEAN_LITERAL, new Tree.Kind[]{Tree.Kind.CHAR_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL, Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.STRING_LITERAL});

        private DetectorVisitor(CompilationInfo compilationInfo, Document document) {
            this.info = compilationInfo;
            this.doc = document;
            this.type2Uses = new HashMap<Element, List<Use>>();
            this.type2Highlight = new HashMap<Element, TreePath>();
        }

        private Highlight createHighlight(CompilationUnitTree compilationUnitTree, SourcePositions sourcePositions, TreePath treePath, Collection<ColoringAttributes> collection, Color color) {
            return Utilities.createHighlight(compilationUnitTree, sourcePositions, this.doc, treePath, collection, color);
        }

        public Void visitAssignment(AssignmentTree assignmentTree, EnumSet<UseTypes> enumSet) {
            this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), assignmentTree.getVariable()), EnumSet.of(UseTypes.WRITE));
            ExpressionTree expressionTree = assignmentTree.getExpression();
            if (expressionTree instanceof IdentifierTree) {
                TreePath treePath = new TreePath(this.getCurrentPath(), expressionTree);
                this.resolveType(treePath);
                this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.READ));
            }
            this.scan(assignmentTree.getVariable(), EnumSet.of(UseTypes.WRITE));
            this.scan(assignmentTree.getExpression(), null);
            return (Void)super.visitAssignment(assignmentTree, null);
        }

        public Void visitCompoundAssignment(CompoundAssignmentTree compoundAssignmentTree, EnumSet<UseTypes> enumSet) {
            this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), compoundAssignmentTree.getVariable()), EnumSet.of(UseTypes.WRITE));
            ExpressionTree expressionTree = compoundAssignmentTree.getExpression();
            if (expressionTree instanceof IdentifierTree) {
                TreePath treePath = new TreePath(this.getCurrentPath(), expressionTree);
                this.resolveType(treePath);
                this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.READ));
            }
            this.scan(compoundAssignmentTree.getVariable(), EnumSet.of(UseTypes.WRITE));
            this.scan(compoundAssignmentTree.getExpression(), null);
            return (Void)super.visitCompoundAssignment(compoundAssignmentTree, null);
        }

        public Void visitReturn(ReturnTree returnTree, EnumSet<UseTypes> enumSet) {
            if (returnTree.getExpression() instanceof IdentifierTree) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), returnTree.getExpression()), EnumSet.of(UseTypes.READ));
            }
            super.visitReturn(returnTree, null);
            return null;
        }

        public Void visitMemberSelect(MemberSelectTree memberSelectTree, EnumSet<UseTypes> enumSet) {
            Object object;
            ExpressionTree expressionTree = memberSelectTree.getExpression();
            if (expressionTree instanceof IdentifierTree) {
                object = new TreePath(this.getCurrentPath(), expressionTree);
                this.resolveType((TreePath)object);
                this.handlePossibleIdentifier((TreePath)object, EnumSet.of(UseTypes.READ));
            }
            if ((object = this.info.getTrees().getElement(this.getCurrentPath())) != null && object.getKind().isField()) {
                this.handlePossibleIdentifier(this.getCurrentPath(), EnumSet.of(UseTypes.READ));
            }
            super.visitMemberSelect(memberSelectTree, null);
            return null;
        }

        private void addModifiers(Element element, Collection<ColoringAttributes> collection) {
            if (element.getModifiers().contains((Object)Modifier.STATIC)) {
                collection.add(ColoringAttributes.STATIC);
            }
            if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                collection.add(ColoringAttributes.ABSTRACT);
            }
            boolean bl = false;
            if (element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                collection.add(ColoringAttributes.PUBLIC);
                bl = true;
            }
            if (element.getModifiers().contains((Object)Modifier.PROTECTED)) {
                collection.add(ColoringAttributes.PROTECTED);
                bl = true;
            }
            if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
                collection.add(ColoringAttributes.PRIVATE);
                bl = true;
            }
            if (!bl && !SemanticHighlighter.isLocalVariableClosure(element)) {
                collection.add(ColoringAttributes.PACKAGE_PRIVATE);
            }
            if (this.info.getElements().isDeprecated(element)) {
                collection.add(ColoringAttributes.DEPRECATED);
            }
        }

        private Collection<ColoringAttributes> getMethodColoring(ExecutableElement executableElement) {
            ArrayList<ColoringAttributes> arrayList = new ArrayList<ColoringAttributes>();
            this.addModifiers(executableElement, arrayList);
            if (executableElement.getKind() == ElementKind.CONSTRUCTOR) {
                arrayList.add(ColoringAttributes.CONSTRUCTOR);
            } else {
                arrayList.add(ColoringAttributes.METHOD);
            }
            return arrayList;
        }

        private Collection<ColoringAttributes> getVariableColoring(Element element) {
            ArrayList<ColoringAttributes> arrayList = new ArrayList<ColoringAttributes>();
            this.addModifiers(element, arrayList);
            if (element.getKind().isField()) {
                arrayList.add(ColoringAttributes.FIELD);
                return arrayList;
            }
            if (element.getKind() == ElementKind.LOCAL_VARIABLE || element.getKind() == ElementKind.EXCEPTION_PARAMETER) {
                arrayList.add(ColoringAttributes.LOCAL_VARIABLE);
                return arrayList;
            }
            if (element.getKind() == ElementKind.PARAMETER) {
                arrayList.add(ColoringAttributes.PARAMETER);
                return arrayList;
            }
            assert (false);
            return null;
        }

        private void handlePossibleIdentifier(TreePath treePath, Collection<UseTypes> collection) {
            this.handlePossibleIdentifier(treePath, collection, null, false);
        }

        private void handlePossibleIdentifier(TreePath treePath, Collection<UseTypes> collection, Element element, boolean bl) {
            if (Utilities.isKeyword(treePath.getLeaf())) {
                return;
            }
            if (treePath.getLeaf().getKind() == Tree.Kind.PRIMITIVE_TYPE) {
                return;
            }
            if (LITERALS.contains((Object)treePath.getLeaf().getKind())) {
                return;
            }
            element = !bl ? this.info.getTrees().getElement(treePath) : element;
            Collection<ColoringAttributes> collection2 = null;
            if (element != null && (element.getKind().isField() || SemanticHighlighter.isLocalVariableClosure(element))) {
                collection2 = this.getVariableColoring(element);
            }
            if (element != null && element instanceof ExecutableElement) {
                collection2 = this.getMethodColoring((ExecutableElement)element);
            }
            if (element != null && (element.getKind().isClass() || element.getKind().isInterface())) {
                if (collection.contains((Object)UseTypes.READ)) {
                    collection.remove((Object)UseTypes.READ);
                    collection.add(UseTypes.CLASS_USE);
                }
                collection2 = new ArrayList<ColoringAttributes>();
                this.addModifiers(element, collection2);
            }
            if (collection2 != null) {
                this.addUse(element, collection, treePath, collection2);
            }
        }

        private void addUse(Element element, Collection<UseTypes> collection, TreePath treePath, Collection<ColoringAttributes> collection2) {
            List<Use> list = this.type2Uses.get(element);
            if (list == null) {
                list = new ArrayList<Use>();
                this.type2Uses.put(element, list);
            }
            Use use = new Use(collection, treePath, collection2);
            list.add(use);
        }

        public Void visitTypeCast(TypeCastTree typeCastTree, EnumSet<UseTypes> enumSet) {
            this.resolveType(new TreePath(this.getCurrentPath(), typeCastTree.getType()));
            ExpressionTree expressionTree = typeCastTree.getExpression();
            if (expressionTree instanceof IdentifierTree) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), expressionTree), EnumSet.of(UseTypes.READ));
            }
            super.visitTypeCast(typeCastTree, enumSet);
            return null;
        }

        public Void visitInstanceOf(InstanceOfTree instanceOfTree, EnumSet<UseTypes> enumSet) {
            ExpressionTree expressionTree = instanceOfTree.getExpression();
            if (expressionTree instanceof IdentifierTree) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), expressionTree), EnumSet.of(UseTypes.READ));
            }
            TreePath treePath = new TreePath(this.getCurrentPath(), instanceOfTree.getType());
            this.resolveType(treePath);
            this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.CLASS_USE));
            super.visitInstanceOf(instanceOfTree, null);
            return null;
        }

        public Void visitCompilationUnit(CompilationUnitTree compilationUnitTree, EnumSet<UseTypes> enumSet) {
            this.scan(compilationUnitTree.getPackageAnnotations(), enumSet);
            this.scan(compilationUnitTree.getImports(), enumSet);
            this.scan(compilationUnitTree.getTypeDecls(), enumSet);
            return null;
        }

        public Void visitMethodInvocation(MethodInvocationTree methodInvocationTree, EnumSet<UseTypes> enumSet) {
            Iterator<? extends Tree> iterator;
            ExpressionTree expressionTree = methodInvocationTree.getMethodSelect();
            boolean bl = false;
            if (expressionTree.getKind() == Tree.Kind.IDENTIFIER && ("super".equals(iterator = ((IdentifierTree)expressionTree).getName().toString()) || "this".equals(iterator))) {
                Element object = this.info.getTrees().getElement(this.getCurrentPath());
                this.addUse(object, EnumSet.of(UseTypes.EXECUTE), null, null);
                bl = true;
            }
            if (!bl) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), expressionTree), EnumSet.of(UseTypes.EXECUTE));
            }
            for (ExpressionTree expressionTree2 : methodInvocationTree.getArguments()) {
                if (!(expressionTree2 instanceof IdentifierTree)) continue;
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), expressionTree2), EnumSet.of(UseTypes.READ));
            }
            for (Tree tree : methodInvocationTree.getTypeArguments()) {
                if (!(tree instanceof IdentifierTree)) continue;
                this.resolveType(new TreePath(this.getCurrentPath(), tree));
            }
            super.visitMethodInvocation(methodInvocationTree, null);
            return null;
        }

        public Void visitIdentifier(IdentifierTree identifierTree, EnumSet<UseTypes> enumSet) {
            if (enumSet != null) {
                this.handlePossibleIdentifier(this.getCurrentPath(), enumSet);
            }
            super.visitIdentifier(identifierTree, null);
            return null;
        }

        public Void visitMethod(MethodTree methodTree, EnumSet<UseTypes> enumSet) {
            Element element;
            this.handlePossibleIdentifier(this.getCurrentPath(), EnumSet.of(UseTypes.Element));
            for (ExpressionTree object2 : methodTree.getThrows()) {
                TreePath treePath = new TreePath(this.getCurrentPath(), object2);
                this.resolveType(treePath);
                this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.CLASS_USE));
            }
            if (methodTree.getReturnType() != null) {
                this.resolveType(new TreePath(this.getCurrentPath(), methodTree.getReturnType()));
            }
            EnumSet<UseTypes> enumSet2 = (element = this.info.getTrees().getElement(this.getCurrentPath())) != null && element.getModifiers().contains((Object)Modifier.ABSTRACT) ? EnumSet.of(UseTypes.WRITE, UseTypes.READ) : EnumSet.of(UseTypes.WRITE);
            this.scan(methodTree.getModifiers(), null);
            this.scan(methodTree.getReturnType(), EnumSet.of(UseTypes.CLASS_USE));
            this.scan(methodTree.getTypeParameters(), null);
            this.scan(methodTree.getParameters(), enumSet2);
            this.scan(methodTree.getThrows(), null);
            this.scan(methodTree.getBody(), null);
            return null;
        }

        public Void visitExpressionStatement(ExpressionStatementTree expressionStatementTree, EnumSet<UseTypes> enumSet) {
            super.visitExpressionStatement(expressionStatementTree, null);
            return null;
        }

        public Void visitParenthesized(ParenthesizedTree parenthesizedTree, EnumSet<UseTypes> enumSet) {
            ExpressionTree expressionTree = parenthesizedTree.getExpression();
            if (expressionTree instanceof IdentifierTree) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), expressionTree), EnumSet.of(UseTypes.READ));
            }
            super.visitParenthesized(parenthesizedTree, null);
            return null;
        }

        public Void visitEnhancedForLoop(EnhancedForLoopTree enhancedForLoopTree, EnumSet<UseTypes> enumSet) {
            this.scan(enhancedForLoopTree.getVariable(), EnumSet.of(UseTypes.WRITE));
            if (enhancedForLoopTree.getExpression().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), enhancedForLoopTree.getExpression()), EnumSet.of(UseTypes.READ));
            }
            this.scan(enhancedForLoopTree.getExpression(), null);
            this.scan(enhancedForLoopTree.getStatement(), null);
            return null;
        }

        public Void visitImport(ImportTree importTree, EnumSet<UseTypes> enumSet) {
            Element element;
            if (!importTree.isStatic() && (element = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), importTree.getQualifiedIdentifier()))) != null && element.asType().getKind() != TypeKind.ERROR) {
                this.type2Highlight.put(element, this.getCurrentPath());
            }
            super.visitImport(importTree, null);
            return null;
        }

        private String getSimple(String string) {
            int n = string.lastIndexOf(46);
            if (n != -1) {
                return string.substring(n + 1);
            }
            return string;
        }

        public Void visitVariable(VariableTree variableTree, EnumSet<UseTypes> enumSet) {
            Object object;
            TreePath treePath = new TreePath(this.getCurrentPath(), variableTree.getType());
            if (treePath.getLeaf() instanceof ArrayTypeTree) {
                treePath = new TreePath(treePath, ((ArrayTypeTree)treePath.getLeaf()).getType());
            }
            this.resolveType(treePath);
            if (treePath.getLeaf().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.CLASS_USE));
            }
            EnumSet<UseTypes> enumSet2 = null;
            boolean bl = false;
            if (variableTree.getInitializer() != null) {
                enumSet2 = EnumSet.of(UseTypes.Element, UseTypes.WRITE);
                if (variableTree.getInitializer().getKind() == Tree.Kind.IDENTIFIER) {
                    this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), variableTree.getInitializer()), EnumSet.of(UseTypes.READ));
                }
            } else {
                object = this.info.getTrees().getElement(this.getCurrentPath());
                enumSet2 = object != null && object.getKind() == ElementKind.FIELD ? EnumSet.of(UseTypes.Element, UseTypes.WRITE) : EnumSet.of(UseTypes.Element);
            }
            if (enumSet != null) {
                object = new HashSet();
                object.addAll(enumSet2);
                object.addAll(enumSet);
                enumSet2 = EnumSet.copyOf(object);
            }
            this.handlePossibleIdentifier(this.getCurrentPath(), enumSet2);
            super.visitVariable(variableTree, null);
            return null;
        }

        private boolean isParameter(VariableTree variableTree, MethodTree methodTree) {
            for (VariableTree variableTree2 : methodTree.getParameters()) {
                if (variableTree != variableTree2) continue;
                return true;
            }
            return false;
        }

        public Void visitAnnotation(AnnotationTree annotationTree, EnumSet<UseTypes> enumSet) {
            TreePath treePath = new TreePath(this.getCurrentPath(), annotationTree.getAnnotationType());
            this.resolveType(treePath);
            this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.CLASS_USE));
            super.visitAnnotation(annotationTree, EnumSet.noneOf(UseTypes.class));
            return null;
        }

        public Void visitNewClass(NewClassTree newClassTree, EnumSet<UseTypes> enumSet) {
            ExpressionTree expressionTree = newClassTree.getIdentifier();
            TreePath treePath = expressionTree.getKind() == Tree.Kind.PARAMETERIZED_TYPE ? new TreePath(new TreePath(this.getCurrentPath(), expressionTree), ((ParameterizedTypeTree)((Object)expressionTree)).getType()) : new TreePath(this.getCurrentPath(), expressionTree);
            this.resolveType(treePath);
            this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.EXECUTE), this.info.getTrees().getElement(this.getCurrentPath()), true);
            Element element = this.info.getTrees().getElement(treePath);
            if (element != null) {
                this.addUse(element, EnumSet.of(UseTypes.CLASS_USE), null, null);
            }
            for (ExpressionTree expressionTree2 : newClassTree.getArguments()) {
                if (!(expressionTree2 instanceof IdentifierTree)) continue;
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), expressionTree2), EnumSet.of(UseTypes.READ));
            }
            super.visitNewClass(newClassTree, null);
            return null;
        }

        public Void visitParameterizedType(ParameterizedTypeTree parameterizedTypeTree, EnumSet<UseTypes> enumSet) {
            if (this.getCurrentPath().getParentPath().getLeaf().getKind() != Tree.Kind.NEW_CLASS) {
                TreePath treePath = new TreePath(this.getCurrentPath(), parameterizedTypeTree.getType());
                this.resolveType(treePath);
                this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.CLASS_USE));
            }
            for (Tree tree : parameterizedTypeTree.getTypeArguments()) {
                TreePath treePath = new TreePath(this.getCurrentPath(), tree);
                this.resolveType(treePath);
                this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.CLASS_USE));
            }
            super.visitParameterizedType(parameterizedTypeTree, null);
            return null;
        }

        public Void visitBinary(BinaryTree binaryTree, EnumSet<UseTypes> enumSet) {
            TreePath treePath;
            ExpressionTree expressionTree = binaryTree.getLeftOperand();
            ExpressionTree expressionTree2 = binaryTree.getRightOperand();
            if (expressionTree instanceof IdentifierTree) {
                treePath = new TreePath(this.getCurrentPath(), expressionTree);
                this.resolveType(treePath);
                this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.READ));
            }
            if (expressionTree2 instanceof IdentifierTree) {
                treePath = new TreePath(this.getCurrentPath(), expressionTree2);
                this.resolveType(treePath);
                this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.READ));
            }
            super.visitBinary(binaryTree, null);
            return null;
        }

        public Void visitClass(ClassTree classTree, EnumSet<UseTypes> enumSet) {
            Tree tree = classTree.getExtendsClause();
            if (tree != null) {
                Iterator<? extends TypeParameterTree> iterator = new TreePath(this.getCurrentPath(), tree);
                this.resolveType((TreePath)((Object)iterator));
                this.handlePossibleIdentifier((TreePath)((Object)iterator), (Collection<UseTypes>)EnumSet.of(UseTypes.CLASS_USE));
            }
            for (Tree tree2 : classTree.getImplementsClause()) {
                TreePath treePath = new TreePath(this.getCurrentPath(), tree2);
                this.resolveType(treePath);
                this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.CLASS_USE));
            }
            for (TypeParameterTree typeParameterTree : classTree.getTypeParameters()) {
                for (Tree tree2 : typeParameterTree.getBounds()) {
                    TreePath treePath = new TreePath(new TreePath(this.getCurrentPath(), typeParameterTree), tree2);
                    this.resolveType(treePath);
                    this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.CLASS_USE));
                }
            }
            this.handlePossibleIdentifier(this.getCurrentPath(), EnumSet.of(UseTypes.Element));
            super.visitClass(classTree, null);
            return null;
        }

        public Void visitUnary(UnaryTree unaryTree, EnumSet<UseTypes> enumSet) {
            if (unaryTree.getExpression() instanceof IdentifierTree) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), unaryTree.getExpression()), EnumSet.of(UseTypes.READ));
            }
            super.visitUnary(unaryTree, enumSet);
            return null;
        }

        public Void visitArrayAccess(ArrayAccessTree arrayAccessTree, EnumSet<UseTypes> enumSet) {
            if (arrayAccessTree.getExpression() != null && arrayAccessTree.getExpression().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), arrayAccessTree.getExpression()), EnumSet.of(UseTypes.READ));
            }
            if (arrayAccessTree.getIndex() instanceof IdentifierTree) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), arrayAccessTree.getIndex()), EnumSet.of(UseTypes.READ));
            }
            super.visitArrayAccess(arrayAccessTree, null);
            return null;
        }

        public Void visitNewArray(NewArrayTree newArrayTree, EnumSet<UseTypes> enumSet) {
            if (newArrayTree.getType() != null) {
                this.resolveType(new TreePath(this.getCurrentPath(), newArrayTree.getType()));
            }
            this.scan(newArrayTree.getType(), null);
            this.scan(newArrayTree.getDimensions(), EnumSet.of(UseTypes.READ));
            this.scan(newArrayTree.getInitializers(), EnumSet.of(UseTypes.READ));
            return null;
        }

        public Void visitCatch(CatchTree catchTree, EnumSet<UseTypes> enumSet) {
            this.scan(catchTree.getParameter(), EnumSet.of(UseTypes.WRITE));
            this.scan(catchTree.getBlock(), null);
            return null;
        }

        public Void visitConditionalExpression(ConditionalExpressionTree conditionalExpressionTree, EnumSet<UseTypes> enumSet) {
            return (Void)super.visitConditionalExpression(conditionalExpressionTree, EnumSet.of(UseTypes.READ));
        }

        public Void visitAssert(AssertTree assertTree, EnumSet<UseTypes> enumSet) {
            if (assertTree.getCondition().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), assertTree.getCondition()), EnumSet.of(UseTypes.READ));
            }
            if (assertTree.getDetail() != null && assertTree.getDetail().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), assertTree.getDetail()), EnumSet.of(UseTypes.READ));
            }
            return (Void)super.visitAssert(assertTree, null);
        }

        public Void visitCase(CaseTree caseTree, EnumSet<UseTypes> enumSet) {
            if (caseTree.getExpression() != null && caseTree.getExpression().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), caseTree.getExpression()), EnumSet.of(UseTypes.READ));
            }
            return (Void)super.visitCase(caseTree, null);
        }

        public Void visitThrow(ThrowTree throwTree, EnumSet<UseTypes> enumSet) {
            if (throwTree.getExpression() != null && throwTree.getExpression().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), throwTree.getExpression()), EnumSet.of(UseTypes.READ));
            }
            return (Void)super.visitThrow(throwTree, enumSet);
        }

        public Void visitTypeParameter(TypeParameterTree typeParameterTree, EnumSet<UseTypes> enumSet) {
            for (Tree tree : typeParameterTree.getBounds()) {
                if (tree.getKind() != Tree.Kind.IDENTIFIER) continue;
                TreePath treePath = new TreePath(this.getCurrentPath(), tree);
                this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.CLASS_USE));
                this.resolveType(treePath);
            }
            return (Void)super.visitTypeParameter(typeParameterTree, enumSet);
        }

        private void resolveType(TreePath treePath) {
            FirstIdentTypeVisitor firstIdentTypeVisitor = new FirstIdentTypeVisitor();
            firstIdentTypeVisitor.scan(treePath, null);
            if (firstIdentTypeVisitor.first == null) {
                return;
            }
            Element element = this.info.getTrees().getElement(firstIdentTypeVisitor.first);
            if (element == null) {
                return;
            }
            this.type2Highlight.remove(element);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class FirstIdentTypeVisitor
        extends TreePathScanner<Void, Void> {
            private TreePath first = null;

            private FirstIdentTypeVisitor() {
            }

            @Override
            public Void visitIdentifier(IdentifierTree identifierTree, Void void_) {
                if (this.first == null) {
                    this.first = this.getCurrentPath();
                }
                return (Void)super.visitIdentifier(identifierTree, null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ErrorDescriptionSetter {
        public void setErrors(Document var1, List<ErrorDescription> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FixAllImportsFixList
    implements LazyFixList {
        private Fix removeImport;
        private Fix removeAllUnusedImports;
        private List<TreePathHandle> allUnusedImports;
        private List<Fix> fixes;

        public FixAllImportsFixList(Fix fix, Fix fix2, List<TreePathHandle> list) {
            this.removeImport = fix;
            this.removeAllUnusedImports = fix2;
            this.allUnusedImports = list;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public boolean probablyContainsFixes() {
            return true;
        }

        public synchronized List<Fix> getFixes() {
            if (this.fixes != null) {
                return this.fixes;
            }
            this.fixes = this.allUnusedImports.size() > 1 ? Arrays.asList(this.removeImport, this.removeAllUnusedImports) : Collections.singletonList(this.removeImport);
            return this.fixes;
        }

        public boolean isComputed() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Use {
        private Collection<UseTypes> type;
        private TreePath tree;
        private Collection<ColoringAttributes> spec;

        public Use(Collection<UseTypes> collection, TreePath treePath, Collection<ColoringAttributes> collection2) {
            this.type = collection;
            this.tree = treePath;
            this.spec = collection2;
        }

        public String toString() {
            return "Use: " + this.type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum UseTypes {
        READ,
        WRITE,
        EXECUTE,
        Element,
        CLASS_USE;

    }
}

