/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.errorstripe.caret;

import java.util.Collections;
import java.util.List;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.editor.errorstripe.caret.CaretMark;
import org.netbeans.modules.editor.errorstripe.privatespi.Mark;
import org.netbeans.modules.editor.errorstripe.privatespi.MarkProvider;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;

public class CaretMarkProvider
extends MarkProvider
implements CaretListener {
    private static final RequestProcessor RP = new RequestProcessor("CaretMarkProvider");
    private Mark mark;
    private JTextComponent component;

    public CaretMarkProvider(JTextComponent jTextComponent) {
        this.component = jTextComponent;
        jTextComponent.addCaretListener(this);
        this.mark = this.createMark();
    }

    private Mark createMark() {
        int n = this.component.getCaretPosition();
        Document document = this.component.getDocument();
        int n2 = 0;
        if (document instanceof StyledDocument) {
            n2 = NbDocument.findLineNumber((StyledDocument)((StyledDocument)document), (int)n);
        }
        return new CaretMark(n2);
    }

    public synchronized List getMarks() {
        return Collections.singletonList(this.mark);
    }

    public void caretUpdate(CaretEvent caretEvent) {
        final List list = this.getMarks();
        this.mark = this.createMark();
        final List list2 = this.getMarks();
        RP.post(new Runnable(){

            public void run() {
                CaretMarkProvider.this.firePropertyChange("marks", list, list2);
            }
        });
    }
}

