/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.util.Comparator;
import org.netbeans.spi.editor.completion.CompletionItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionItemComparator
implements Comparator<CompletionItem> {
    public static final Comparator<CompletionItem> BY_PRIORITY = new CompletionItemComparator(true);
    public static final Comparator<CompletionItem> ALPHABETICAL = new CompletionItemComparator(false);
    private final boolean byPriority;

    private CompletionItemComparator(boolean bl) {
        this.byPriority = bl;
    }

    public static final Comparator<CompletionItem> get(int n) {
        if (n == 0) {
            return BY_PRIORITY;
        }
        if (n == 1) {
            return ALPHABETICAL;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int compare(CompletionItem completionItem, CompletionItem completionItem2) {
        if (completionItem == completionItem2) {
            return 0;
        }
        if (this.byPriority) {
            int n = completionItem.getSortPriority() - completionItem2.getSortPriority();
            if (n != 0) {
                return n;
            }
            int n2 = CompletionItemComparator.compareText(completionItem.getSortText(), completionItem2.getSortText());
            return n2;
        }
        int n = CompletionItemComparator.compareText(completionItem.getSortText(), completionItem2.getSortText());
        if (n != 0) {
            return n;
        }
        int n3 = completionItem.getSortPriority() - completionItem2.getSortPriority();
        return n3;
    }

    private static int compareText(CharSequence charSequence, CharSequence charSequence2) {
        int n = Math.min(charSequence.length(), charSequence2.length());
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = charSequence.charAt(i);
            if (c2 == (c = charSequence2.charAt(i))) continue;
            return c2 - c;
        }
        return charSequence.length() - charSequence2.length();
    }
}

