/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.html.HTMLDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.modules.editor.completion.CompletionImpl;
import org.netbeans.modules.editor.completion.CompletionSettings;
import org.netbeans.modules.editor.completion.HTMLDocView;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class DocumentationScrollPane
extends JScrollPane {
    private static final String BACK = "org/netbeans/modules/editor/completion/resources/back.png";
    private static final String FORWARD = "org/netbeans/modules/editor/completion/resources/forward.png";
    private static final String GOTO_SOURCE = "org/netbeans/modules/editor/completion/resources/open_source_in_editor.png";
    private static final String SHOW_WEB = "org/netbeans/modules/editor/completion/resources/open_in_external_browser.png";
    private static final String JAVADOC_ESCAPE = "javadoc-escape";
    private static final String JAVADOC_BACK = "javadoc-back";
    private static final String JAVADOC_FORWARD = "javadoc-forward";
    private static final String JAVADOC_OPEN_IN_BROWSER = "javadoc-open-in-browser";
    private static final String JAVADOC_OPEN_SOURCE = "javadoc-open-source";
    private static final int ACTION_JAVADOC_ESCAPE = 0;
    private static final int ACTION_JAVADOC_BACK = 1;
    private static final int ACTION_JAVADOC_FORWARD = 2;
    private static final int ACTION_JAVADOC_OPEN_IN_BROWSER = 3;
    private static final int ACTION_JAVADOC_OPEN_SOURCE = 4;
    private JButton bBack;
    private JButton bForward;
    private JButton bGoToSource;
    private JButton bShowWeb;
    private HTMLDocView view;
    private List<CompletionDocumentation> history = new ArrayList<CompletionDocumentation>(5);
    private int currentHistoryIndex = -1;
    protected CompletionDocumentation currentDocumentation = null;
    private Dimension documentationPreferredSize = CompletionSettings.INSTANCE.documentationPopupPreferredSize();

    public DocumentationScrollPane(JTextComponent jTextComponent) {
        this.setPreferredSize(null);
        Color color = CompletionSettings.INSTANCE.documentationBackgroundColor();
        this.view = new HTMLDocView(color);
        this.view.addHyperlinkListener(new HyperlinkAction());
        this.setViewportView(this.view);
        this.installTitleComponent();
        this.installKeybindings(jTextComponent);
        this.setFocusable(false);
    }

    public void setPreferredSize(Dimension dimension) {
        if (dimension == null) {
            dimension = this.documentationPreferredSize;
        }
        super.setPreferredSize(dimension);
    }

    public void setData(CompletionDocumentation completionDocumentation) {
        this.setDocumentation(completionDocumentation);
        this.addToHistory(completionDocumentation);
    }

    private ImageIcon resolveIcon(String string) {
        return new ImageIcon(Utilities.loadImage((String)string));
    }

    private void installTitleComponent() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("controlDkShadow")));
        jToolBar.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        ImageIcon imageIcon = this.resolveIcon(BACK);
        if (imageIcon != null) {
            this.bBack = new BrowserButton((Icon)imageIcon);
            this.bBack.addMouseListener(new MouseEventListener(this.bBack));
            this.bBack.setEnabled(false);
            this.bBack.setFocusable(false);
            this.bBack.setContentAreaFilled(false);
            this.bBack.setMargin(new Insets(0, 0, 0, 0));
            this.bBack.setToolTipText(NbBundle.getMessage(DocumentationScrollPane.class, (String)"HINT_doc_browser_back_button"));
            jToolBar.add((Component)this.bBack, gridBagConstraints);
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        imageIcon = this.resolveIcon(FORWARD);
        if (imageIcon != null) {
            this.bForward = new BrowserButton((Icon)imageIcon);
            this.bForward.addMouseListener(new MouseEventListener(this.bForward));
            this.bForward.setEnabled(false);
            this.bForward.setFocusable(false);
            this.bForward.setContentAreaFilled(false);
            this.bForward.setToolTipText(NbBundle.getMessage(DocumentationScrollPane.class, (String)"HINT_doc_browser_forward_button"));
            this.bForward.setMargin(new Insets(0, 0, 0, 0));
            jToolBar.add((Component)this.bForward, gridBagConstraints);
        }
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        imageIcon = this.resolveIcon(SHOW_WEB);
        if (imageIcon != null) {
            this.bShowWeb = new BrowserButton((Icon)imageIcon);
            this.bShowWeb.addMouseListener(new MouseEventListener(this.bShowWeb));
            this.bShowWeb.setEnabled(false);
            this.bShowWeb.setFocusable(false);
            this.bShowWeb.setContentAreaFilled(false);
            this.bShowWeb.setMargin(new Insets(0, 0, 0, 0));
            this.bShowWeb.setToolTipText(NbBundle.getMessage(DocumentationScrollPane.class, (String)"HINT_doc_browser_show_web_button"));
            jToolBar.add((Component)this.bShowWeb, gridBagConstraints);
        }
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        imageIcon = this.resolveIcon(GOTO_SOURCE);
        if (imageIcon != null) {
            this.bGoToSource = new BrowserButton((Icon)imageIcon);
            this.bGoToSource.addMouseListener(new MouseEventListener(this.bGoToSource));
            this.bGoToSource.setEnabled(false);
            this.bGoToSource.setFocusable(false);
            this.bGoToSource.setContentAreaFilled(false);
            this.bGoToSource.setMargin(new Insets(0, 0, 0, 0));
            this.bGoToSource.setToolTipText(NbBundle.getMessage(DocumentationScrollPane.class, (String)"HINT_doc_browser_goto_source_button"));
            jToolBar.add((Component)this.bGoToSource, gridBagConstraints);
        }
        this.setColumnHeaderView(jToolBar);
    }

    private synchronized void setDocumentation(CompletionDocumentation completionDocumentation) {
        this.currentDocumentation = completionDocumentation;
        String string = this.currentDocumentation.getText();
        URL uRL = this.currentDocumentation.getURL();
        if (string != null) {
            Object object;
            if (uRL != null && (object = this.view.getDocument()) instanceof HTMLDocument) {
                ((HTMLDocument)object).setBase(uRL);
            }
            if (this.currentDocumentation instanceof DefaultDoc) {
                object = ((DefaultDoc)this.currentDocumentation).desc;
                this.view.setContent(string, ((String)object).startsWith("#") ? ((String)object).substring(1) : null);
            } else {
                this.view.setContent(string, null);
            }
        } else if (uRL != null) {
            try {
                this.view.setPage(uRL);
            }
            catch (IOException iOException) {
                StatusDisplayer.getDefault().setStatusText(iOException.toString());
            }
        }
        this.bShowWeb.setEnabled(uRL != null);
        this.bGoToSource.setEnabled(this.currentDocumentation.getGotoSourceAction() != null);
    }

    private synchronized void addToHistory(CompletionDocumentation completionDocumentation) {
        int n = this.history.size();
        for (int i = this.currentHistoryIndex + 1; i < n; ++i) {
            this.history.remove(this.history.size() - 1);
        }
        this.history.add(completionDocumentation);
        this.currentHistoryIndex = this.history.size() - 1;
        if (this.currentHistoryIndex > 0) {
            this.bBack.setEnabled(true);
        }
        this.bForward.setEnabled(false);
    }

    private synchronized void backHistory() {
        if (this.currentHistoryIndex > 0) {
            --this.currentHistoryIndex;
            this.setDocumentation(this.history.get(this.currentHistoryIndex));
            if (this.currentHistoryIndex == 0) {
                this.bBack.setEnabled(false);
            }
            this.bForward.setEnabled(true);
        }
    }

    private synchronized void forwardHistory() {
        if (this.currentHistoryIndex < this.history.size() - 1) {
            ++this.currentHistoryIndex;
            this.setDocumentation(this.history.get(this.currentHistoryIndex));
            if (this.currentHistoryIndex == this.history.size() - 1) {
                this.bForward.setEnabled(false);
            }
            this.bBack.setEnabled(true);
        }
    }

    synchronized void clearHistory() {
        this.currentHistoryIndex = -1;
        this.history.clear();
        this.bBack.setEnabled(false);
        this.bForward.setEnabled(false);
    }

    private void openInExternalBrowser() {
        URL uRL = this.currentDocumentation.getURL();
        if (uRL != null) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
        }
    }

    private void goToSource() {
        Action action = this.currentDocumentation.getGotoSourceAction();
        if (action != null) {
            action.actionPerformed(new ActionEvent(this.currentDocumentation, 0, null));
        }
    }

    private KeyStroke[] findEditorKeys(String string, KeyStroke keyStroke, JTextComponent jTextComponent) {
        KeyStroke[] keyStrokeArray = new KeyStroke[]{keyStroke};
        if (jTextComponent != null) {
            KeyStroke[] keyStrokeArray2;
            Action action;
            EditorKit editorKit;
            TextUI textUI = jTextComponent.getUI();
            Keymap keymap = jTextComponent.getKeymap();
            if (textUI != null && keymap != null && (editorKit = textUI.getEditorKit(jTextComponent)) instanceof BaseKit && (action = ((BaseKit)editorKit).getActionByName(string)) != null && (keyStrokeArray2 = keymap.getKeyStrokesForAction(action)) != null && keyStrokeArray2.length > 0) {
                keyStrokeArray = keyStrokeArray2;
            }
        }
        return keyStrokeArray;
    }

    private void registerKeybinding(int n, String string, KeyStroke keyStroke, String string2, JTextComponent jTextComponent) {
        KeyStroke[] keyStrokeArray = this.findEditorKeys(string2, keyStroke, jTextComponent);
        for (int i = 0; i < keyStrokeArray.length; ++i) {
            this.getInputMap().put(keyStrokeArray[i], string);
        }
        this.getActionMap().put(string, new DocPaneAction(n));
    }

    private void installKeybindings(JTextComponent jTextComponent) {
        this.registerKeybinding(0, JAVADOC_ESCAPE, KeyStroke.getKeyStroke(27, 0), "escape", jTextComponent);
        this.registerKeybinding(1, JAVADOC_BACK, KeyStroke.getKeyStroke(37, 8), null, jTextComponent);
        this.registerKeybinding(2, JAVADOC_FORWARD, KeyStroke.getKeyStroke(39, 8), null, jTextComponent);
        this.registerKeybinding(3, JAVADOC_OPEN_IN_BROWSER, KeyStroke.getKeyStroke(112, 9), null, jTextComponent);
        this.registerKeybinding(4, JAVADOC_OPEN_SOURCE, KeyStroke.getKeyStroke(79, 10), null, jTextComponent);
        this.mapWithShift(KeyStroke.getKeyStroke(38, 0));
        this.mapWithShift(KeyStroke.getKeyStroke(40, 0));
        this.mapWithShift(KeyStroke.getKeyStroke(33, 0));
        this.mapWithShift(KeyStroke.getKeyStroke(34, 0));
        this.mapWithShift(KeyStroke.getKeyStroke(36, 2));
        this.mapWithShift(KeyStroke.getKeyStroke(35, 2));
        this.mapWithShift(KeyStroke.getKeyStroke(39, 0));
        this.mapWithShift(KeyStroke.getKeyStroke(37, 0));
    }

    private void mapWithShift(KeyStroke keyStroke) {
        InputMap inputMap = this.getInputMap(1);
        Object object = inputMap.get(keyStroke);
        if (object != null) {
            keyStroke = KeyStroke.getKeyStroke(keyStroke.getKeyCode(), keyStroke.getModifiers() | 1);
            this.getInputMap().put(keyStroke, object);
        }
    }

    private class BrowserButton
    extends JButton {
        public BrowserButton() {
            this.setBorderPainted(false);
            this.setFocusPainted(false);
        }

        public BrowserButton(String string) {
            super(string);
            this.setBorderPainted(false);
            this.setFocusPainted(false);
        }

        public BrowserButton(Icon icon) {
            super(icon);
            this.setBorderPainted(false);
            this.setFocusPainted(false);
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
        }
    }

    private class DefaultDoc
    implements CompletionDocumentation {
        private CompletionDocumentation baseDoc = null;
        private URL url = null;
        private String desc = null;

        private DefaultDoc(CompletionDocumentation completionDocumentation, String string) {
            try {
                this.url = new URL(completionDocumentation.getURL(), string);
            }
            catch (MalformedURLException malformedURLException) {
                this.baseDoc = completionDocumentation;
                this.desc = string;
            }
        }

        public String getText() {
            return this.baseDoc != null ? this.baseDoc.getText() : null;
        }

        public URL getURL() {
            return this.url;
        }

        public CompletionDocumentation resolveLink(String string) {
            return this.baseDoc != null ? this.baseDoc.resolveLink(string) : null;
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    private class DocPaneAction
    extends AbstractAction {
        private int action;

        private DocPaneAction(int n) {
            this.action = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.action) {
                case 0: {
                    CompletionImpl.get().hideDocumentation(false);
                    break;
                }
                case 1: {
                    DocumentationScrollPane.this.backHistory();
                    break;
                }
                case 2: {
                    DocumentationScrollPane.this.forwardHistory();
                    break;
                }
                case 3: {
                    DocumentationScrollPane.this.openInExternalBrowser();
                    break;
                }
                case 4: {
                    DocumentationScrollPane.this.goToSource();
                }
            }
        }
    }

    private class HyperlinkAction
    implements HyperlinkListener {
        private HyperlinkAction() {
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            String string;
            if (hyperlinkEvent != null && HyperlinkEvent.EventType.ACTIVATED.equals(hyperlinkEvent.getEventType()) && (string = hyperlinkEvent.getDescription()) != null) {
                CompletionDocumentation completionDocumentation = DocumentationScrollPane.this.currentDocumentation.resolveLink(string);
                if (completionDocumentation == null) {
                    completionDocumentation = new DefaultDoc(DocumentationScrollPane.this.currentDocumentation, string);
                }
                DocumentationScrollPane.this.setData(completionDocumentation);
            }
        }
    }

    private class MouseEventListener
    extends MouseAdapter {
        private JButton button;

        MouseEventListener(JButton jButton) {
            this.button = jButton;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (this.button.isEnabled()) {
                this.button.setContentAreaFilled(true);
                this.button.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.button.setContentAreaFilled(false);
            this.button.setBorderPainted(false);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.button.equals(DocumentationScrollPane.this.bBack)) {
                DocumentationScrollPane.this.backHistory();
            } else if (this.button.equals(DocumentationScrollPane.this.bForward)) {
                DocumentationScrollPane.this.forwardHistory();
            } else if (this.button.equals(DocumentationScrollPane.this.bGoToSource)) {
                DocumentationScrollPane.this.goToSource();
            } else if (this.button.equals(DocumentationScrollPane.this.bShowWeb)) {
                DocumentationScrollPane.this.openInExternalBrowser();
            }
        }
    }
}

