/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.settings.storage.ColoringStorage;
import org.netbeans.modules.editor.settings.storage.EditorSettingsImpl;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.netbeans.modules.editor.settings.storage.api.FontColorSettingsFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FontColorSettingsImpl
extends FontColorSettingsFactory {
    private static final Logger LOG = Logger.getLogger(FontColorSettingsImpl.class.getName());
    private static final Map<MimePath, WeakReference<FontColorSettingsImpl>> INSTANCES = new WeakHashMap<MimePath, WeakReference<FontColorSettingsImpl>>();
    private final MimePath mimePath;
    private final Map<String, Map<String, AttributeSet>> colorings = new HashMap<String, Map<String, AttributeSet>>();
    private final Map<String, Map<String, AttributeSet>> defaults = new HashMap<String, Map<String, AttributeSet>>();

    public static synchronized FontColorSettingsImpl get(MimePath mimePath) {
        FontColorSettingsImpl fontColorSettingsImpl;
        WeakReference<FontColorSettingsImpl> weakReference = INSTANCES.get(mimePath);
        FontColorSettingsImpl fontColorSettingsImpl2 = fontColorSettingsImpl = weakReference == null ? null : (FontColorSettingsImpl)weakReference.get();
        if (fontColorSettingsImpl == null) {
            fontColorSettingsImpl = new FontColorSettingsImpl(mimePath);
            INSTANCES.put(mimePath, new WeakReference<FontColorSettingsImpl>(fontColorSettingsImpl));
        }
        return fontColorSettingsImpl;
    }

    private FontColorSettingsImpl(MimePath mimePath) {
        this.mimePath = mimePath;
    }

    public MimePath getMimePath() {
        return this.mimePath;
    }

    @Override
    public Collection<AttributeSet> getAllFontColors(String string) {
        string = EditorSettingsImpl.getInstance().getInternalFontColorProfile(string);
        Map<String, AttributeSet> map = this.getColorings(string);
        return Collections.unmodifiableCollection(map.values());
    }

    @Override
    public Collection<AttributeSet> getAllFontColorDefaults(String string) {
        string = EditorSettingsImpl.getInstance().getInternalFontColorProfile(string);
        Map<String, AttributeSet> map = this.getDefaultColorings(string);
        return Collections.unmodifiableCollection(map.values());
    }

    @Override
    public void setAllFontColors(String string, Collection<AttributeSet> collection) {
        LOG.fine("set " + string);
        boolean bl = string.startsWith("test");
        string = EditorSettingsImpl.getInstance().getInternalFontColorProfile(string);
        if (collection == null) {
            ColoringStorage.deleteColorings(this.mimePath, string, true, false);
            this.colorings.remove(string);
        } else {
            Map<String, AttributeSet> map = Utils.immutize(collection);
            if (!bl) {
                ColoringStorage.saveColorings(this.mimePath, string, true, false, map.values());
            }
            this.colorings.put(string, map);
        }
        EditorSettingsImpl.getInstance().notifyTokenFontColorChange(this.mimePath, string);
    }

    @Override
    public void setAllFontColorsDefaults(String string, Collection<AttributeSet> collection) {
        LOG.fine("set defaults " + string);
        boolean bl = string.startsWith("test");
        string = EditorSettingsImpl.getInstance().getInternalFontColorProfile(string);
        if (collection == null) {
            ColoringStorage.deleteColorings(this.mimePath, string, true, true);
            this.defaults.remove(string);
        } else {
            Map<String, AttributeSet> map = Utils.immutize(collection);
            if (!bl) {
                ColoringStorage.saveColorings(this.mimePath, string, true, true, map.values());
            }
            this.defaults.put(string, map);
        }
        EditorSettingsImpl.getInstance().notifyTokenFontColorChange(this.mimePath, string);
    }

    Map<String, AttributeSet> getColorings(String string) {
        Map<String, AttributeSet> map;
        if (!this.colorings.containsKey(string)) {
            boolean bl = string.startsWith("test");
            Map<String, AttributeSet> map2 = ColoringStorage.loadColorings(this.mimePath, bl ? "NetBeans" : string, true, false);
            if (map2 == null) {
                map2 = ColoringStorage.loadColorings(this.mimePath, "NetBeans", true, false);
            }
            this.colorings.put(string, map2);
        }
        return (map = this.colorings.get(string)) == null ? Collections.emptyMap() : map;
    }

    Map<String, AttributeSet> getDefaultColorings(String string) {
        Map<String, AttributeSet> map;
        if (!this.defaults.containsKey(string)) {
            map = ColoringStorage.loadColorings(this.mimePath, string, true, true);
            this.defaults.put(string, map);
        }
        return (map = this.defaults.get(string)) == null ? Collections.emptyMap() : map;
    }
}

