/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.modules.editor.settings.storage.CompositeFCS;
import org.netbeans.modules.editor.settings.storage.EditorSettingsImpl;
import org.netbeans.modules.editor.settings.storage.KeyBindingSettingsImpl;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.spi.editor.mimelookup.MimeDataProvider;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class SettingsProvider
implements MimeDataProvider {
    private static final Logger LOG = Logger.getLogger(SettingsProvider.class.getName());
    private final Map<MimePath, WeakReference<Lookup>> cache = new WeakHashMap<MimePath, WeakReference<Lookup>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup getLookup(MimePath mimePath) {
        Map<MimePath, WeakReference<Lookup>> map = this.cache;
        synchronized (map) {
            Object object;
            WeakReference<Lookup> weakReference = this.cache.get(mimePath);
            Lookup lookup = object = weakReference == null ? null : (Lookup)weakReference.get();
            if (object == null) {
                String string = mimePath.getPath();
                if (string.startsWith("test")) {
                    int n = string.indexOf(95);
                    if (n == -1) {
                        throw new IllegalStateException("Invalid mimePath: " + string);
                    }
                    String string2 = string.substring(0, n);
                    MimePath mimePath2 = MimePath.parse((String)string.substring(n + 1));
                    object = new ProxyLookup(new Lookup[]{new MyLookup(mimePath2, string2), Lookups.exclude((Lookup)MimeLookup.getLookup((MimePath)mimePath2), (Class[])new Class[]{FontColorSettings.class, KeyBindingSettings.class})});
                } else {
                    object = new MyLookup(mimePath, null);
                }
                this.cache.put(mimePath, new WeakReference<Lookup>((Lookup)object));
            }
            return object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MyLookup
    extends AbstractLookup
    implements PropertyChangeListener {
        private final MimePath mimePath;
        private final MimePath[] allMimePaths;
        private final boolean specialFcsProfile;
        private String fcsProfile;
        private final InstanceContent ic;
        private Object fontColorSettings = null;
        private Object keyBindingSettings = null;
        private KeyBindingSettingsImpl kbsi;

        public MyLookup(MimePath mimePath, String string) {
            this(mimePath, string, new InstanceContent());
        }

        private MyLookup(MimePath mimePath, String string, InstanceContent instanceContent) {
            super((AbstractLookup.Content)instanceContent);
            Object object;
            this.mimePath = mimePath;
            this.allMimePaths = MyLookup.computeInheritedMimePaths(mimePath);
            if (string == null) {
                object = EditorSettings.getDefault().getCurrentFontColorProfile();
                this.fcsProfile = EditorSettingsImpl.getInstance().getInternalFontColorProfile((String)object);
                this.specialFcsProfile = false;
            } else {
                this.fcsProfile = string;
                this.specialFcsProfile = true;
            }
            this.ic = instanceContent;
            object = EditorSettings.getDefault();
            ((EditorSettings)object).addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)object));
            this.kbsi = KeyBindingSettingsImpl.get(mimePath);
            this.kbsi.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.kbsi));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void initialize() {
            MyLookup myLookup = this;
            synchronized (myLookup) {
                this.fontColorSettings = new CompositeFCS(this.allMimePaths, this.fcsProfile);
                this.keyBindingSettings = this.kbsi.createInstanceForLookup();
                this.ic.set(Arrays.asList(this.fontColorSettings, this.keyBindingSettings), null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            MyLookup myLookup = this;
            synchronized (myLookup) {
                String string;
                boolean bl = false;
                boolean bl2 = false;
                if (this.kbsi == propertyChangeEvent.getSource()) {
                    bl2 = true;
                } else if (propertyChangeEvent.getPropertyName() == null) {
                    if (!this.specialFcsProfile) {
                        string = EditorSettings.getDefault().getCurrentFontColorProfile();
                        this.fcsProfile = EditorSettingsImpl.getInstance().getInternalFontColorProfile(string);
                    }
                    bl = true;
                } else if (propertyChangeEvent.getPropertyName().equals("editorFontColors")) {
                    string = (String)propertyChangeEvent.getNewValue();
                    if (string.equals(this.fcsProfile)) {
                        bl = true;
                    }
                } else if (propertyChangeEvent.getPropertyName().equals("fontColors")) {
                    MimePath mimePath;
                    string = (String)propertyChangeEvent.getNewValue();
                    if (string.equals(this.fcsProfile) && this.isDerivedFromMimePath(mimePath = (MimePath)propertyChangeEvent.getOldValue())) {
                        bl = true;
                    }
                } else if (propertyChangeEvent.getPropertyName().equals("currentFontColorProfile") && !this.specialFcsProfile) {
                    string = (String)propertyChangeEvent.getNewValue();
                    this.fcsProfile = EditorSettingsImpl.getInstance().getInternalFontColorProfile(string);
                    bl = true;
                }
                boolean bl3 = false;
                if (bl && this.fontColorSettings != null) {
                    this.fontColorSettings = new CompositeFCS(this.allMimePaths, this.fcsProfile);
                    bl3 = true;
                }
                if (bl2 && this.keyBindingSettings != null) {
                    this.keyBindingSettings = this.kbsi.createInstanceForLookup();
                    bl3 = true;
                }
                if (bl3) {
                    this.ic.set(Arrays.asList(this.fontColorSettings, this.keyBindingSettings), null);
                }
            }
        }

        private boolean isDerivedFromMimePath(MimePath mimePath) {
            for (MimePath mimePath2 : this.allMimePaths) {
                if (mimePath2 != mimePath) continue;
                return true;
            }
            return false;
        }

        private static MimePath[] computeInheritedMimePaths(MimePath mimePath) {
            List<String> list = MyLookup.callSwitchLookupComputePaths(mimePath);
            if (list != null) {
                ArrayList<MimePath> arrayList = new ArrayList<MimePath>(list.size());
                for (String string : list) {
                    arrayList.add(MimePath.parse((String)string));
                }
                return arrayList.toArray(new MimePath[arrayList.size()]);
            }
            return new MimePath[]{mimePath, MimePath.EMPTY};
        }

        private static List<String> callSwitchLookupComputePaths(MimePath mimePath) {
            try {
                ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                Class<?> clazz = classLoader.loadClass("org.netbeans.modules.editor.mimelookup.impl.SwitchLookup");
                Method method = clazz.getDeclaredMethod("computePaths", MimePath.class, String.class, String.class);
                method.setAccessible(true);
                List list = (List)method.invoke(null, mimePath, null, null);
                return list;
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "Can't call org.netbeans.modules.editor.mimelookup.impl.SwitchLookup.computePath(MimeLookup, String, String).", exception);
                return null;
            }
        }
    }
}

