/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final Logger LOG = Logger.getLogger(Utils.class.getName());
    private static final Map<Color, String> colorToName = new HashMap<Color, String>();
    private static final Map<String, Color> nameToColor = new HashMap<String, Color>();
    private static final Map<String, Integer> nameToFontStyle = new HashMap<String, Integer>();
    private static final Map<Integer, String> fontStyleToName = new HashMap<Integer, String>();
    private static final WeakHashMap<FileObject, Object[]> bundleInfos;

    static String colorToString(Color color) {
        if (colorToName.containsKey(color)) {
            return colorToName.get(color);
        }
        return Integer.toHexString(color.getRGB());
    }

    static Color stringToColor(String string) throws Exception {
        if (nameToColor.containsKey(string)) {
            return nameToColor.get(string);
        }
        try {
            return new Color((int)Long.parseLong(string, 16));
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception();
        }
    }

    static String keyStrokesToString(Collection<KeyStroke> collection) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<KeyStroke> iterator = collection.iterator();
        if (iterator.hasNext()) {
            stringBuffer.append(Utilities.keyToString((KeyStroke)iterator.next()));
            while (iterator.hasNext()) {
                stringBuffer.append('$').append(Utilities.keyToString((KeyStroke)iterator.next()));
            }
        }
        return stringBuffer.toString();
    }

    static KeyStroke[] stringToKeyStrokes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "$");
        ArrayList<KeyStroke> arrayList = new ArrayList<KeyStroke>();
        string = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            KeyStroke keyStroke = Utilities.stringToKey((String)string2);
            if (keyStroke == null) {
                LOG.fine("no key stroke for:" + string);
                continue;
            }
            arrayList.add(keyStroke);
        }
        return arrayList.toArray(new KeyStroke[arrayList.size()]);
    }

    static FileObject getFileObject(MimePath mimePath, String string, String string2) {
        String string3 = Utils.getFileName(mimePath, string, string2);
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        return fileSystem.findResource(string3);
    }

    static FileObject createFileObject(MimePath mimePath, String string, String string2) {
        String string3 = Utils.getFileName(mimePath, string, string2);
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        try {
            if (string2 == null) {
                return FileUtil.createFolder((FileObject)fileSystem.getRoot(), (String)string3);
            }
            return FileUtil.createData((FileObject)fileSystem.getRoot(), (String)string3);
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, "Can't create editor settings file or folder: " + string3, iOException);
            return null;
        }
    }

    static void deleteFileObject(MimePath mimePath, String string, String string2) {
        String string3 = Utils.getFileName(mimePath, string, string2);
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource(string3);
        if (fileObject != null) {
            try {
                fileObject.delete();
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, "Can't delete editor settings file " + fileObject.getPath(), iOException);
            }
        }
    }

    static String getFileName(MimePath mimePath, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder("Editors");
        if (mimePath.size() > 0) {
            stringBuilder.append('/').append(mimePath.getPath());
        }
        if (string != null) {
            stringBuilder.append('/').append(string);
        }
        if (string2 != null) {
            stringBuilder.append('/').append(string2);
        }
        return stringBuilder.toString();
    }

    private static FileObject createFile(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 == null) {
            return fileObject.createFolder(string);
        }
        return fileObject2;
    }

    static String getLocalizedName(FileObject fileObject, String string, String string2) {
        assert (string != null) : "The key can't be null";
        Object[] objectArray = Utils.findResourceBundle(fileObject);
        if (objectArray[1] != null) {
            try {
                return ((ResourceBundle)objectArray[1]).getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                LOG.log(Level.WARNING, "The bundle '" + objectArray[0] + "' is missing key '" + string + "'.", missingResourceException);
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] findResourceBundle(FileObject fileObject) {
        assert (fileObject != null) : "FileObject can't be null";
        WeakHashMap<FileObject, Object[]> weakHashMap = bundleInfos;
        synchronized (weakHashMap) {
            Object[] objectArray = bundleInfos.get(fileObject);
            if (objectArray == null) {
                String string = null;
                Object object = fileObject.getAttribute("SystemFileSystem.localizingBundle");
                if (object instanceof String) {
                    string = (String)object;
                }
                if (string != null) {
                    try {
                        objectArray = new Object[]{string, NbBundle.getBundle((String)string)};
                    }
                    catch (MissingResourceException missingResourceException) {
                        LOG.log(Level.WARNING, "Can't find resource bundle for " + fileObject.getPath(), missingResourceException);
                    }
                }
                if (objectArray == null) {
                    objectArray = new Object[]{string, null};
                }
                bundleInfos.put(fileObject, objectArray);
            }
            return objectArray;
        }
    }

    public static MimePath mimeTypes2mimePath(String[] stringArray) {
        MimePath mimePath = MimePath.EMPTY;
        for (int i = 0; i < stringArray.length; ++i) {
            mimePath = MimePath.get((MimePath)mimePath, (String)stringArray[i]);
        }
        return mimePath;
    }

    public static Map<String, AttributeSet> immutize(Map<String, AttributeSet> map) {
        HashMap<String, AttributeSet> hashMap = new HashMap<String, AttributeSet>();
        for (String string : map.keySet()) {
            AttributeSet attributeSet = map.get(string);
            hashMap.put(string, AttributesUtilities.createImmutable((AttributeSet[])new AttributeSet[]{attributeSet}));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public static Map<String, AttributeSet> immutize(Collection<AttributeSet> collection) {
        HashMap<String, AttributeSet> hashMap = new HashMap<String, AttributeSet>();
        for (AttributeSet attributeSet : collection) {
            Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
            if (object instanceof String) {
                hashMap.put((String)object, attributeSet);
                continue;
            }
            LOG.warning("Ignoring AttributeSet with invalid StyleConstants.NameAttribute. AttributeSet: " + attributeSet);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    static {
        colorToName.put(Color.black, "black");
        nameToColor.put("black", Color.black);
        colorToName.put(Color.blue, "blue");
        nameToColor.put("blue", Color.blue);
        colorToName.put(Color.cyan, "cyan");
        nameToColor.put("cyan", Color.cyan);
        colorToName.put(Color.darkGray, "darkGray");
        nameToColor.put("darkGray", Color.darkGray);
        colorToName.put(Color.gray, "gray");
        nameToColor.put("gray", Color.gray);
        colorToName.put(Color.green, "green");
        nameToColor.put("green", Color.green);
        colorToName.put(Color.lightGray, "lightGray");
        nameToColor.put("lightGray", Color.lightGray);
        colorToName.put(Color.magenta, "magenta");
        nameToColor.put("magenta", Color.magenta);
        colorToName.put(Color.orange, "orange");
        nameToColor.put("orange", Color.orange);
        colorToName.put(Color.pink, "pink");
        nameToColor.put("pink", Color.pink);
        colorToName.put(Color.red, "red");
        nameToColor.put("red", Color.red);
        colorToName.put(Color.white, "white");
        nameToColor.put("white", Color.white);
        colorToName.put(Color.yellow, "yellow");
        nameToColor.put("yellow", Color.yellow);
        nameToFontStyle.put("plain", new Integer(0));
        fontStyleToName.put(new Integer(0), "plain");
        nameToFontStyle.put("bold", new Integer(1));
        fontStyleToName.put(new Integer(1), "bold");
        nameToFontStyle.put("italic", new Integer(2));
        fontStyleToName.put(new Integer(2), "italic");
        nameToFontStyle.put("bold+italic", new Integer(3));
        fontStyleToName.put(new Integer(3), "bold+italic");
        bundleInfos = new WeakHashMap();
    }
}

