/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.editor.codetemplates.CodeTemplateManagerOperation;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class SurroundWithFix
implements Fix {
    private static String SURROUND_WITH = NbBundle.getMessage((Class)SurroundWithFix.class, (String)"TXT_SurroundWithHint_Prefix");
    private CodeTemplate template;
    private JTextComponent component;

    public static List getFixes(JTextComponent jTextComponent) {
        ArrayList<SurroundWithFix> arrayList = new ArrayList<SurroundWithFix>();
        Document document = jTextComponent.getDocument();
        CodeTemplateManagerOperation codeTemplateManagerOperation = CodeTemplateManagerOperation.get(document);
        codeTemplateManagerOperation.waitLoaded();
        Collection collection = codeTemplateManagerOperation.getTemplateFilters(jTextComponent, jTextComponent.getSelectionStart());
        Iterator iterator = codeTemplateManagerOperation.findSelectionTemplates().iterator();
        while (iterator.hasNext()) {
            CodeTemplate codeTemplate = (CodeTemplate)iterator.next();
            if (!SurroundWithFix.accept(codeTemplate, collection)) continue;
            arrayList.add(new SurroundWithFix(codeTemplate, jTextComponent));
        }
        return arrayList;
    }

    private SurroundWithFix(CodeTemplate codeTemplate, JTextComponent jTextComponent) {
        this.template = codeTemplate;
        this.component = jTextComponent;
    }

    public String getText() {
        return SURROUND_WITH + this.template.getDescription();
    }

    public ChangeInfo implement() {
        this.template.insert(this.component);
        return null;
    }

    private static boolean accept(CodeTemplate codeTemplate, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CodeTemplateFilter codeTemplateFilter = (CodeTemplateFilter)iterator.next();
            if (codeTemplateFilter.accept(codeTemplate)) continue;
            return false;
        }
        return true;
    }
}

