/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.spi.editor.mimelookup.Class2LayerFolder;
import org.netbeans.spi.editor.mimelookup.InstanceProvider;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class ClassInfoStorage {
    public static final String PROP_CLASS_INFO_CHANGED = "Class2Paths.PROP_CLASS_MAPPING_CHANGED";
    public static final String PROP_CLASS_INFO_ADDED = "Class2Paths.PROP_CLASS_MAPPING_ADDED";
    public static final String PROP_CLASS_INFO_REMOVED = "Class2Paths.PROP_CLASS_MAPPING_REMOVED";
    private static Logger LOG = Logger.getLogger(ClassInfoStorage.class.getName());
    private static ClassInfoStorage instance = null;
    private Lookup.Result mappers = null;
    private L mappersListener = null;
    private final String LOCK = new String("Class2Paths.LOCK");
    private HashMap mapping = new HashMap();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public static synchronized ClassInfoStorage getInstance() {
        if (instance == null) {
            instance = new ClassInfoStorage();
        }
        return instance;
    }

    private ClassInfoStorage() {
        this.mappers = Lookup.getDefault().lookupResult(Class2LayerFolder.class);
        this.mappersListener = new L();
        this.mappers.addLookupListener((LookupListener)WeakListeners.create((Class)LookupListener.class, (EventListener)((Object)this.mappersListener), (Object)this.mappers));
        this.rebuild();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Info getInfo(String string) {
        String string2 = this.LOCK;
        synchronized (string2) {
            if (this.mapping.containsKey(string)) {
                return (Info)this.mapping.get(string);
            }
            return new Info(this, string, null, null);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List rebuild() {
        String string = this.LOCK;
        synchronized (string) {
            Object object;
            ArrayList<PropertyChangeEvent> arrayList;
            Object object2;
            Object object3;
            HashMap<String, Info> hashMap = new HashMap<String, Info>();
            Collection collection = this.mappers.allInstances();
            Object object4 = collection.iterator();
            while (object4.hasNext()) {
                object3 = (Class2LayerFolder)object4.next();
                object2 = object3.getClazz().getName();
                arrayList = object3.getLayerFolderName();
                object = object3.getInstanceProvider();
                if (arrayList != null) {
                    arrayList = ((String)((Object)arrayList)).trim();
                }
                if ((arrayList == null || ((String)((Object)arrayList)).length() == 0) && object == null) continue;
                if (!hashMap.containsKey(object2)) {
                    hashMap.put((String)object2, new Info(this, (String)object2, (String)((Object)arrayList), (InstanceProvider)object));
                    continue;
                }
                LOG.warning("The mapping for class '" + (String)object2 + "' to folder '" + (String)((Object)arrayList) + "' and InstanceProvider '" + object + "' has already been " + "defined by another mapper. Ignoring mapper " + object3);
            }
            object4 = new HashSet(this.mapping.keySet());
            ((AbstractSet)object4).removeAll(hashMap.keySet());
            object3 = new HashSet(hashMap.keySet());
            ((AbstractSet)object3).removeAll(this.mapping.keySet());
            object2 = new HashSet();
            arrayList = hashMap.keySet().iterator();
            while (arrayList.hasNext()) {
                object = (String)arrayList.next();
                if (!this.mapping.containsKey(object) || Utilities.compareObjects(hashMap.get(object), this.mapping.get(object))) continue;
                ((HashSet)object2).add(object);
            }
            this.mapping.clear();
            this.mapping.putAll(hashMap);
            arrayList = new ArrayList<PropertyChangeEvent>(3);
            if (!((HashSet)object4).isEmpty()) {
                arrayList.add(new PropertyChangeEvent(this, PROP_CLASS_INFO_REMOVED, null, object4));
            }
            if (!((HashSet)object3).isEmpty()) {
                arrayList.add(new PropertyChangeEvent(this, PROP_CLASS_INFO_ADDED, null, object3));
            }
            if (!((HashSet)object2).isEmpty()) {
                arrayList.add(new PropertyChangeEvent(this, PROP_CLASS_INFO_CHANGED, null, object2));
            }
            return arrayList;
        }
    }

    public static final class Info {
        private ClassInfoStorage storage;
        private String className;
        private String extraPath;
        private String instanceProviderClass;
        private WeakReference ref;

        private Info(ClassInfoStorage classInfoStorage, String string, String string2, InstanceProvider instanceProvider) {
            this.storage = classInfoStorage;
            this.className = string;
            String string3 = this.extraPath = string2 == null ? "" : string2;
            if (instanceProvider != null) {
                this.instanceProviderClass = instanceProvider.getClass().getName();
                this.ref = new WeakReference<InstanceProvider>(instanceProvider);
            }
        }

        public String getClassName() {
            return this.className;
        }

        public String getExtraPath() {
            return this.extraPath;
        }

        public String getInstanceProviderClass() {
            return this.instanceProviderClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InstanceProvider getInstanceProvider() {
            String string = this.storage.LOCK;
            synchronized (string) {
                if (this.ref == null) {
                    return null;
                }
                InstanceProvider instanceProvider = (InstanceProvider)this.ref.get();
                if (instanceProvider == null) {
                    Collection collection = this.storage.mappers.allInstances();
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        Class2LayerFolder class2LayerFolder = (Class2LayerFolder)iterator.next();
                        String string2 = class2LayerFolder.getClazz().getName();
                        if (!this.className.equals(string2)) continue;
                        instanceProvider = class2LayerFolder.getInstanceProvider();
                        break;
                    }
                    if (instanceProvider != null) {
                        this.ref = new WeakReference<InstanceProvider>(instanceProvider);
                    }
                }
                return instanceProvider;
            }
        }

        public boolean equals(Object object) {
            if (object instanceof Info) {
                Info info = (Info)object;
                return this.className.equals(info.className) && Utilities.compareObjects((Object)this.extraPath, (Object)info.extraPath) && Utilities.compareObjects((Object)this.instanceProviderClass, (Object)info.instanceProviderClass);
            }
            return false;
        }

        public int hashCode() {
            int n = this.className.hashCode();
            if (this.extraPath != null) {
                n += 7 * this.extraPath.hashCode();
            }
            if (this.instanceProviderClass != null) {
                n += 13 * this.instanceProviderClass.hashCode();
            }
            return n;
        }
    }

    private class L
    implements LookupListener {
        private L() {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            List list = ClassInfoStorage.this.rebuild();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PropertyChangeEvent propertyChangeEvent = (PropertyChangeEvent)iterator.next();
                ClassInfoStorage.this.pcs.firePropertyChange(propertyChangeEvent);
            }
        }
    }
}

