/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.editor.mimelookup.impl.FolderChildren;
import org.openide.filesystems.FileObject;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;

public final class CompoundFolderChildren {
    public static final String PROP_CHILDREN = "FolderChildren.PROP_CHILDREN";
    private static final String HIDDEN_SUFFIX = "_hidden";
    private static final String HIDDEN_ATTR_NAME = "hidden";
    private static final Logger LOG = Logger.getLogger(CompoundFolderChildren.class.getName());
    private final String LOCK = new String("CompoundFolderChildren.LOCK");
    private FolderChildren[] layers = null;
    private List children = Collections.EMPTY_LIST;
    private PCL listener = new PCL();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public CompoundFolderChildren(String[] stringArray) {
        this(stringArray, true);
    }

    public CompoundFolderChildren(String[] stringArray, boolean bl) {
        this.layers = new FolderChildren[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.layers[i] = new FolderChildren(stringArray[i], bl);
            this.layers[i].addPropertyChangeListener(this.listener);
        }
        this.rebuild();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getChildren() {
        String string = this.LOCK;
        synchronized (string) {
            return this.children;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuild() {
        PropertyChangeEvent propertyChangeEvent = null;
        String string = this.LOCK;
        synchronized (string) {
            List list;
            String string2;
            Object object;
            Object object2;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            for (int i = 0; i < this.layers.length; ++i) {
                List list2 = this.layers[i].getChildren();
                object2 = list2.iterator();
                while (object2.hasNext()) {
                    object = (FileObject)object2.next();
                    string2 = this.realName((FileObject)object);
                    if (this.isHidden((FileObject)object) && !hashMap2.containsKey(string2)) {
                        hashMap2.put(string2, object);
                    }
                    if (hashMap2.containsKey(string2) || hashMap.containsKey(string2)) continue;
                    hashMap.put(string2, object);
                }
            }
            HashMap<String, HashSet<FileObject>> hashMap3 = new HashMap<String, HashSet<FileObject>>();
            for (int i = 0; i < this.layers.length; ++i) {
                object2 = this.layers[i].getFolderAttributes();
                object = object2.keySet().iterator();
                while (object.hasNext()) {
                    String string3;
                    string2 = (String)object.next();
                    Object v = object2.get(string2);
                    int n = string2.indexOf(47);
                    if (n == -1 || !(v instanceof Boolean)) continue;
                    String string4 = string2.substring(0, n);
                    String string5 = string2.substring(n + 1);
                    if (!((Boolean)v).booleanValue()) {
                        string3 = string4;
                        string4 = string5;
                        string5 = string3;
                    }
                    string3 = (FileObject)hashMap.get(string4);
                    FileObject fileObject = (FileObject)hashMap.get(string5);
                    if (string3 == null || fileObject == null) continue;
                    HashSet<FileObject> hashSet = (HashSet<FileObject>)hashMap3.get(string3);
                    if (hashSet == null) {
                        hashSet = new HashSet<FileObject>();
                        hashMap3.put(string3, hashSet);
                    }
                    hashSet.add(fileObject);
                }
            }
            try {
                list = Utilities.topologicalSort(hashMap.values(), hashMap3);
            }
            catch (TopologicalSortException topologicalSortException) {
                LOG.log(Level.WARNING, "Can't sort folder children.", topologicalSortException);
                list = topologicalSortException.partialSort();
            }
            if (!((Object)this.children).equals(list)) {
                propertyChangeEvent = new PropertyChangeEvent(this, PROP_CHILDREN, this.children, list);
                this.children = list;
            }
        }
        if (propertyChangeEvent != null) {
            this.pcs.firePropertyChange(propertyChangeEvent);
        }
    }

    private boolean isHidden(FileObject fileObject) {
        if (fileObject.getNameExt().endsWith(HIDDEN_SUFFIX)) {
            return true;
        }
        Enumeration enumeration = fileObject.getAttributes();
        while (enumeration.hasMoreElements()) {
            Object object;
            String string = (String)enumeration.nextElement();
            if (!HIDDEN_ATTR_NAME.equals(string) || !((object = fileObject.getAttribute(string)) instanceof Boolean) || !((Boolean)object).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private String realName(FileObject fileObject) {
        String string = fileObject.getNameExt();
        if (string.endsWith(HIDDEN_SUFFIX)) {
            return string.substring(0, string.length() - HIDDEN_SUFFIX.length());
        }
        return string;
    }

    private class PCL
    implements PropertyChangeListener {
        private PCL() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() != null && "FolderChildren.PROP_CHILD_CHANGED".equals(propertyChangeEvent.getPropertyName())) {
                CompoundFolderChildren.this.pcs.firePropertyChange(new PropertyChangeEvent(CompoundFolderChildren.this, CompoundFolderChildren.PROP_CHILDREN, null, null));
            } else {
                CompoundFolderChildren.this.rebuild();
            }
        }
    }
}

