/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.mimelookup.impl.ClassInfoStorage;
import org.netbeans.modules.editor.mimelookup.impl.FolderPathLookup;
import org.netbeans.modules.editor.mimelookup.impl.InstanceProviderLookup;
import org.netbeans.spi.editor.mimelookup.InstanceProvider;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.ProxyLookup;

public class SwitchLookup
extends Lookup {
    private static final Logger LOG = Logger.getLogger(SwitchLookup.class.getName());
    static final String ROOT_FOLDER = "Editors";
    private MimePath mimePath;
    private final String LOCK = new String("SwitchLookup.LOCK");
    private MappingListener listener;
    private HashMap classLookups = new HashMap();
    private HashMap pathsLookups = new HashMap();
    private HashMap classInfos = new HashMap();
    private HashMap pathsToClasses = new HashMap();

    public SwitchLookup(MimePath mimePath) {
        this.mimePath = mimePath;
        this.listener = new MappingListener();
        ClassInfoStorage.getInstance().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)ClassInfoStorage.getInstance()));
    }

    public Lookup.Result lookup(Lookup.Template template) {
        return this.findLookup(template.getType()).lookup(template);
    }

    public Object lookup(Class clazz) {
        return this.findLookup(clazz).lookup(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lookup findLookup(Class clazz) {
        String string = this.LOCK;
        synchronized (string) {
            String string2 = clazz.getName();
            Object object = (Lookup)this.classLookups.get(string2);
            if (object == null) {
                ClassInfoStorage.Info info = ClassInfoStorage.getInstance().getInfo(string2);
                this.classInfos.put(string2, info);
                Lookup lookup = this.createLookup(info);
                object = new UpdatableProxyLookup(new Lookup[]{lookup});
                this.classLookups.put(string2, object);
            }
            return object;
        }
    }

    private Lookup createLookup(ClassInfoStorage.Info info) {
        Lookup lookup;
        List list = SwitchLookup.computePaths(this.mimePath, ROOT_FOLDER, info.getExtraPath());
        if (info.getInstanceProviderClass() != null) {
            lookup = this.getLookupForProvider(info.getClassName(), list, info.getInstanceProvider());
        } else {
            HashSet<String> hashSet = (HashSet<String>)this.pathsToClasses.get(list);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                this.pathsToClasses.put(list, hashSet);
            }
            hashSet.add(info.getClassName());
            lookup = this.getLookupForPaths(list);
        }
        return lookup;
    }

    private Lookup getLookupForPaths(List list) {
        Object object = (Lookup)this.pathsLookups.get(list);
        if (object == null) {
            object = new FolderPathLookup(list.toArray(new String[list.size()]));
            this.pathsLookups.put(list, object);
        }
        return object;
    }

    private Lookup getLookupForProvider(String string, List list, InstanceProvider instanceProvider) {
        return new InstanceProviderLookup(list.toArray(new String[list.size()]), instanceProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildLookup(String string) {
        String string2 = this.LOCK;
        synchronized (string2) {
            List list;
            ClassInfoStorage.Info info;
            UpdatableProxyLookup updatableProxyLookup = (UpdatableProxyLookup)((Object)this.classLookups.get(string));
            if (updatableProxyLookup == null) {
                return;
            }
            ClassInfoStorage.Info info2 = (ClassInfoStorage.Info)this.classInfos.get(string);
            if (info2.equals(info = ClassInfoStorage.getInstance().getInfo(string))) {
                return;
            }
            if (info2.getInstanceProviderClass() == null) {
                list = SwitchLookup.computePaths(this.mimePath, ROOT_FOLDER, info2.getExtraPath());
                Set set = (Set)this.pathsToClasses.get(list);
                set.remove(string);
                if (set.isEmpty()) {
                    this.pathsToClasses.remove(list);
                    this.pathsLookups.remove(list);
                }
            }
            this.classInfos.put(string, info);
            list = this.createLookup(info);
            updatableProxyLookup.setLookupsEx(new Lookup[]{list});
        }
    }

    static List computePaths(MimePath mimePath, String string, String string2) {
        Object object;
        CharSequence charSequence;
        Object object2;
        ArrayList<String[]> arrayList = new ArrayList<String[]>(mimePath.size());
        String string3 = null;
        if (mimePath.size() > 1) {
            string3 = mimePath.getMimeType(mimePath.size() - 1);
        }
        for (int i = mimePath.size(); i >= 0; --i) {
            object2 = mimePath.getPrefix(i);
            if (object2.size() != 1 || string3 == null || !object2.getMimeType(0).equals(string3)) {
                arrayList.add(SwitchLookup.split((MimePath)object2));
            }
            if (object2.size() <= 0 || (charSequence = SwitchLookup.getGenericPartOfCompoundMimeType((String)(object = object2.getMimeType(object2.size() - 1)))) == null) continue;
            List list = SwitchLookup.forkPaths(arrayList, (String)charSequence, i - 1);
            arrayList.addAll(list);
        }
        if (string3 != null) {
            arrayList.add(1, new String[]{string3});
            String string4 = SwitchLookup.getGenericPartOfCompoundMimeType(string3);
            if (string4 != null) {
                arrayList.add(2, new String[]{string4});
            }
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(arrayList.size());
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = (String[])object2.next();
            charSequence = new StringBuffer(10 * ((String[])object).length + 20);
            if (string != null && string.length() > 0) {
                ((StringBuffer)charSequence).append(string);
            }
            for (int i = 0; i < ((String[])object).length; ++i) {
                if (object[i].length() <= 0) continue;
                if (((StringBuffer)charSequence).length() > 0) {
                    ((StringBuffer)charSequence).append('/');
                }
                ((StringBuffer)charSequence).append(object[i]);
            }
            if (string2 != null && string2.length() > 0) {
                if (((StringBuffer)charSequence).length() > 0) {
                    ((StringBuffer)charSequence).append('/');
                }
                ((StringBuffer)charSequence).append(string2);
            }
            arrayList2.add(((StringBuffer)charSequence).toString());
        }
        return arrayList2;
    }

    static String getGenericPartOfCompoundMimeType(String string) {
        int n = string.lastIndexOf(43);
        if (n != -1 && n < string.length() - 1) {
            int n2 = string.indexOf(47);
            String string2 = string.substring(0, n2 + 1);
            String string3 = string.substring(n + 1);
            if (string3.equals("xml")) {
                string2 = "text/";
            }
            return string2 + string3;
        }
        return null;
    }

    private static String[] split(MimePath mimePath) {
        String[] stringArray = new String[mimePath.size()];
        for (int i = 0; i < mimePath.size(); ++i) {
            stringArray[i] = mimePath.getMimeType(i);
        }
        return stringArray;
    }

    private static List forkPaths(List list, String string, int n) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String[] stringArray = (String[])iterator.next();
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = i != n ? stringArray[i] : string;
            }
            arrayList.add(stringArray2);
        }
        return arrayList;
    }

    private final class MappingListener
    implements PropertyChangeListener {
        private MappingListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Set set = (Set)propertyChangeEvent.getNewValue();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                SwitchLookup.this.rebuildLookup(string);
            }
        }
    }

    private static final class UpdatableProxyLookup
    extends ProxyLookup {
        public UpdatableProxyLookup() {
        }

        public UpdatableProxyLookup(Lookup[] lookupArray) {
            super(lookupArray);
        }

        public void setLookupsEx(Lookup[] lookupArray) {
            this.setLookups(lookupArray);
        }
    }
}

