/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sendopts;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OptionImpl
implements Cloneable {
    public static final Logger LOG;
    public static final Object NO_DEFAULT;
    static final String[] NO_VALUE;
    public final Option root;
    Option option;
    final int argumentType;
    OptionProcessor provider;
    private Appearance appear;
    static /* synthetic */ Class class$org$netbeans$modules$sendopts$OptionImpl;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$netbeans$api$sendopts$CommandLine;
    static /* synthetic */ Class class$org$netbeans$spi$sendopts$Option;
    static /* synthetic */ Class class$org$netbeans$modules$sendopts$OptionImpl$Trampoline;

    OptionImpl(Option option, OptionProcessor optionProcessor, int n) {
        this.root = option;
        this.option = option;
        this.provider = optionProcessor;
        this.argumentType = n;
    }

    public int getShortName() {
        return Trampoline.DEFAULT.getShortName(this.option);
    }

    public String getLongName() {
        return Trampoline.DEFAULT.getLongName(this.option);
    }

    public int getArgumentType() {
        return this.argumentType;
    }

    public int hashCode() {
        return this.option.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof OptionImpl) {
            return this.option.equals(((OptionImpl)object).option);
        }
        return false;
    }

    public final void append(StringBuffer stringBuffer) {
        String string = this.getClass().getName();
        int n = string.indexOf(36);
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        stringBuffer.append(string.substring(n + 1));
        this.appendInternals(stringBuffer);
    }

    void appendInternals(StringBuffer stringBuffer) {
    }

    public String toString() {
        return new StringBuffer().append("Impl:").append(this.option).toString();
    }

    public String findName(boolean bl, String[] stringArray) {
        if (bl) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith(new StringBuffer().append("-").append((char)this.getShortName()).toString())) {
                    return new StringBuffer().append("-").append((char)this.getShortName()).toString();
                }
                if (!stringArray[i].startsWith(new StringBuffer().append("--").append(this.getLongName()).toString())) continue;
                return new StringBuffer().append("--").append(this.getLongName()).toString();
            }
        } else {
            if (this.getLongName() != null) {
                return new StringBuffer().append("--").append(this.getLongName()).toString();
            }
            if (this.getShortName() != -1) {
                return new StringBuffer().append("-").append((char)this.getShortName()).toString();
            }
        }
        return null;
    }

    public Option getOption() {
        return this.option;
    }

    public OptionProcessor getProvider() {
        return this.provider;
    }

    private static <T extends OptionImpl> T doClone(T t) {
        try {
            return (T)((OptionImpl)t.clone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    public static OptionImpl cloneImpl(OptionImpl optionImpl, Option option, OptionProcessor optionProcessor) {
        OptionImpl optionImpl2;
        try {
            optionImpl2 = (OptionImpl)optionImpl.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
        optionImpl2.option = option;
        if (optionProcessor != null) {
            optionImpl2.provider = optionProcessor;
        }
        return optionImpl2;
    }

    public final OptionImpl addWorkingCopy(Collection<OptionImpl> collection) {
        if (collection.contains(this)) {
            OptionImpl optionImpl;
            Iterator<OptionImpl> iterator = collection.iterator();
            while (!(optionImpl = iterator.next()).equals(this)) {
            }
            return optionImpl;
        }
        return this.handleAdd(collection);
    }

    protected abstract OptionImpl handleAdd(Collection<OptionImpl> var1);

    public abstract Appearance checkConsistent(Set<OptionImpl> var1);

    public void markConsistent(Appearance appearance) {
        if (!$assertionsDisabled && this.appear != null && this.appear != appearance) {
            throw new AssertionError();
        }
        this.appear = appearance;
    }

    public abstract void process(String[] var1, Map<Option, String[]> var2) throws CommandException;

    public abstract void associateValue(String var1) throws CommandException;

    public void usage(PrintWriter printWriter, int n) {
        Trampoline.DEFAULT.usage(printWriter, this.option, n);
    }

    public OptionImpl findNotUsedOption(Set<OptionImpl> set) {
        return this.appear == null && set.contains(this) ? this : null;
    }

    public static OptionImpl createNoArg(Option option) {
        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class NoArg
        extends OptionImpl {
            public NoArg(Option option, OptionProcessor optionProcessor, int n) {
                super(option, optionProcessor, 0);
            }

            @Override
            public void process(String[] stringArray, Map<Option, String[]> map) throws CommandException {
                map.put(this.option, NO_VALUE);
            }

            @Override
            public void associateValue(String string) {
                throw new IllegalStateException();
            }

            @Override
            public Appearance checkConsistent(Set<OptionImpl> set) {
                return set.contains(this) ? Appearance.YES : Appearance.NO;
            }

            @Override
            protected OptionImpl handleAdd(Collection<OptionImpl> collection) {
                NoArg noArg = (NoArg)OptionImpl.doClone((OptionImpl)this);
                collection.add(noArg);
                return noArg;
            }
        }
        return new NoArg(option, null, 0);
    }

    public static OptionImpl createOneArg(Option option, boolean bl) {
        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class OneOptionImpl
        extends OptionImpl {
            private String arg;
            static final /* synthetic */ boolean $assertionsDisabled;

            public OneOptionImpl(Option option, OptionProcessor optionProcessor, int n, String string) {
                super(option, optionProcessor, n);
                this.arg = string;
            }

            @Override
            public void process(String[] stringArray, Map<Option, String[]> map) throws CommandException {
                if (this.arg != null) {
                    map.put(this.option, new String[]{this.arg});
                } else {
                    if (!$assertionsDisabled && this.argumentType != 2) {
                        throw new AssertionError();
                    }
                    map.put(this.option, NO_VALUE);
                }
            }

            @Override
            public void associateValue(String string) throws CommandException {
                this.arg = string;
            }

            @Override
            public OptionImpl handleAdd(Collection<OptionImpl> collection) {
                OneOptionImpl oneOptionImpl = (OneOptionImpl)OptionImpl.doClone((OptionImpl)this);
                collection.add(oneOptionImpl);
                return oneOptionImpl;
            }

            @Override
            public Appearance checkConsistent(Set<OptionImpl> set) {
                return set.contains(this) ? Appearance.YES : Appearance.NO;
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$modules$sendopts$OptionImpl == null ? (class$org$netbeans$modules$sendopts$OptionImpl = OptionImpl.class$("org.netbeans.modules.sendopts.OptionImpl")) : class$org$netbeans$modules$sendopts$OptionImpl).desiredAssertionStatus();
            }
        }
        return new OneOptionImpl(option, null, bl ? 1 : 2, null);
    }

    public static OptionImpl createAdd(Option option, final boolean bl) {
        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class AddOptionImpl
        extends OptionImpl {
            private boolean processed;

            public AddOptionImpl(Option option, OptionProcessor optionProcessor) {
                super(option, optionProcessor, n != 0 ? 4 : 3);
            }

            @Override
            public void process(String[] stringArray, Map<Option, String[]> map) throws CommandException {
                map.put(this.option, stringArray);
            }

            @Override
            public void associateValue(String string) throws CommandException {
                throw new IllegalStateException();
            }

            @Override
            public Appearance checkConsistent(Set<OptionImpl> set) {
                return set.contains(this) ? Appearance.YES : Appearance.NO;
            }

            @Override
            protected OptionImpl handleAdd(Collection<OptionImpl> collection) {
                AddOptionImpl addOptionImpl = (AddOptionImpl)OptionImpl.doClone((OptionImpl)this);
                collection.add(addOptionImpl);
                return addOptionImpl;
            }
        }
        return new AddOptionImpl(option, null);
    }

    public static OptionImpl find(Option option) {
        return Trampoline.DEFAULT.impl(option);
    }

    public static OptionImpl create(Option option, final int n, List<Option> list) {
        ArrayList<OptionImpl> arrayList = new ArrayList<OptionImpl>();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(OptionImpl.find(list.get(i)));
        }
        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class AlternativeOptionsImpl
        extends OptionImpl {
            private List<OptionImpl> arr;
            private List<OptionImpl> used;
            private Set<OptionImpl> missing;

            public AlternativeOptionsImpl(Option option, OptionProcessor optionProcessor, List<OptionImpl> list) {
                super(option, optionProcessor, 0);
                this.arr = list;
            }

            @Override
            public Appearance checkConsistent(Set<OptionImpl> set) {
                int n2 = 0;
                this.used = new ArrayList<OptionImpl>();
                this.missing = new HashSet<OptionImpl>();
                HashSet<OptionImpl> hashSet = new HashSet<OptionImpl>();
                for (int i = 0; i < this.arr.size(); ++i) {
                    Appearance appearance = this.arr.get(i).checkConsistent(set);
                    if (appearance.isError()) {
                        return appearance;
                    }
                    if (Appearance.NO == appearance) {
                        this.missing.add(this.arr.get(i));
                        continue;
                    }
                    if (Appearance.MAYBE == appearance) {
                        hashSet.add(this.arr.get(i));
                        continue;
                    }
                    ++n2;
                    this.used.add(this.arr.get(i));
                }
                if (n2 == 0) {
                    return n == 3 ? Appearance.MAYBE : Appearance.NO;
                }
                switch (n) {
                    case 0: {
                        if (n2 != true) break;
                        return Appearance.YES;
                    }
                    case 1: {
                        if (!this.missing.isEmpty()) break;
                        this.used.addAll(hashSet);
                        return Appearance.YES;
                    }
                    case 2: 
                    case 3: {
                        if (n2 < true) break;
                        return Appearance.YES;
                    }
                }
                class MF
                implements MessageFactory {
                    static final /* synthetic */ boolean $assertionsDisabled;

                    MF() {
                    }

                    public String errorMessage(String[] stringArray) {
                        switch (n) {
                            case 0: {
                                if (!$assertionsDisabled && used.size() < 2) {
                                    throw new AssertionError((Object)("At least two: " + used));
                                }
                                String string = ((OptionImpl)used.get(0)).findName(true, stringArray);
                                String string2 = ((OptionImpl)used.get(1)).findName(true, stringArray);
                                if (!$assertionsDisabled && string == null) {
                                    throw new AssertionError();
                                }
                                if (!$assertionsDisabled && string2 == null) {
                                    throw new AssertionError();
                                }
                                return NbBundle.getMessage((Class)(class$org$netbeans$api$sendopts$CommandLine == null ? (class$org$netbeans$api$sendopts$CommandLine = OptionImpl.class$("org.netbeans.api.sendopts.CommandLine")) : class$org$netbeans$api$sendopts$CommandLine), (String)"MSG_CannotTogether", (Object)string, (Object)string2);
                            }
                            case 1: {
                                StringBuffer stringBuffer = new StringBuffer();
                                String string = "";
                                Iterator iterator = arr.iterator();
                                while (iterator.hasNext()) {
                                    OptionImpl optionImpl = (OptionImpl)iterator.next();
                                    stringBuffer.append(string);
                                    stringBuffer.append(optionImpl.findName(false, stringArray));
                                    string = ", ";
                                }
                                return NbBundle.getMessage((Class)(class$org$netbeans$api$sendopts$CommandLine == null ? (class$org$netbeans$api$sendopts$CommandLine = OptionImpl.class$("org.netbeans.api.sendopts.CommandLine")) : class$org$netbeans$api$sendopts$CommandLine), (String)"MSG_MissingOptions", (Object)stringBuffer.toString());
                            }
                            case 2: {
                                StringBuffer stringBuffer = new StringBuffer();
                                String string = "";
                                Iterator iterator = arr.iterator();
                                while (iterator.hasNext()) {
                                    OptionImpl optionImpl = (OptionImpl)iterator.next();
                                    stringBuffer.append(string);
                                    stringBuffer.append(optionImpl.findName(false, stringArray));
                                    string = ", ";
                                }
                                return NbBundle.getMessage((Class)(class$org$netbeans$api$sendopts$CommandLine == null ? (class$org$netbeans$api$sendopts$CommandLine = OptionImpl.class$("org.netbeans.api.sendopts.CommandLine")) : class$org$netbeans$api$sendopts$CommandLine), (String)"MSG_NeedAtLeastOne", (Object)stringBuffer.toString());
                            }
                        }
                        throw new IllegalStateException("Type: " + n);
                    }

                    static {
                        $assertionsDisabled = !(class$org$netbeans$modules$sendopts$OptionImpl == null ? (class$org$netbeans$modules$sendopts$OptionImpl = OptionImpl.class$("org.netbeans.modules.sendopts.OptionImpl")) : class$org$netbeans$modules$sendopts$OptionImpl).desiredAssertionStatus();
                    }
                }
                return Appearance.createError(new MF());
            }

            @Override
            public void markConsistent(Appearance appearance) {
                super.markConsistent(appearance);
                for (OptionImpl optionImpl : this.arr) {
                    optionImpl.markConsistent(appearance);
                }
            }

            @Override
            public OptionImpl findNotUsedOption(Set<OptionImpl> set) {
                OptionImpl optionImpl = super.findNotUsedOption(set);
                if (optionImpl != null) {
                    return optionImpl;
                }
                for (OptionImpl optionImpl2 : this.arr) {
                    optionImpl = optionImpl2.findNotUsedOption(set);
                    if (optionImpl == null) continue;
                    return optionImpl;
                }
                return null;
            }

            @Override
            public void associateValue(String string) throws CommandException {
            }

            @Override
            public OptionImpl handleAdd(Collection<OptionImpl> collection) {
                ArrayList<OptionImpl> arrayList = new ArrayList<OptionImpl>();
                for (int i = 0; i < this.arr.size(); ++i) {
                    arrayList.add(this.arr.get(i).addWorkingCopy(collection));
                }
                AlternativeOptionsImpl alternativeOptionsImpl = (AlternativeOptionsImpl)OptionImpl.doClone((OptionImpl)this);
                alternativeOptionsImpl.arr = arrayList;
                collection.add(alternativeOptionsImpl);
                return alternativeOptionsImpl;
            }

            @Override
            public void process(String[] stringArray, Map<Option, String[]> map) throws CommandException {
                map.put(this.option, NO_VALUE);
                for (OptionImpl optionImpl : this.used) {
                    optionImpl.process(stringArray, map);
                }
            }

            @Override
            public String findName(boolean bl, String[] stringArray) {
                for (OptionImpl optionImpl : this.arr) {
                    String string = optionImpl.findName(bl, stringArray);
                    if (string == null) continue;
                    return string;
                }
                return null;
            }
        }
        return new AlternativeOptionsImpl(option, null, arrayList);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$org$netbeans$modules$sendopts$OptionImpl == null ? (class$org$netbeans$modules$sendopts$OptionImpl = OptionImpl.class$("org.netbeans.modules.sendopts.OptionImpl")) : class$org$netbeans$modules$sendopts$OptionImpl).desiredAssertionStatus();
        LOG = Logger.getLogger((class$org$netbeans$modules$sendopts$OptionImpl == null ? (class$org$netbeans$modules$sendopts$OptionImpl = OptionImpl.class$("org.netbeans.modules.sendopts.OptionImpl")) : class$org$netbeans$modules$sendopts$OptionImpl).getName());
        NO_DEFAULT = new Object();
        NO_VALUE = new String[0];
    }

    public static class Appearance {
        private MessageFactory msg;
        public static final Appearance YES = new Appearance();
        public static final Appearance NO = new Appearance();
        public static final Appearance MAYBE = new Appearance();

        private Appearance() {
        }

        public static final Appearance createError(MessageFactory messageFactory) {
            Appearance appearance = new Appearance();
            appearance.msg = messageFactory;
            return appearance;
        }

        public final boolean isThere() {
            return this == YES;
        }

        public boolean isError() {
            return YES != this && NO != this && MAYBE != this;
        }

        public String errorMessage(String[] stringArray) {
            return this.msg.errorMessage(stringArray);
        }

        public String toString() {
            if (this == YES) {
                return "YES";
            }
            if (this == NO) {
                return "NO";
            }
            if (this == MAYBE) {
                return "MAYBE";
            }
            return "ERROR[" + this.errorMessage(new String[0]) + "]";
        }
    }

    public static interface MessageFactory {
        public String errorMessage(String[] var1);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Trampoline {
        public static Trampoline DEFAULT;

        public abstract OptionImpl impl(Option var1);

        public abstract Env create(InputStream var1, OutputStream var2, OutputStream var3, File var4);

        public abstract void usage(PrintWriter var1, Option var2, int var3);

        public abstract Option[] getOptions(OptionProcessor var1);

        public abstract void process(OptionProcessor var1, Env var2, Map<Option, String[]> var3) throws CommandException;

        public abstract String getLongName(Option var1);

        public abstract int getShortName(Option var1);

        public abstract String getDisplayName(Option var1, Locale var2);

        static {
            try {
                Class.forName((class$org$netbeans$spi$sendopts$Option == null ? (class$org$netbeans$spi$sendopts$Option = OptionImpl.class$("org.netbeans.spi.sendopts.Option")) : class$org$netbeans$spi$sendopts$Option).getName(), true, (class$org$netbeans$modules$sendopts$OptionImpl$Trampoline == null ? (class$org$netbeans$modules$sendopts$OptionImpl$Trampoline = OptionImpl.class$("org.netbeans.modules.sendopts.OptionImpl$Trampoline")) : class$org$netbeans$modules$sendopts$OptionImpl$Trampoline).getClassLoader());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

