/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.lexer;

import java.util.ConcurrentModificationException;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.SubSequenceTokenList;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.inc.FilterSnapshotTokenList;
import org.netbeans.lib.lexer.inc.SnapshotTokenList;
import org.netbeans.lib.lexer.token.AbstractToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenSequence<T extends TokenId> {
    private TokenList<T> tokenList;
    private AbstractToken<T> token;
    private int tokenIndex;
    private int tokenOffset = -1;
    private final int modCount;
    private int[] parentTokenIndexes;

    TokenSequence(TokenList<T> tokenList) {
        this.tokenList = tokenList;
        this.modCount = tokenList.modCount();
    }

    public Language<T> language() {
        return LexerUtilsConstants.mostEmbeddedLanguage(this.languagePath());
    }

    public LanguagePath languagePath() {
        return this.tokenList.languagePath();
    }

    public Token<T> token() {
        return this.token;
    }

    public Token<T> offsetToken() {
        this.checkTokenNotNull();
        if (this.token.isFlyweight()) {
            this.token = this.tokenList.replaceFlyToken(this.tokenIndex, this.token, this.offset());
        }
        return this.token;
    }

    public int offset() {
        this.checkTokenNotNull();
        if (this.tokenOffset == -1) {
            this.tokenOffset = this.tokenList.tokenOffset(this.tokenIndex);
        }
        return this.tokenOffset;
    }

    public int index() {
        return this.tokenIndex;
    }

    public TokenSequence<? extends TokenId> embedded() {
        this.checkTokenNotNull();
        return this.embeddedImpl(null);
    }

    private <ET extends TokenId> TokenSequence<ET> embeddedImpl(Language<ET> language) {
        TokenList<ET> tokenList = EmbeddingContainer.getEmbedding(this.tokenList, this.tokenIndex, language);
        if (tokenList != null) {
            TokenList<T> tokenList2 = this.tokenList;
            if (this.tokenList.getClass() == SubSequenceTokenList.class) {
                tokenList2 = ((SubSequenceTokenList)this.tokenList).delegate();
            }
            if (tokenList2.getClass() == FilterSnapshotTokenList.class) {
                tokenList = new FilterSnapshotTokenList<ET>(tokenList, ((FilterSnapshotTokenList)tokenList2).tokenOffsetDiff());
            } else if (tokenList2.getClass() == SnapshotTokenList.class) {
                tokenList = new FilterSnapshotTokenList<ET>(tokenList, this.offset() - this.token().offset(null));
            }
            return new TokenSequence<ET>(tokenList);
        }
        return null;
    }

    public <ET extends TokenId> TokenSequence<ET> embedded(Language<ET> language) {
        this.checkTokenNotNull();
        return this.embeddedImpl(language);
    }

    public boolean createEmbedding(Language<? extends TokenId> language, int n, int n2) {
        return this.createEmbedding(language, n, n2, false);
    }

    public boolean createEmbedding(Language<? extends TokenId> language, int n, int n2, boolean bl) {
        this.checkTokenNotNull();
        return EmbeddingContainer.createEmbedding(this.tokenList, this.tokenIndex, language, n, n2, bl);
    }

    public boolean moveNext() {
        Object object;
        this.checkModCount();
        if (this.token != null) {
            ++this.tokenIndex;
        }
        if ((object = this.tokenList.tokenOrEmbeddingContainer(this.tokenIndex)) != null) {
            AbstractToken<T> abstractToken = this.token;
            this.token = LexerUtilsConstants.token(object);
            if (this.tokenOffset != -1) {
                this.tokenOffset = abstractToken != null ? (this.tokenList.isContinuous() || this.token.isFlyweight() ? (this.tokenOffset += abstractToken.length()) : -1) : -1;
            }
            return true;
        }
        if (this.token != null) {
            --this.tokenIndex;
        }
        return false;
    }

    public boolean movePrevious() {
        this.checkModCount();
        if (this.tokenIndex > 0) {
            AbstractToken<T> abstractToken = this.token;
            --this.tokenIndex;
            this.token = LexerUtilsConstants.token(this.tokenList.tokenOrEmbeddingContainer(this.tokenIndex));
            if (this.tokenOffset != -1) {
                this.tokenOffset = this.tokenList.isContinuous() || abstractToken.isFlyweight() ? (this.tokenOffset -= this.token.length()) : -1;
            }
            return true;
        }
        return false;
    }

    public int moveIndex(int n) {
        this.checkModCount();
        if (n >= 0) {
            Object object = this.tokenList.tokenOrEmbeddingContainer(n);
            if (object != null) {
                this.resetTokenIndex(n);
            } else {
                this.resetTokenIndex(this.tokenCount());
            }
        } else {
            this.resetTokenIndex(0);
        }
        return n - this.tokenIndex;
    }

    public void moveStart() {
        this.moveIndex(0);
    }

    public void moveEnd() {
        this.moveIndex(this.tokenCount());
    }

    public int move(int n) {
        int n2;
        this.checkModCount();
        int n3 = this.tokenList.tokenCountCurrent();
        if (n3 == 0) {
            if (this.tokenList.tokenOrEmbeddingContainer(0) == null) {
                this.resetTokenIndex(0);
                return n;
            }
            n3 = this.tokenList.tokenCountCurrent();
        }
        if (n > (n2 = this.tokenList.tokenOffset(n3 - 1))) {
            int n4 = LexerUtilsConstants.token(this.tokenList, n3 - 1).length();
            while (n >= n2 + n4) {
                Object object = this.tokenList.tokenOrEmbeddingContainer(n3);
                if (object != null) {
                    AbstractToken abstractToken = LexerUtilsConstants.token(object);
                    n2 = abstractToken.isFlyweight() ? (n2 += n4) : this.tokenList.tokenOffset(n3);
                    n4 = abstractToken.length();
                    ++n3;
                    continue;
                }
                this.resetTokenIndex(n3);
                this.tokenOffset = n2 + n4;
                return n - this.tokenOffset;
            }
            this.resetTokenIndex(n3 - 1);
            this.tokenOffset = n2;
            return n - n2;
        }
        int n5 = 0;
        int n6 = n3 - 1;
        while (n5 <= n6) {
            int n7 = (n5 + n6) / 2;
            int n8 = this.tokenList.tokenOffset(n7);
            if (n8 < n) {
                n5 = n7 + 1;
                continue;
            }
            if (n8 > n) {
                n6 = n7 - 1;
                continue;
            }
            this.resetTokenIndex(n7);
            this.tokenOffset = n8;
            return 0;
        }
        if (n6 >= 0) {
            AbstractToken<T> abstractToken = LexerUtilsConstants.token(this.tokenList, n6);
            n2 = this.tokenList.tokenOffset(n6);
            if (!this.tokenList.isContinuous() && n > n2 + abstractToken.length()) {
                ++n6;
                n2 += abstractToken.length();
            }
        } else {
            n6 = 0;
            n2 = this.tokenList.tokenOffset(0);
        }
        this.resetTokenIndex(n6);
        this.tokenOffset = n2;
        return n - n2;
    }

    public boolean isEmpty() {
        return this.tokenIndex == 0 && this.tokenList.tokenOrEmbeddingContainer(0) == null;
    }

    public int tokenCount() {
        this.checkModCount();
        return this.tokenList.tokenCount();
    }

    public TokenSequence<T> subSequence(int n) {
        return this.subSequence(n, Integer.MAX_VALUE);
    }

    public TokenSequence<T> subSequence(int n, int n2) {
        TokenList<T> tokenList;
        this.checkModCount();
        if (this.tokenList.getClass() == SubSequenceTokenList.class) {
            SubSequenceTokenList subSequenceTokenList = (SubSequenceTokenList)this.tokenList;
            tokenList = subSequenceTokenList.delegate();
            n = Math.max(n, subSequenceTokenList.limitStartOffset());
            n2 = Math.min(n2, subSequenceTokenList.limitEndOffset());
        } else {
            tokenList = this.tokenList;
        }
        return new TokenSequence<T>(new SubSequenceTokenList<T>(tokenList, n, n2));
    }

    public String toString() {
        return LexerUtilsConstants.appendTokenList(null, this.tokenList, this.tokenIndex).toString();
    }

    int[] parentTokenIndexes() {
        return this.parentTokenIndexes;
    }

    private void resetTokenIndex(int n) {
        this.tokenIndex = n;
        this.token = null;
        this.tokenOffset = -1;
    }

    private void checkTokenNotNull() {
        if (this.token == null) {
            throw new IllegalStateException("No token fetched by moveNext() from token sequence yet: index=" + this.tokenIndex);
        }
    }

    private void checkModCount() {
        if (this.tokenList.modCount() != this.modCount) {
            throw new ConcurrentModificationException("This token sequence is no longer valid. Underlying token hierarchy has been modified: " + this.modCount + " != " + this.tokenList.modCount());
        }
    }
}

