/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.List;
import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.FlyOffsetGapList;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LAState;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TextLexerInputOperation;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.inc.MutableTokenList;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.inc.TokenListChange;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.TextToken;
import org.netbeans.spi.lexer.LanguageEmbedding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EmbeddedTokenList<T extends TokenId>
extends FlyOffsetGapList<Object>
implements MutableTokenList<T> {
    private static final boolean testing = Boolean.getBoolean("netbeans.debug.lexer.test");
    private EmbeddingContainer<? extends TokenId> embeddingContainer;
    private final LanguageEmbedding<T> embedding;
    private final LanguagePath languagePath;
    private LAState laState;
    private EmbeddedTokenList<? extends TokenId> nextEmbedding;

    public EmbeddedTokenList(EmbeddingContainer<? extends TokenId> embeddingContainer, LanguagePath languagePath, LanguageEmbedding<T> languageEmbedding, EmbeddedTokenList<? extends TokenId> embeddedTokenList) {
        this.embeddingContainer = embeddingContainer;
        this.languagePath = languagePath;
        this.embedding = languageEmbedding;
        this.nextEmbedding = embeddedTokenList;
        if (embeddingContainer.rootTokenList().modCount() != -1 || testing) {
            this.laState = LAState.empty();
        }
        this.init();
    }

    private void init() {
        LexerInputOperation<T> lexerInputOperation = this.createLexerInputOperation(0, this.startOffset(), null);
        AbstractToken<T> abstractToken = lexerInputOperation.nextToken();
        while (abstractToken != null) {
            this.updateElementOffsetAdd(abstractToken);
            this.add(abstractToken);
            if (this.laState != null) {
                this.laState = this.laState.add(lexerInputOperation.lookahead(), lexerInputOperation.lexerState());
            }
            abstractToken = lexerInputOperation.nextToken();
        }
        lexerInputOperation.release();
        lexerInputOperation = null;
        this.trimToSize();
        if (this.laState != null) {
            this.laState.trimToSize();
        }
    }

    EmbeddedTokenList<? extends TokenId> nextEmbedding() {
        return this.nextEmbedding;
    }

    void setNextEmbedding(EmbeddedTokenList<? extends TokenId> embeddedTokenList) {
        this.nextEmbedding = embeddedTokenList;
    }

    @Override
    public LanguagePath languagePath() {
        return this.languagePath;
    }

    @Override
    public int tokenCount() {
        return this.size();
    }

    @Override
    public synchronized Object tokenOrEmbeddingContainer(int n) {
        return n < this.size() ? this.get(n) : null;
    }

    private Token existingToken(int n) {
        return LexerUtilsConstants.token(this.tokenOrEmbeddingContainer(n));
    }

    @Override
    public int lookahead(int n) {
        return this.laState != null ? this.laState.lookahead(n) : -1;
    }

    @Override
    public Object state(int n) {
        return this.laState != null ? this.laState.state(n) : null;
    }

    @Override
    public int tokenOffset(int n) {
        return this.elementOffset(n);
    }

    @Override
    public int childTokenOffset(int n) {
        this.embeddingContainer.updateOffsets();
        return this.embeddingContainer.tokenStartOffset() + this.embedding.startSkipLength() + this.childTokenRelOffset(n);
    }

    public int childTokenOffsetShift(int n) {
        this.updateStartOffset();
        return this.embeddingContainer.rootTokenOffsetShift() + this.childTokenRelOffset(n);
    }

    private int childTokenRelOffset(int n) {
        return n < this.offsetGapStart() ? n : n - this.offsetGapLength();
    }

    @Override
    public char childTokenCharAt(int n, int n2) {
        return this.embeddingContainer.charAt(this.embedding.startSkipLength() + this.childTokenRelOffset(n) + n2);
    }

    @Override
    public int modCount() {
        return this.root().modCount();
    }

    protected int startOffset() {
        return this.embeddingContainer.tokenStartOffset() + this.embedding.startSkipLength();
    }

    public void updateStartOffset() {
        this.embeddingContainer.updateOffsets();
    }

    @Override
    public TokenList<? extends TokenId> root() {
        return this.embeddingContainer.rootTokenList();
    }

    @Override
    public TokenHierarchyOperation<?, ? extends TokenId> tokenHierarchyOperation() {
        return this.root().tokenHierarchyOperation();
    }

    public AbstractToken<? extends TokenId> rootToken() {
        return this.embeddingContainer.rootToken();
    }

    protected int elementRawOffset(Object object) {
        return object.getClass() == EmbeddingContainer.class ? ((EmbeddingContainer)object).token().rawOffset() : ((AbstractToken)object).rawOffset();
    }

    protected void setElementRawOffset(Object object, int n) {
        if (object.getClass() == EmbeddingContainer.class) {
            ((EmbeddingContainer)object).token().setRawOffset(n);
        } else {
            ((AbstractToken)object).setRawOffset(n);
        }
    }

    protected boolean isElementFlyweight(Object object) {
        return object.getClass() != EmbeddingContainer.class && ((AbstractToken)object).isFlyweight();
    }

    protected int elementLength(Object object) {
        return LexerUtilsConstants.token(object).length();
    }

    @Override
    public synchronized AbstractToken<T> replaceFlyToken(int n, AbstractToken<T> abstractToken, int n2) {
        TextToken textToken = ((TextToken)abstractToken).createCopy(this, this.offset2Raw(n2));
        this.set(n, textToken);
        return textToken;
    }

    @Override
    public synchronized void wrapToken(int n, EmbeddingContainer embeddingContainer) {
        this.set(n, embeddingContainer);
    }

    @Override
    public InputAttributes inputAttributes() {
        return this.root().inputAttributes();
    }

    @Override
    public Object tokenOrEmbeddingContainerUnsync(int n) {
        return this.get(n);
    }

    @Override
    public int tokenCountCurrent() {
        return this.size();
    }

    @Override
    public LexerInputOperation<T> createLexerInputOperation(int n, int n2, Object object) {
        CharSequence charSequence = this.embeddingContainer.token().text();
        int n3 = this.embeddingContainer.tokenStartOffset();
        int n4 = n3 + charSequence.length() - this.embedding.endSkipLength();
        return new TextLexerInputOperation(this, n, object, charSequence, n3, n2, n4);
    }

    @Override
    public boolean isFullyLexed() {
        return true;
    }

    @Override
    public void replaceTokens(TokenHierarchyEventInfo tokenHierarchyEventInfo, TokenListChange<T> tokenListChange, int n) {
        AbstractToken abstractToken;
        List<Object> list;
        int n2;
        int n3 = tokenListChange.index();
        Object[] objectArray = new Object[n];
        this.copyElements(n3, n3 + n, objectArray, 0);
        int n4 = tokenListChange.offset();
        for (n2 = 0; n2 < n; ++n2) {
            list = objectArray[n2];
            abstractToken = LexerUtilsConstants.token(list);
            if (!abstractToken.isFlyweight()) {
                this.updateElementOffsetRemove(abstractToken);
                abstractToken.setTokenList(null);
            }
            n4 += abstractToken.length();
        }
        this.remove(n3, n);
        this.laState.remove(n3, n);
        tokenListChange.setRemovedTokens(objectArray);
        tokenListChange.setRemovedEndOffset(n4);
        n2 = tokenHierarchyEventInfo.insertedLength() - tokenHierarchyEventInfo.removedLength();
        if (this.offsetGapStart() != tokenListChange.offset()) {
            this.moveOffsetGap(tokenListChange.offset(), Math.min(n3, tokenListChange.offsetGapIndex()));
        }
        this.updateOffsetGapLength(-n2);
        list = tokenListChange.addedTokensOrBranches();
        if (list != null) {
            abstractToken = list.iterator();
            while (abstractToken.hasNext()) {
                Object e = abstractToken.next();
                AbstractToken abstractToken2 = (AbstractToken)e;
                this.updateElementOffsetAdd(abstractToken2);
            }
            this.addAll(n3, list);
            this.laState = this.laState.addAll(n3, tokenListChange.laState());
            tokenListChange.syncAddedTokenCount();
            if (n == 1 && list.size() == 1 && (abstractToken = LexerUtilsConstants.token(objectArray[0]).id()) == tokenListChange.addedToken(0).id()) {
                tokenListChange.markBoundsChange();
            }
        }
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public Set<T> skipTokenIds() {
        return null;
    }

    public void setEmbeddingContainer(EmbeddingContainer<? extends TokenId> embeddingContainer) {
        this.embeddingContainer = embeddingContainer;
    }

    public String toString() {
        return LexerUtilsConstants.appendTokenList(null, this, -1).toString();
    }
}

