/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenHierarchyEventType;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.LexerApiPackageAccessor;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.inc.TokenChangeInfo;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.spi.lexer.LanguageEmbedding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EmbeddingContainer<T extends TokenId> {
    private static final boolean testing = Boolean.getBoolean("netbeans.debug.lexer.test");
    private final AbstractToken<T> token;
    private int cachedModCount;
    private final TokenList<? extends TokenId> rootTokenList;
    private final AbstractToken<? extends TokenId> rootToken;
    private int tokenStartOffset;
    private EmbeddedTokenList<? extends TokenId> firstEmbedding;
    private int rootTokenOffsetShift;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TokenId, ET extends TokenId> EmbeddedTokenList<ET> getEmbedding(TokenList<T> tokenList, int n, Language<ET> language) {
        EmbeddedTokenList<TokenId> embeddedTokenList = null;
        TokenList<TokenId> tokenList2 = tokenList.root();
        synchronized (tokenList2) {
            AbstractToken abstractToken;
            EmbeddedTokenList<TokenId> embeddedTokenList2;
            EmbeddingContainer<T> embeddingContainer;
            AbstractToken abstractToken2;
            Object object = tokenList.tokenOrEmbeddingContainer(n);
            if (object.getClass() == EmbeddingContainer.class) {
                abstractToken2 = (EmbeddingContainer<T>)object;
                embeddingContainer = abstractToken2;
                embeddingContainer.updateOffsets();
                for (embeddedTokenList2 = embeddingContainer.firstEmbedding(); embeddedTokenList2 != null; embeddedTokenList2 = embeddedTokenList2.nextEmbedding()) {
                    if (language == null || embeddedTokenList2.languagePath().innerLanguage() == language) {
                        EmbeddedTokenList<TokenId> embeddedTokenList3 = embeddedTokenList2;
                        return embeddedTokenList3;
                    }
                    embeddedTokenList = embeddedTokenList2;
                }
                abstractToken = embeddingContainer.token();
            } else {
                embeddingContainer = null;
                abstractToken2 = (AbstractToken)object;
                abstractToken = abstractToken2;
                if (abstractToken.isFlyweight()) {
                    return null;
                }
            }
            abstractToken2 = tokenList.languagePath();
            embeddedTokenList2 = LexerUtilsConstants.findEmbedding(abstractToken, abstractToken2, tokenList.inputAttributes());
            if (embeddedTokenList2 != null && (language == null || language == ((LanguageEmbedding)((Object)embeddedTokenList2)).language()) && ((LanguageEmbedding)((Object)embeddedTokenList2)).startSkipLength() + ((LanguageEmbedding)((Object)embeddedTokenList2)).endSkipLength() <= abstractToken.length()) {
                if (embeddingContainer == null) {
                    embeddingContainer = new EmbeddingContainer<T>(abstractToken);
                    tokenList.wrapToken(n, embeddingContainer);
                }
                LanguagePath languagePath = LanguagePath.get(abstractToken2, ((LanguageEmbedding)((Object)embeddedTokenList2)).language());
                EmbeddedTokenList<TokenId> embeddedTokenList4 = new EmbeddedTokenList<TokenId>((EmbeddingContainer<TokenId>)embeddingContainer, languagePath, (LanguageEmbedding<TokenId>)((Object)embeddedTokenList2), (EmbeddedTokenList<TokenId>)null);
                if (embeddedTokenList != null) {
                    embeddedTokenList.setNextEmbedding(embeddedTokenList4);
                } else {
                    embeddingContainer.setFirstEmbedding(embeddedTokenList4);
                }
                return embeddedTokenList4;
            }
            return null;
        }
    }

    public static EmbeddedTokenList<? extends TokenId> getEmbeddingIfExists(Object object) {
        if (object.getClass() == EmbeddingContainer.class) {
            EmbeddingContainer embeddingContainer = (EmbeddingContainer)object;
            embeddingContainer.updateOffsets();
            EmbeddedTokenList<TokenId> embeddedTokenList = embeddingContainer.firstEmbedding();
            return embeddedTokenList;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TokenId, ET extends TokenId> boolean createEmbedding(TokenList<T> tokenList, int n, Language<ET> language, int n2, int n3, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        TokenList<TokenId> tokenList2;
        Object object4;
        Object object5;
        TokenHierarchyOperation<?, TokenId> tokenHierarchyOperation = tokenList.tokenHierarchyOperation();
        if (tokenHierarchyOperation == null) {
            return false;
        }
        TokenList<TokenId> tokenList3 = tokenList.root();
        Object object6 = tokenList.tokenOrEmbeddingContainer(n);
        TokenList<TokenId> tokenList4 = tokenList3;
        synchronized (tokenList4) {
            if (object6.getClass() == EmbeddingContainer.class) {
                object4 = object5 = (EmbeddingContainer)object6;
                for (tokenList2 = ((EmbeddingContainer)object4).firstEmbedding(); tokenList2 != null; tokenList2 = tokenList2.nextEmbedding()) {
                    if (language != tokenList2.languagePath().innerLanguage()) continue;
                    return false;
                }
                object3 = ((EmbeddingContainer)object4).token();
            } else {
                object5 = (AbstractToken)object6;
                object3 = object5;
                if (((AbstractToken)object3).isFlyweight()) {
                    return false;
                }
                object4 = new EmbeddingContainer<T>(object3);
                tokenList.wrapToken(n, (EmbeddingContainer<T>)object4);
            }
        }
        tokenList2 = tokenList3;
        synchronized (tokenList2) {
            if (n2 + n3 > ((AbstractToken)object3).length()) {
                return false;
            }
            object5 = LanguageEmbedding.create(language, n2, n3, bl);
            object2 = tokenList.languagePath();
            object = LanguagePath.get((LanguagePath)object2, language);
            tokenList4 = new EmbeddedTokenList<TokenId>((EmbeddingContainer<TokenId>)((EmbeddingContainer<? extends TokenId>)object4), (LanguagePath)object, (LanguageEmbedding<TokenId>)object5, ((EmbeddingContainer)object4).firstEmbedding());
            ((EmbeddingContainer)object4).setFirstEmbedding((EmbeddedTokenList<? extends TokenId>)tokenList4);
        }
        int n4 = ((EmbeddingContainer)object4).tokenStartOffset();
        object2 = new TokenHierarchyEventInfo(tokenHierarchyOperation, TokenHierarchyEventType.EMBEDDING, n4, 0, "", 0);
        ((TokenHierarchyEventInfo)object2).setAffectedStartOffset(n4);
        ((TokenHierarchyEventInfo)object2).setAffectedEndOffset(n4 + ((AbstractToken)object3).length());
        object = new TokenChangeInfo<T>(tokenList);
        ((TokenChangeInfo)object).setIndex(n);
        ((TokenChangeInfo)object).setOffset(n4);
        ((TokenHierarchyEventInfo)object2).setTokenChangeInfo((TokenChangeInfo<? extends TokenId>)object);
        TokenChangeInfo<TokenId> tokenChangeInfo = new TokenChangeInfo<TokenId>(tokenList4);
        tokenChangeInfo.setIndex(0);
        tokenChangeInfo.setOffset(n4 + ((LanguageEmbedding)object5).startSkipLength());
        ((TokenChangeInfo)object).addEmbeddedChange(tokenChangeInfo);
        tokenHierarchyOperation.fireTokenHierarchyChanged(LexerApiPackageAccessor.get().createTokenChangeEvent((TokenHierarchyEventInfo)object2));
        return true;
    }

    public EmbeddingContainer(AbstractToken<T> abstractToken) {
        this.token = abstractToken;
        TokenList<T> tokenList = abstractToken.tokenList();
        this.rootTokenList = tokenList.root();
        this.rootToken = tokenList.getClass() == EmbeddedTokenList.class ? ((EmbeddedTokenList)tokenList).rootToken() : abstractToken;
        this.cachedModCount = -2;
        this.updateOffsets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOffsets() {
        TokenList<? extends TokenId> tokenList = this.rootTokenList;
        synchronized (tokenList) {
            if (this.cachedModCount != this.rootTokenList.modCount()) {
                this.cachedModCount = this.rootTokenList.modCount();
                this.tokenStartOffset = this.token.offset(null);
                this.rootTokenOffsetShift = this.tokenStartOffset - this.rootToken.offset(null);
            }
        }
    }

    public AbstractToken<T> token() {
        return this.token;
    }

    public TokenList<? extends TokenId> rootTokenList() {
        return this.rootTokenList;
    }

    public AbstractToken<? extends TokenId> rootToken() {
        return this.rootToken;
    }

    public int tokenStartOffset() {
        return this.tokenStartOffset;
    }

    public int rootTokenOffsetShift() {
        return this.rootTokenOffsetShift;
    }

    public char charAt(int n) {
        return this.rootToken.charAt(this.rootTokenOffsetShift + n);
    }

    public EmbeddedTokenList<? extends TokenId> firstEmbedding() {
        return this.firstEmbedding;
    }

    void setFirstEmbedding(EmbeddedTokenList<? extends TokenId> embeddedTokenList) {
        this.firstEmbedding = embeddedTokenList;
    }
}

