/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.LanguageProvider;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LanguageManager
extends LanguageProvider
implements LookupListener,
PropertyChangeListener {
    private static final Language<TokenId> NO_LANG = new LanguageHierarchy<TokenId>(){

        @Override
        protected Lexer<TokenId> createLexer(LexerRestartInfo<TokenId> lexerRestartInfo) {
            return null;
        }

        @Override
        protected Collection<TokenId> createTokenIds() {
            return Collections.emptyList();
        }

        @Override
        protected String mimeType() {
            return "obscure/no-language-marker";
        }
    }.language();
    private static final LanguageEmbedding<TokenId> NO_LANG_EMBEDDING = LanguageEmbedding.create(NO_LANG, 0, 0);
    private static LanguageManager instance = null;
    private Lookup.Result<LanguageProvider> lookupResult = null;
    private List<LanguageProvider> providers = Collections.emptyList();
    private HashMap<String, WeakReference<Language<? extends TokenId>>> langCache = new HashMap();
    private WeakHashMap<Token, LanguageEmbedding<? extends TokenId>> tokenLangCache = new WeakHashMap();
    private final String LOCK = new String("LanguageManager.LOCK");

    public static synchronized LanguageManager getInstance() {
        if (instance == null) {
            instance = new LanguageManager();
        }
        return instance;
    }

    private LanguageManager() {
        this.lookupResult = Lookup.getDefault().lookup(new Lookup.Template(LanguageProvider.class));
        this.lookupResult.addLookupListener((LookupListener)this);
        this.refreshProviders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Language<? extends TokenId> findLanguage(String string) {
        String string2 = this.LOCK;
        synchronized (string2) {
            Language<TokenId> language;
            WeakReference<Language<? extends TokenId>> weakReference = this.langCache.get(string);
            Language<TokenId> language2 = language = weakReference == null ? null : (Language<TokenId>)weakReference.get();
            if (language == null) {
                LanguageProvider languageProvider;
                Iterator<LanguageProvider> iterator = this.providers.iterator();
                while (iterator.hasNext() && null == (language = (languageProvider = iterator.next()).findLanguage(string))) {
                }
                if (language == null) {
                    language = NO_LANG;
                }
                this.langCache.put(string, new WeakReference<Language<TokenId>>(language));
            }
            return language == NO_LANG ? null : language;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LanguageEmbedding<? extends TokenId> findLanguageEmbedding(Token<? extends TokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
        String string = this.LOCK;
        synchronized (string) {
            LanguageEmbedding<? extends TokenId> languageEmbedding = this.tokenLangCache.get(token);
            if (languageEmbedding == null) {
                LanguageProvider languageProvider;
                Iterator<LanguageProvider> iterator = this.providers.iterator();
                while (iterator.hasNext() && null == (languageEmbedding = (languageProvider = iterator.next()).findLanguageEmbedding(token, languagePath, inputAttributes))) {
                }
                if (languageEmbedding == null) {
                    languageEmbedding = NO_LANG_EMBEDDING;
                }
                this.tokenLangCache.put(token, languageEmbedding);
            }
            return languageEmbedding == NO_LANG_EMBEDDING ? null : languageEmbedding;
        }
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.refreshProviders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == null) {
            String string = this.LOCK;
            synchronized (string) {
                this.langCache.clear();
                this.tokenLangCache.clear();
            }
        }
        if ("LanguageProvider.PROP_LANGUAGE".equals(propertyChangeEvent.getPropertyName())) {
            String string = this.LOCK;
            synchronized (string) {
                this.langCache.clear();
            }
        }
        if ("LanguageProvider.PROP_EMBEDDED_LANGUAGE".equals(propertyChangeEvent.getPropertyName())) {
            String string = this.LOCK;
            synchronized (string) {
                this.tokenLangCache.clear();
            }
        }
        this.firePropertyChange(propertyChangeEvent.getPropertyName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshProviders() {
        Collection collection = this.lookupResult.allInstances();
        String string = this.LOCK;
        synchronized (string) {
            for (LanguageProvider languageProvider : this.providers) {
                languageProvider.removePropertyChangeListener(this);
            }
            this.providers = new ArrayList<LanguageProvider>(collection);
            for (LanguageProvider languageProvider : this.providers) {
                languageProvider.addPropertyChangeListener(this);
            }
            this.langCache.clear();
            this.tokenLangCache.clear();
        }
    }
}

