/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.lexer.CharProvider;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LanguageManager;
import org.netbeans.lib.lexer.LanguageOperation;
import org.netbeans.lib.lexer.LexerApiPackageAccessor;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.LexerSpiPackageAccessor;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.inc.SnapshotTokenList;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LexerUtilsConstants {
    public static final int MAX_FLY_SEQUENCE_LENGTH = 5;
    public static final int MIN_LEXED_AREA_LENGTH = 4096;
    public static final int LEXED_AREA_INPUT_SIZE_FRACTION = 10;

    public static void checkLexerInputFinished(CharProvider charProvider, LexerInputOperation lexerInputOperation) {
        if (charProvider.read() != -1) {
            throw new IllegalStateException("Lexer " + lexerInputOperation.lexer() + " returned null token" + " but EOF was not read from lexer input yet." + " Fix the lexer.");
        }
        if (charProvider.readIndex() > 0) {
            throw new IllegalStateException("Lexer " + lexerInputOperation.lexer() + " returned null token but lexerInput.readLength()=" + charProvider.readIndex() + " - these characters need to be tokenized." + " Fix the lexer.");
        }
    }

    public static void tokenLengthZeroOrNegative(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("Tokens with zero length are not supported by the framework. Fix the lexer.");
        }
        throw new IllegalArgumentException("Negative token length " + n);
    }

    public static void throwFlyTokenProhibited() {
        throw new IllegalStateException("Flyweight token created but prohibited. Lexer needs to check lexerInput.isFlyTokenAllowed().");
    }

    public static void throwBranchTokenFlyProhibited(AbstractToken abstractToken) {
        throw new IllegalStateException("Language embedding cannot be created for flyweight token=" + abstractToken + "\nFix the lexer to not create flyweight token instance when" + " language embedding exists for the token.");
    }

    public static void checkValidBackup(int n, int n2) {
        if (n > n2) {
            throw new IndexOutOfBoundsException("Cannot backup " + n + " characters. Maximum: " + n2 + '.');
        }
    }

    public static <T extends TokenId> LanguageHierarchy<T> languageHierarchy(Language<T> language) {
        return LexerApiPackageAccessor.get().languageHierarchy(language);
    }

    public static <T extends TokenId> LanguageOperation<T> languageOperation(Language<T> language) {
        return LexerSpiPackageAccessor.get().operation(LexerUtilsConstants.languageHierarchy(language));
    }

    public static <T extends TokenId> Language<T> mostEmbeddedLanguage(LanguagePath languagePath) {
        Language<? extends TokenId> language = languagePath.innerLanguage();
        return language;
    }

    public static <T extends TokenId> LanguageHierarchy<T> mostEmbeddedLanguageHierarchy(LanguagePath languagePath) {
        LanguageHierarchy<? extends TokenId> languageHierarchy = LexerUtilsConstants.languageHierarchy(languagePath.innerLanguage());
        return languageHierarchy;
    }

    public static <T extends TokenId> LanguageOperation<T> mostEmbeddedLanguageOperation(LanguagePath languagePath) {
        LanguageOperation<T> languageOperation = LexerSpiPackageAccessor.get().operation(LexerUtilsConstants.mostEmbeddedLanguageHierarchy(languagePath));
        return languageOperation;
    }

    public static <T extends TokenId> LanguageEmbedding<? extends TokenId> findEmbedding(Token<T> token, LanguagePath languagePath, InputAttributes inputAttributes) {
        LanguageHierarchy<T> languageHierarchy = LexerUtilsConstants.mostEmbeddedLanguageHierarchy(languagePath);
        LanguageEmbedding<TokenId> languageEmbedding = LexerSpiPackageAccessor.get().embedding(languageHierarchy, token, languagePath, inputAttributes);
        if (languageEmbedding == null) {
            languageEmbedding = LanguageManager.getInstance().findLanguageEmbedding(token, languagePath, inputAttributes);
        }
        return languageEmbedding;
    }

    public static <T extends TokenId> AbstractToken<T> token(Object object) {
        AbstractToken abstractToken = object.getClass() == EmbeddingContainer.class ? ((EmbeddingContainer)object).token() : (AbstractToken)object;
        return abstractToken;
    }

    public static <T extends TokenId> AbstractToken<T> token(TokenList<T> tokenList, int n) {
        return LexerUtilsConstants.token(tokenList.tokenOrEmbeddingContainer(n));
    }

    public static <T extends TokenId> StringBuilder appendTokenList(StringBuilder stringBuilder, TokenList<T> tokenList, int n) {
        TokenHierarchy<?> tokenHierarchy;
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        if (tokenList instanceof SnapshotTokenList) {
            tokenHierarchy = ((SnapshotTokenList)tokenList).snapshot().tokenHierarchy();
            stringBuilder.append(tokenList).append('\n');
        } else {
            tokenHierarchy = null;
        }
        int n2 = tokenList.tokenCountCurrent();
        int n3 = ArrayUtilities.digitCount((int)n2);
        for (int i = 0; i < n2; ++i) {
            Object object;
            stringBuilder.append(i == n ? (char)'*' : ' ');
            ArrayUtilities.appendBracketedIndex((StringBuilder)stringBuilder, (int)i, (int)n3);
            Object object2 = tokenList.tokenOrEmbeddingContainer(i);
            if (object2 == null) {
                System.err.println("tokenList=" + tokenList + ", i=" + i);
            }
            stringBuilder.append(object2.getClass() == EmbeddingContainer.class ? (char)'<' : ' ');
            stringBuilder.append(": ");
            AbstractToken<T> abstractToken = LexerUtilsConstants.token(object2);
            stringBuilder.append(abstractToken.dumpInfo(tokenHierarchy));
            int n4 = tokenList.lookahead(i);
            if (n4 != 0) {
                stringBuilder.append(", la=");
                stringBuilder.append(n4);
            }
            if ((object = tokenList.state(i)) != null) {
                stringBuilder.append(", s=");
                stringBuilder.append(object);
            }
            stringBuilder.append('\n');
        }
        return stringBuilder;
    }

    public static boolean statesEqual(Object object, Object object2) {
        return object == null && object2 == null || object != null && object.equals(object2);
    }

    public static String idToString(TokenId tokenId) {
        return tokenId.name() + '[' + tokenId.ordinal() + ']';
    }

    private LexerUtilsConstants() {
    }
}

