/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.inc;

import org.netbeans.api.lexer.TokenChange;
import org.netbeans.api.lexer.TokenHierarchyEventType;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.LexerApiPackageAccessor;
import org.netbeans.lib.lexer.LexerSpiPackageAccessor;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.inc.OriginalText;
import org.netbeans.lib.lexer.inc.TokenChangeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenHierarchyEventInfo {
    private final TokenHierarchyOperation<?, ?> tokenHierarchyOperation;
    private final TokenHierarchyEventType type;
    private TokenChange<? extends TokenId> tokenChange;
    private final int modificationOffset;
    private final int removedLength;
    private final CharSequence removedText;
    private final int insertedLength;
    private OriginalText originalText;
    private int affectedStartOffset;
    private int affectedEndOffset;

    public TokenHierarchyEventInfo(TokenHierarchyOperation<?, ? extends TokenId> tokenHierarchyOperation, TokenHierarchyEventType tokenHierarchyEventType, int n, int n2, CharSequence charSequence, int n3) {
        if (n < 0) {
            throw new IllegalArgumentException("modificationOffset=" + n + " < 0");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("removedLength=" + n2 + " < 0");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("insertedLength=" + n3 + " < 0");
        }
        this.tokenHierarchyOperation = tokenHierarchyOperation;
        this.type = tokenHierarchyEventType;
        this.modificationOffset = n;
        this.removedLength = n2;
        this.removedText = charSequence;
        this.insertedLength = n3;
    }

    public TokenHierarchyOperation<?, ? extends TokenId> tokenHierarchyOperation() {
        return this.tokenHierarchyOperation;
    }

    public TokenHierarchyEventType type() {
        return this.type;
    }

    public TokenChange<? extends TokenId> tokenChange() {
        return this.tokenChange;
    }

    public void setTokenChangeInfo(TokenChangeInfo<? extends TokenId> tokenChangeInfo) {
        this.tokenChange = LexerApiPackageAccessor.get().createTokenChange(tokenChangeInfo);
    }

    public int affectedStartOffset() {
        return this.affectedStartOffset;
    }

    public void setAffectedStartOffset(int n) {
        this.affectedStartOffset = n;
    }

    public void setMinAffectedStartOffset(int n) {
        if (n < this.affectedStartOffset) {
            this.affectedStartOffset = n;
        }
    }

    public int affectedEndOffset() {
        return this.affectedEndOffset;
    }

    public void setAffectedEndOffset(int n) {
        this.affectedEndOffset = Math.max(this.affectedEndOffset, n);
    }

    public void setMaxAffectedEndOffset(int n) {
        if (n > this.affectedEndOffset) {
            this.affectedEndOffset = n;
        }
    }

    public int modificationOffset() {
        return this.modificationOffset;
    }

    public int removedLength() {
        return this.removedLength;
    }

    public CharSequence removedText() {
        return this.removedText;
    }

    public int insertedLength() {
        return this.insertedLength;
    }

    public OriginalText originalText() {
        if (this.originalText == null) {
            if (this.removedLength != 0 && this.removedText == null) {
                throw new IllegalStateException("Cannot obtain removed text for " + this.tokenHierarchyOperation.mutableInputSource() + " which breaks token snapshots operation and" + " token text retaining after token's removal." + " Valid removedText in TokenHierarchyControl.textModified()" + " should be provided.");
            }
            this.originalText = new OriginalText(LexerSpiPackageAccessor.get().text(this.tokenHierarchyOperation.mutableTextInput()), this.modificationOffset, this.removedText, this.insertedLength);
        }
        return this.originalText;
    }
}

