/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.inc;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.LAState;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.inc.MutableTokenList;
import org.netbeans.lib.lexer.inc.RemovedTokenList;
import org.netbeans.lib.lexer.inc.TokenChangeInfo;
import org.netbeans.lib.lexer.token.AbstractToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenListChange<T extends TokenId> {
    private final TokenChangeInfo<T> tokenChangeInfo;
    private List<Object> addedTokensOrBranches;
    private LAState laState;
    private int offsetGapIndex;
    private int removedEndOffset;
    private int addedEndOffset;

    public TokenListChange(MutableTokenList<T> mutableTokenList) {
        this.tokenChangeInfo = new TokenChangeInfo<T>(mutableTokenList);
    }

    public TokenChangeInfo<T> tokenChangeInfo() {
        return this.tokenChangeInfo;
    }

    public MutableTokenList<T> tokenList() {
        return (MutableTokenList)this.tokenChangeInfo.currentTokenList();
    }

    public LanguagePath languagePath() {
        return this.tokenList().languagePath();
    }

    public int index() {
        return this.tokenChangeInfo.index();
    }

    public void setIndex(int n) {
        this.tokenChangeInfo.setIndex(n);
    }

    public int offset() {
        return this.tokenChangeInfo.offset();
    }

    public void setOffset(int n) {
        this.tokenChangeInfo.setOffset(n);
    }

    public int offsetGapIndex() {
        return this.offsetGapIndex;
    }

    public void setOffsetGapIndex(int n) {
        this.offsetGapIndex = n;
    }

    public void addToken(AbstractToken<T> abstractToken, int n, Object object) {
        if (this.addedTokensOrBranches == null) {
            this.addedTokensOrBranches = new ArrayList<Object>(2);
            this.laState = LAState.empty();
        }
        this.addedTokensOrBranches.add(abstractToken);
        this.laState = this.laState.add(n, object);
    }

    public List<Object> addedTokensOrBranches() {
        return this.addedTokensOrBranches;
    }

    public AbstractToken<T> addedToken(int n) {
        return LexerUtilsConstants.token(this.addedTokensOrBranches.get(0));
    }

    public void syncAddedTokenCount() {
        this.tokenChangeInfo.setAddedTokenCount(this.addedTokensOrBranches.size());
    }

    public void setRemovedTokens(Object[] objectArray) {
        this.tokenChangeInfo.setRemovedTokenList(new RemovedTokenList(this.languagePath(), objectArray));
    }

    public int removedEndOffset() {
        return this.removedEndOffset;
    }

    public void setRemovedEndOffset(int n) {
        this.removedEndOffset = n;
    }

    public int addedEndOffset() {
        return this.addedEndOffset;
    }

    public void setAddedEndOffset(int n) {
        this.addedEndOffset = n;
    }

    public boolean isBoundsChange() {
        return this.tokenChangeInfo.isBoundsChange();
    }

    public void markBoundsChange() {
        this.tokenChangeInfo.markBoundsChange();
    }

    public LAState laState() {
        return this.laState;
    }
}

