/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.Repository;

public final class FolderChildren {
    public static final String PROP_CHILDREN = "FolderChildren.PROP_CHILDREN";
    public static final String PROP_CHILD_CHANGED = "FolderChildren.PROP_CHILD_CHANGED";
    public static final String PROP_ATTRIBUTES = "FolderChildren.PROP_ATTRIBUTES";
    private static final Logger LOG = Logger.getLogger(FolderChildren.class.getName());
    private String[] pathElement;
    private boolean includeSubfolders;
    private final String LOCK = new String("FolderChildren.LOCK");
    private FileObject currentFolder = null;
    private boolean isTargetFolder = false;
    private FolderListener listener = new FolderListener(this);
    private List children = Collections.EMPTY_LIST;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public FolderChildren(String string) {
        this(string, true);
    }

    public FolderChildren(String string, boolean bl) {
        this.pathElement = string.split("/");
        this.includeSubfolders = bl;
        this.rebuild();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getChildren() {
        String string = this.LOCK;
        synchronized (string) {
            return this.children;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getFolderAttributes() {
        String string = this.LOCK;
        synchronized (string) {
            if (!this.isTargetFolder) {
                return Collections.EMPTY_MAP;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            Enumeration enumeration = this.currentFolder.getAttributes();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Object object = this.currentFolder.getAttribute(string2);
                if (hashMap.containsKey(string2)) continue;
                hashMap.put(string2, object);
            }
            return hashMap;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuild() {
        PropertyChangeEvent propertyChangeEvent = null;
        String string = this.LOCK;
        synchronized (string) {
            List<FileObject> list;
            Object[] objectArray = this.findTarget(this.pathElement);
            FileObject fileObject = (FileObject)objectArray[0];
            boolean bl = (Boolean)objectArray[1];
            if (fileObject != this.currentFolder) {
                if (this.currentFolder != null) {
                    this.currentFolder.removeFileChangeListener((FileChangeListener)this.listener);
                }
                this.currentFolder = fileObject;
                this.isTargetFolder = bl;
                LOG.finest("Setting currentFolder = '" + this.currentFolder.getPath() + "'");
                LOG.finest("Setting isTargetFolder = '" + this.isTargetFolder + "'");
                this.currentFolder.addFileChangeListener((FileChangeListener)this.listener);
            }
            if (this.isTargetFolder) {
                FileObject[] fileObjectArray = this.currentFolder.getChildren();
                list = new ArrayList(fileObjectArray.length);
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    if (!this.includeSubfolders && fileObjectArray[i].isFolder()) continue;
                    list.add(fileObjectArray[i]);
                }
                list = Collections.unmodifiableList(list);
            } else {
                list = Collections.EMPTY_LIST;
            }
            if (!((Object)this.children).equals(list)) {
                propertyChangeEvent = new PropertyChangeEvent(this, PROP_CHILDREN, this.children, list);
                this.children = list;
            }
        }
        if (propertyChangeEvent != null) {
            this.pcs.firePropertyChange(propertyChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileContentChanged(FileObject fileObject) {
        PropertyChangeEvent propertyChangeEvent = null;
        String string = this.LOCK;
        synchronized (string) {
            if (this.isTargetFolder) {
                propertyChangeEvent = new PropertyChangeEvent(this, PROP_CHILD_CHANGED, fileObject, fileObject);
            }
        }
        if (propertyChangeEvent != null) {
            this.pcs.firePropertyChange(propertyChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attributeChanged(FileObject fileObject, String string, Object object, Object object2) {
        PropertyChangeEvent propertyChangeEvent = null;
        String string2 = this.LOCK;
        synchronized (string2) {
            if (this.isTargetFolder && this.currentFolder == fileObject) {
                propertyChangeEvent = new PropertyChangeEvent(this, PROP_ATTRIBUTES, null, null);
            }
        }
        if (propertyChangeEvent != null) {
            this.pcs.firePropertyChange(propertyChangeEvent);
        }
    }

    private Object[] findTarget(String[] stringArray) {
        FileObject fileObject;
        FileObject fileObject2 = Repository.getDefault().getDefaultFileSystem().getRoot();
        boolean bl = 0 == stringArray.length;
        for (int i = 0; i < stringArray.length && (fileObject = fileObject2.getFileObject(stringArray[i])) != null && fileObject.isFolder() && fileObject.isValid() && !fileObject.isVirtual(); ++i) {
            fileObject2 = fileObject;
            bl = i + 1 == stringArray.length;
        }
        return new Object[]{fileObject2, bl};
    }

    private static class FolderListener
    extends FileChangeAdapter {
        private WeakReference ref = null;

        public FolderListener(FolderChildren folderChildren) {
            this.ref = new WeakReference<FolderChildren>(folderChildren);
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.handleRebuildEvent((FileEvent)fileRenameEvent);
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.handleRebuildEvent(fileEvent);
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.handleRebuildEvent(fileEvent);
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            FolderChildren folderChildren = (FolderChildren)this.ref.get();
            if (folderChildren != null) {
                folderChildren.attributeChanged(fileAttributeEvent.getFile(), fileAttributeEvent.getName(), fileAttributeEvent.getOldValue(), fileAttributeEvent.getNewValue());
            } else {
                ((FileObject)fileAttributeEvent.getSource()).removeFileChangeListener((FileChangeListener)this);
            }
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.handleRebuildEvent(fileEvent);
        }

        public void fileChanged(FileEvent fileEvent) {
            FolderChildren folderChildren = (FolderChildren)this.ref.get();
            if (folderChildren != null) {
                folderChildren.fileContentChanged(fileEvent.getFile());
            } else {
                ((FileObject)fileEvent.getSource()).removeFileChangeListener((FileChangeListener)this);
            }
        }

        private void handleRebuildEvent(FileEvent fileEvent) {
            FolderChildren folderChildren = (FolderChildren)this.ref.get();
            if (folderChildren != null) {
                folderChildren.rebuild();
            } else {
                ((FileObject)fileEvent.getSource()).removeFileChangeListener((FileChangeListener)this);
            }
        }
    }
}

