/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.advanced;

import java.awt.Color;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.options.ui.TabbedPanelModel;
import org.netbeans.spi.options.AdvancedOption;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderLookup;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.lookup.ProxyLookup;

public final class Model
extends TabbedPanelModel {
    private Map<String, AdvancedOption> categoryToOption = new HashMap<String, AdvancedOption>();
    private Map<String, JComponent> categoryToPanel = new HashMap<String, JComponent>();
    private Map<String, OptionsPanelController> categoryToController = new HashMap<String, OptionsPanelController>();
    private Lookup masterLookup;
    private boolean initialized = false;

    public List getCategories() {
        this.init();
        ArrayList<String> arrayList = new ArrayList<String>(this.categoryToOption.keySet());
        Collections.sort(arrayList, Collator.getInstance());
        return arrayList;
    }

    public String getToolTip(String string) {
        AdvancedOption advancedOption = this.categoryToOption.get(string);
        return advancedOption.getTooltip();
    }

    public JComponent getPanel(String string) {
        this.init();
        JComponent jComponent = this.categoryToPanel.get(string);
        if (jComponent != null) {
            return jComponent;
        }
        AdvancedOption advancedOption = this.categoryToOption.get(string);
        OptionsPanelController optionsPanelController = advancedOption.create();
        this.categoryToController.put(string, optionsPanelController);
        jComponent = optionsPanelController.getComponent(this.masterLookup);
        this.categoryToPanel.put(string, jComponent);
        Border border = jComponent.getBorder();
        border = border != null ? new CompoundBorder(new EmptyBorder(6, 16, 6, 6), border) : new EmptyBorder(6, 16, 6, 6);
        jComponent.setBorder(border);
        jComponent.setBackground(Color.white);
        jComponent.setMaximumSize(jComponent.getPreferredSize());
        return jComponent;
    }

    void update() {
        Iterator<OptionsPanelController> iterator = this.categoryToController.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().update();
        }
    }

    void applyChanges() {
        Iterator<OptionsPanelController> iterator = this.categoryToController.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().applyChanges();
        }
    }

    void cancel() {
        Iterator<OptionsPanelController> iterator = this.categoryToController.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().cancel();
        }
    }

    boolean isValid() {
        Iterator<OptionsPanelController> iterator = this.categoryToController.values().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().isValid()) continue;
            return false;
        }
        return true;
    }

    boolean isChanged() {
        Iterator<OptionsPanelController> iterator = this.categoryToController.values().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isChanged()) continue;
            return true;
        }
        return false;
    }

    Lookup getLookup() {
        ArrayList<Lookup> arrayList = new ArrayList<Lookup>();
        Iterator<OptionsPanelController> iterator = this.categoryToController.values().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().getLookup());
        }
        return new ProxyLookup(arrayList.toArray(new Lookup[arrayList.size()]));
    }

    HelpCtx getHelpCtx(JComponent jComponent) {
        for (String string : this.categoryToPanel.keySet()) {
            if (jComponent != this.categoryToPanel.get(string)) continue;
            OptionsPanelController optionsPanelController = this.categoryToController.get(string);
            return optionsPanelController.getHelpCtx();
        }
        return new HelpCtx("netbeans.optionsDialog.advanced");
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("OptionsDialog/Advanced");
        if (fileObject == null) {
            return;
        }
        Lookup lookup = new FolderLookup((DataObject.Container)DataFolder.findFolder((FileObject)fileObject)).getLookup();
        for (AdvancedOption advancedOption : lookup.lookup(new Lookup.Template(AdvancedOption.class)).allInstances()) {
            this.categoryToOption.put(advancedOption.getDisplayName(), advancedOption);
        }
    }

    void setLoookup(Lookup lookup) {
        this.masterLookup = lookup;
    }
}

