/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.javadoc.Doc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import com.sun.javadoc.Type;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.lexer.JavadocTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavadocUtilities {
    private static Set<TokenId> IGNORE_TOKES = null;

    private JavadocUtilities() {
    }

    private static TokenSequence<JavadocTokenId> findTokenSequence(CompilationInfo compilationInfo, Doc doc) {
        Element element = compilationInfo.getElementUtilities().elementFor(doc);
        if (element == null) {
            return null;
        }
        Tree tree = compilationInfo.getTrees().getTree(element);
        if (tree == null) {
            return null;
        }
        int n = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), tree);
        TokenSequence tokenSequence = compilationInfo.getTokenHierarchy().tokenSequence();
        tokenSequence.move(n);
        while (tokenSequence.movePrevious() && IGNORE_TOKES.contains(tokenSequence.token().id())) {
        }
        if (tokenSequence.token().id() != JavaTokenId.JAVADOC_COMMENT) {
            return null;
        }
        return tokenSequence.embedded(JavadocTokenId.language());
    }

    private static void moveToTag(TokenSequence<JavadocTokenId> tokenSequence, Tag tag) {
        Doc doc = tag.holder();
        Tag[] tagArray = doc.tags();
        int n = JavadocUtilities.findIndex(tagArray, tag);
        if (n == -1) {
            tagArray = doc.inlineTags();
            n = JavadocUtilities.findIndex(tagArray, tag);
            assert (n >= 0);
            n = JavadocUtilities.computeTagsWithSameNumberBefore(tagArray, tag);
        } else {
            n = JavadocUtilities.computeTagsWithSameNumberBefore(tagArray, tag);
        }
        assert (n >= 0);
        boolean bl = false;
        while (n >= 0 && (bl = tokenSequence.moveNext())) {
            if (tokenSequence.token().id() != JavadocTokenId.TAG || !tag.name().contentEquals(tokenSequence.token().text()) || --n >= 0) continue;
            return;
        }
        throw new IllegalStateException("cannot match the tag: " + tag.toString());
    }

    public static TokenSequence<JavadocTokenId> tokensFor(CompilationInfo compilationInfo, Tag tag) {
        Doc doc = tag.holder();
        TokenSequence<JavadocTokenId> tokenSequence = JavadocUtilities.findTokenSequence(compilationInfo, doc);
        assert (tokenSequence != null);
        JavadocUtilities.moveToTag(tokenSequence, tag);
        int n = tokenSequence.offset();
        int n2 = tag.text().length();
        n2 = n2 > 0 ? n2 : tag.name().length();
        TokenSequence tokenSequence2 = compilationInfo.getTokenHierarchy().tokenSequence();
        return tokenSequence2.embedded(JavadocTokenId.language()).subSequence(n, n + n2);
    }

    public static Position[] findTagNameBounds(CompilationInfo compilationInfo, Document document, Tag tag) throws BadLocationException {
        TokenSequence<JavadocTokenId> tokenSequence = JavadocUtilities.findTokenSequence(compilationInfo, tag.holder());
        if (tokenSequence == null) {
            return null;
        }
        JavadocUtilities.moveToTag(tokenSequence, tag);
        Position[] positionArray = new Position[]{document.createPosition(tokenSequence.offset()), document.createPosition(tokenSequence.offset() + tokenSequence.token().length())};
        return positionArray;
    }

    public static Position[] findDocBounds(CompilationInfo compilationInfo, Document document, Doc doc) throws BadLocationException {
        Element element = compilationInfo.getElementUtilities().elementFor(doc);
        if (element == null) {
            return null;
        }
        Tree tree = compilationInfo.getTrees().getTree(element);
        if (tree == null) {
            return null;
        }
        int n = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), tree);
        TokenSequence tokenSequence = compilationInfo.getTokenHierarchy().tokenSequence();
        tokenSequence.move(n);
        while (tokenSequence.movePrevious() && IGNORE_TOKES.contains(tokenSequence.token().id())) {
        }
        if (tokenSequence.token().id() != JavaTokenId.JAVADOC_COMMENT) {
            return null;
        }
        Position[] positionArray = new Position[]{document.createPosition(tokenSequence.offset()), document.createPosition(tokenSequence.offset() + tokenSequence.token().length())};
        return positionArray;
    }

    public static Position[] findTagBounds(CompilationInfo compilationInfo, Document document, Tag tag) throws BadLocationException {
        return JavadocUtilities.findTagBounds(compilationInfo, document, tag, null);
    }

    public static Position[] findTagBounds(CompilationInfo compilationInfo, Document document, Tag tag, boolean[] blArray) throws BadLocationException {
        TokenSequence<JavadocTokenId> tokenSequence = JavadocUtilities.findTokenSequence(compilationInfo, tag.holder());
        if (tokenSequence == null) {
            return null;
        }
        JavadocUtilities.moveToTag(tokenSequence, tag);
        int n = tokenSequence.offset();
        Token token = null;
        Token token2 = null;
        while (tokenSequence.moveNext()) {
            if (tokenSequence.token().id() == JavadocTokenId.TAG && token2 != null && (token2.id() != JavadocTokenId.OTHER_TEXT || token2.text().charAt(token2.text().length() - 1) != '{')) {
                token = tokenSequence.token();
                break;
            }
            token2 = tokenSequence.token();
        }
        int n2 = 0;
        if (token == null) {
            tokenSequence.moveEnd();
            tokenSequence.movePrevious();
            n2 = ((Object)tokenSequence.token().text()).toString().indexOf(10);
            int n3 = n2 = n2 > 0 ? n2 : 0;
            if (blArray != null && blArray.length > 0) {
                blArray[0] = true;
            } else if (blArray != null && blArray.length > 0) {
                blArray[0] = false;
            }
        }
        Position[] positionArray = new Position[]{document.createPosition(n), document.createPosition(tokenSequence.offset() + n2)};
        return positionArray;
    }

    public static Position[] findLastTokenBounds(CompilationInfo compilationInfo, Document document, Doc doc) throws BadLocationException {
        TokenSequence<JavadocTokenId> tokenSequence = JavadocUtilities.findTokenSequence(compilationInfo, doc);
        if (tokenSequence == null) {
            return null;
        }
        tokenSequence.moveEnd();
        if (tokenSequence.movePrevious()) {
            Position[] positionArray = new Position[]{document.createPosition(tokenSequence.offset()), document.createPosition(tokenSequence.offset() + tokenSequence.token().length())};
            return positionArray;
        }
        return null;
    }

    public static TokenSequence<JavaTokenId> findMethodNameToken(CompilationInfo compilationInfo, ClassTree classTree, MethodTree methodTree) {
        TokenSequence tokenSequence = compilationInfo.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        Tree tree = methodTree.getReturnType();
        if (tree == null) {
            int n = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), methodTree);
            tokenSequence.move(n + 1);
            Token token = null;
            String string = classTree.getSimpleName().toString();
            int n2 = -1;
            while (tokenSequence.moveNext()) {
                if (token != null && tokenSequence.token().id() == JavaTokenId.LPAREN && string.contentEquals(token.text())) {
                    tokenSequence.moveIndex(n2);
                    tokenSequence.moveNext();
                    break;
                }
                if (tokenSequence.token().id() != JavaTokenId.IDENTIFIER) continue;
                token = tokenSequence.token();
                n2 = tokenSequence.index();
            }
        } else {
            int n = (int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), tree);
            tokenSequence.move(n + 1);
            while (tokenSequence.moveNext() && tokenSequence.token().id() != JavaTokenId.IDENTIFIER) {
            }
        }
        return tokenSequence;
    }

    public static TokenSequence<JavaTokenId> findClassNameToken(CompilationInfo compilationInfo, ClassTree classTree) {
        TokenSequence tokenSequence = compilationInfo.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        ModifiersTree modifiersTree = classTree.getModifiers();
        assert (modifiersTree != null);
        int n = (int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), modifiersTree);
        tokenSequence.move(n + 1);
        while (tokenSequence.moveNext() && tokenSequence.token().id() != JavaTokenId.IDENTIFIER) {
        }
        return tokenSequence;
    }

    public static TokenSequence<JavaTokenId> findVariableNameToken(CompilationInfo compilationInfo, VariableTree variableTree, boolean bl) {
        Tree tree;
        TokenSequence tokenSequence = compilationInfo.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        Tree tree2 = tree = bl ? variableTree : variableTree.getType();
        if (tree == null) {
            tree = variableTree.getModifiers();
        }
        assert (tree != null);
        int n = bl ? (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), tree) : (int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), tree);
        tokenSequence.move(n);
        String string = variableTree.getName().toString();
        while (tokenSequence.moveNext() && (tokenSequence.token().id() != JavaTokenId.IDENTIFIER || !string.contentEquals(tokenSequence.token().text()))) {
        }
        return tokenSequence;
    }

    private static int computeTagsWithSameNumberBefore(Tag[] tagArray, Tag tag) {
        int n = 0;
        for (Tag tag2 : tagArray) {
            if (tag2 == tag) {
                return n;
            }
            if (!tag2.name().equals(tag.name())) continue;
            ++n;
        }
        return -1;
    }

    private static int findIndex(Tag[] tagArray, Tag tag) {
        for (int i = 0; i < tagArray.length; ++i) {
            if (tag != tagArray[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean isDeprecated(CompilationInfo compilationInfo, Element element) {
        return JavadocUtilities.findDeprecated(compilationInfo, element) != null;
    }

    public static AnnotationMirror findDeprecated(CompilationInfo compilationInfo, Element element) {
        TypeElement typeElement = compilationInfo.getElements().getTypeElement("java.lang.Deprecated");
        assert (typeElement != null);
        for (AnnotationMirror annotationMirror : compilationInfo.getElements().getAllAnnotationMirrors(element)) {
            if (!typeElement.equals(annotationMirror.getAnnotationType().asElement())) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean hasInheritedDoc(CompilationInfo compilationInfo, Element element) {
        return JavadocUtilities.findInheritedDoc(compilationInfo, element) != null;
    }

    public static MethodDoc findInheritedDoc(CompilationInfo compilationInfo, Element element) {
        if (element.getKind() == ElementKind.METHOD) {
            TypeElement typeElement = (TypeElement)element.getEnclosingElement();
            return JavadocUtilities.searchInInterfaces(compilationInfo, typeElement, typeElement, (ExecutableElement)element, new HashSet<TypeElement>());
        }
        return null;
    }

    private static MethodDoc searchInInterfaces(CompilationInfo compilationInfo, TypeElement typeElement, TypeElement typeElement2, ExecutableElement executableElement, Set<TypeElement> set) {
        MethodDoc methodDoc;
        TypeElement typeElement3;
        for (TypeMirror typeMirror : typeElement.getInterfaces()) {
            if (typeMirror.getKind() != TypeKind.DECLARED || set.contains(typeElement3 = (TypeElement)((DeclaredType)typeMirror).asElement())) continue;
            methodDoc = JavadocUtilities.searchInMethods(compilationInfo, typeElement3, typeElement2, executableElement);
            if (methodDoc != null) {
                return methodDoc;
            }
            set.add(typeElement3);
        }
        for (TypeMirror typeMirror : typeElement.getInterfaces()) {
            if (typeMirror.getKind() != TypeKind.DECLARED || (methodDoc = JavadocUtilities.searchInInterfaces(compilationInfo, typeElement3 = (TypeElement)((DeclaredType)typeMirror).asElement(), typeElement2, executableElement, set)) == null) continue;
            return methodDoc;
        }
        return JavadocUtilities.searchInSuperclass(compilationInfo, typeElement, typeElement2, executableElement, set);
    }

    private static MethodDoc searchInSuperclass(CompilationInfo compilationInfo, TypeElement typeElement, TypeElement typeElement2, ExecutableElement executableElement, Set<TypeElement> set) {
        TypeMirror typeMirror = typeElement.getSuperclass();
        if (typeMirror.getKind() != TypeKind.DECLARED) {
            return null;
        }
        TypeElement typeElement3 = (TypeElement)((DeclaredType)typeMirror).asElement();
        MethodDoc methodDoc = JavadocUtilities.searchInMethods(compilationInfo, typeElement3, typeElement2, executableElement);
        if (methodDoc != null) {
            return methodDoc;
        }
        return JavadocUtilities.searchInInterfaces(compilationInfo, typeElement3, typeElement2, executableElement, set);
    }

    private static MethodDoc searchInMethods(CompilationInfo compilationInfo, TypeElement typeElement, TypeElement typeElement2, ExecutableElement executableElement) {
        for (Element element : typeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD || !compilationInfo.getElements().overrides(executableElement, (ExecutableElement)element, typeElement2)) continue;
            Doc doc = compilationInfo.getElementUtilities().javaDocFor(element);
            return doc != null && doc.getRawCommentText().length() > 0 ? (MethodDoc)doc : null;
        }
        return null;
    }

    public static ParamTag findParamTag(CompilationInfo compilationInfo, MethodDoc methodDoc, String string, boolean bl) {
        ExecutableElement executableElement = (ExecutableElement)compilationInfo.getElementUtilities().elementFor((Doc)methodDoc);
        TypeElement typeElement = (TypeElement)executableElement.getEnclosingElement();
        TypeElement typeElement2 = null;
        HashSet<TypeElement> hashSet = null;
        while (methodDoc != null) {
            for (ParamTag paramTag : methodDoc.paramTags()) {
                if (!string.equals(paramTag.parameterName())) continue;
                return paramTag;
            }
            if (!bl) break;
            if (hashSet == null) {
                hashSet = new HashSet<TypeElement>();
            }
            if (typeElement2 == null) {
                typeElement2 = typeElement;
            } else {
                Element element = compilationInfo.getElementUtilities().elementFor((Doc)methodDoc);
                typeElement2 = (TypeElement)element.getEnclosingElement();
            }
            methodDoc = JavadocUtilities.searchInInterfaces(compilationInfo, typeElement2, typeElement, executableElement, hashSet);
        }
        return null;
    }

    public static ThrowsTag findThrowsTag(CompilationInfo compilationInfo, MethodDoc methodDoc, String string, boolean bl) {
        ExecutableElement executableElement = (ExecutableElement)compilationInfo.getElementUtilities().elementFor((Doc)methodDoc);
        TypeElement typeElement = (TypeElement)executableElement.getEnclosingElement();
        TypeElement typeElement2 = null;
        HashSet<TypeElement> hashSet = null;
        while (methodDoc != null) {
            for (ThrowsTag throwsTag : methodDoc.throwsTags()) {
                Type type = throwsTag.exceptionType();
                String string2 = null;
                string2 = type != null ? throwsTag.exceptionType().qualifiedTypeName() : throwsTag.exceptionName();
                if (!string2.equals(string)) continue;
                return throwsTag;
            }
            if (!bl) break;
            if (hashSet == null) {
                hashSet = new HashSet<TypeElement>();
            }
            if (typeElement2 == null) {
                typeElement2 = typeElement;
            } else {
                Element element = compilationInfo.getElementUtilities().elementFor((Doc)methodDoc);
                typeElement2 = (TypeElement)element.getEnclosingElement();
            }
            methodDoc = JavadocUtilities.searchInInterfaces(compilationInfo, typeElement2, typeElement, executableElement, hashSet);
        }
        return null;
    }

    public static Tag findReturnTag(CompilationInfo compilationInfo, MethodDoc methodDoc, boolean bl) {
        ExecutableElement executableElement = (ExecutableElement)compilationInfo.getElementUtilities().elementFor((Doc)methodDoc);
        TypeElement typeElement = (TypeElement)executableElement.getEnclosingElement();
        TypeElement typeElement2 = null;
        HashSet<TypeElement> hashSet = null;
        while (methodDoc != null) {
            Tag[] tagArray = methodDoc.tags("@return");
            if (tagArray.length > 0) {
                return tagArray[0];
            }
            if (!bl) break;
            if (hashSet == null) {
                hashSet = new HashSet<TypeElement>();
            }
            if (typeElement2 == null) {
                typeElement2 = typeElement;
            } else {
                Element element = compilationInfo.getElementUtilities().elementFor((Doc)methodDoc);
                typeElement2 = (TypeElement)element.getEnclosingElement();
            }
            methodDoc = JavadocUtilities.searchInInterfaces(compilationInfo, typeElement2, typeElement, executableElement, hashSet);
        }
        return null;
    }

    static {
        IGNORE_TOKES = new HashSet<TokenId>();
        IGNORE_TOKES.add((TokenId)JavaTokenId.WHITESPACE);
        IGNORE_TOKES.add((TokenId)JavaTokenId.BLOCK_COMMENT);
    }

    public static final class TagHandle {
        private final String name;
        private final String text;
        private final int index;

        private TagHandle(Tag tag) {
            this.name = tag.name();
            this.text = tag.text();
            this.index = JavadocUtilities.findIndex(tag.holder().tags(), tag);
        }

        public static TagHandle create(Tag tag) {
            return new TagHandle(tag);
        }

        public Tag resolve(Doc doc) {
            Tag[] tagArray = doc.tags();
            if (this.index < tagArray.length && this.name.equals(tagArray[this.index].name()) && this.text.equals(tagArray[this.index].text())) {
                return tagArray[this.index];
            }
            for (Tag tag : tagArray) {
                if (!this.name.equals(tagArray[this.index].name()) || !this.text.equals(tagArray[this.index].text())) continue;
                return tag;
            }
            return null;
        }

        public String toString() {
            return super.toString() + "[index: " + this.index + "name: " + this.name + "text: " + this.text + ']';
        }
    }
}

