/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.javadoc.search.JavadocRegistry;
import org.netbeans.modules.javadoc.search.JavadocSearchType;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class IndexBuilder
implements Runnable,
ChangeListener {
    private static final String[] INDEX_FILE_NAMES = new String[]{"overview-summary.html", "index.html", "index.htm"};
    private static IndexBuilder INSTANCE;
    private static RequestProcessor.Task task;
    private static final ErrorManager err;
    private Reference cachedData;
    private JavadocRegistry jdocRegs;
    Map filesystemInfo = Collections.EMPTY_MAP;

    private IndexBuilder() {
        this.jdocRegs = JavadocRegistry.getDefault();
        this.jdocRegs.addChangeListener(this);
        if (err.isLoggable(1)) {
            err.log("new IndexBuilder");
        }
    }

    public static synchronized IndexBuilder getDefault() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        INSTANCE = new IndexBuilder();
        IndexBuilder.scheduleTask();
        return INSTANCE;
    }

    public void run() {
        this.cachedData = null;
        this.refreshIndex();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        IndexBuilder.scheduleTask();
    }

    public List[] getIndices() {
        Object object;
        Object object2;
        task.waitFinished();
        if (this.cachedData != null && (object2 = (List[])this.cachedData.get()) != null) {
            if (err.isLoggable(1)) {
                err.log("getIndices (cached)");
            }
            return object2;
        }
        if (err.isLoggable(1)) {
            err.log("getIndices");
        }
        object2 = this.filesystemInfo;
        Iterator iterator = object2.entrySet().iterator();
        final Collator collator = Collator.getInstance();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Pair
        implements Comparable {
            public String display;
            public FileObject fo;

            Pair() {
            }

            public int compareTo(Object object) {
                return collator.compare(this.display, ((Pair)object).display);
            }
        }
        TreeSet<Pair> treeSet = new TreeSet<Pair>();
        for (int i = 0; i < object2.size(); ++i) {
            object = iterator.next();
            FileObject listArray2 = (FileObject)object.getKey();
            Info info = (Info)object.getValue();
            FileObject fileObject = listArray2.getFileObject(info.indexFileName);
            if (fileObject == null) continue;
            Pair pair = new Pair();
            pair.display = info.title;
            pair.fo = fileObject;
            treeSet.add(pair);
        }
        ArrayList<String> arrayList = new ArrayList<String>(treeSet.size());
        object = new ArrayList(treeSet.size());
        for (Pair pair : treeSet) {
            arrayList.add(pair.display);
            object.add(pair.fo);
        }
        List[] listArray = new List[]{arrayList, object};
        this.cachedData = new WeakReference<List[]>(listArray);
        return listArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void refreshIndex() {
        if (err.isLoggable(1)) {
            err.log("refreshIndex");
        }
        FileObject[] fileObjectArray = this;
        // MONITORENTER : this
        Map map = this.filesystemInfo;
        // MONITOREXIT : fileObjectArray
        fileObjectArray = this.jdocRegs.getDocRoots();
        WeakHashMap<FileObject, Object> weakHashMap = new WeakHashMap<FileObject, Object>();
        int n = 0;
        while (n < fileObjectArray.length) {
            block22: {
                Object object;
                block23: {
                    Object object2;
                    FileObject fileObject;
                    FileObject fileObject2;
                    block24: {
                        FileObject fileObject3;
                        block21: {
                            fileObject2 = fileObjectArray[n];
                            Info info = (Info)map.get(fileObject2);
                            if (info == null) break block21;
                            weakHashMap.put(fileObject2, info);
                            break block22;
                        }
                        fileObject = null;
                        for (int i = 0; i < INDEX_FILE_NAMES.length && (fileObject = fileObject2.getFileObject(INDEX_FILE_NAMES[i])) == null; ++i) {
                        }
                        if ((fileObject == null || fileObject.getName().equals("index")) && (fileObject3 = fileObject2.getFileObject("package-list")) != null) {
                            try {
                                object2 = fileObject3.getInputStream();
                                try {
                                    String string;
                                    FileObject fileObject4;
                                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object2));
                                    String string2 = bufferedReader.readLine();
                                    if (string2 != null && bufferedReader.readLine() == null && (fileObject4 = fileObject2.getFileObject(string = string2.replace('.', '/') + "/package-summary.html")) != null) {
                                        fileObject = fileObject4;
                                    }
                                }
                                finally {
                                    object2.close();
                                }
                            }
                            catch (IOException iOException) {
                                ErrorManager.getDefault().notify(1, (Throwable)iOException);
                            }
                        }
                        if (fileObject == null) break block23;
                        object = super.parseTitle(fileObject);
                        if (object == null) break block24;
                        object2 = this.jdocRegs.findSearchType(fileObject2);
                        if (object2 == null) break block22;
                        object = ((JavadocSearchType)((Object)object2)).getOverviewTitleBase((String)object);
                    }
                    if ("".equals(object)) {
                        object = NbBundle.getMessage(IndexBuilder.class, (String)"FMT_NoOverviewTitle", (Object[])new Object[]{fileObject.getPath(), fileObject2.getName(), fileObject2.getName()});
                    }
                    object2 = new Info();
                    ((Info)object2).title = object == null ? fileObject2.getName() : object;
                    ((Info)object2).indexFileName = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
                    weakHashMap.put(fileObject2, object2);
                }
                object = this;
                // MONITORENTER : this
                this.filesystemInfo = weakHashMap;
                // MONITOREXIT : object
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseTitle(FileObject fileObject) {
        String string = null;
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileObject.getInputStream(), 1024);
            SimpleTitleParser simpleTitleParser = new SimpleTitleParser(bufferedInputStream);
            try {
                simpleTitleParser.parse();
                string = simpleTitleParser.getTitle();
            }
            finally {
                ((InputStream)bufferedInputStream).close();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        if (string == null) {
            string = FileUtil.getFileDisplayName((FileObject)fileObject);
        }
        return string;
    }

    private static synchronized void scheduleTask() {
        if (task == null) {
            task = new RequestProcessor("Javadoc Index Builder").create((Runnable)IndexBuilder.getDefault());
        }
        task.schedule(100);
    }

    static {
        err = ErrorManager.getDefault().getInstance("org.netbeans.modules.javadoc.search.IndexBuilder");
    }

    private static class Info {
        String title;
        String indexFileName;

        private Info() {
        }
    }

    static final class SimpleTitleParser {
        private char cc;
        private InputStream is;
        private String charset;
        private String title;
        private int state = 0;
        private static final int CONTINUE = 0;
        private static final int EXIT = 0;

        SimpleTitleParser(InputStream inputStream) {
            this.is = inputStream;
        }

        public String getTitle() {
            return this.title;
        }

        public void parse() throws IOException {
            this.readNext();
            block4: while (this.state == 0) {
                switch (this.cc) {
                    case '<': {
                        this.handleOpenBrace();
                        continue block4;
                    }
                    case '\uffff': {
                        return;
                    }
                }
                this.readNext();
            }
        }

        private void readNext() throws IOException {
            this.cc = (char)this.is.read();
        }

        private void handleOpenBrace() throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            block5: while (true) {
                this.readNext();
                switch (this.cc) {
                    case '>': {
                        String string = stringBuilder.toString().toLowerCase();
                        if (string.startsWith("body")) {
                            this.state = 0;
                            return;
                        }
                        if (string.startsWith("meta")) {
                            this.handleMetaTag(string);
                            return;
                        }
                        if (string.startsWith("title")) {
                            this.handleTitleTag();
                            return;
                        }
                        return;
                    }
                    case '\uffff': {
                        return;
                    }
                    case ' ': {
                        if (stringBuilder.length() == 0) continue block5;
                    }
                    default: {
                        stringBuilder.append(this.cc);
                    }
                }
            }
        }

        private void handleMetaTag(String string) {
            int n;
            String string2 = "";
            String string3 = "";
            char[] cArray = string.toCharArray();
            int n2 = n = 5;
            int n3 = 0;
            while (n < cArray.length) {
                char c = string.charAt(n);
                if (c == '=' && n3 == 0) {
                    string2 = String.valueOf(cArray, n2, n++ - n2).trim();
                    n3 = 1;
                    continue;
                }
                if (n3 == 1 && (c == '\"' || c == '\'')) {
                    n2 = ++n;
                    n3 = 2;
                    continue;
                }
                if (n3 == 2 && (c == '\"' || c == '\'')) {
                    string3 = String.valueOf(cArray, n2, n++ - n2);
                    if ("content".equals(string2)) break;
                    string2 = "";
                    n3 = 0;
                    n2 = n;
                    continue;
                }
                ++n;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken().trim();
                if (!string4.startsWith("charset") || (string4 = string4.substring(7).trim()).charAt(0) != '=') continue;
                this.charset = string4.substring(1).trim();
                return;
            }
        }

        private void handleTitleTag() throws IOException {
            byte[] byArray = new byte[200];
            int n = 0;
            while (true) {
                this.readNext();
                switch (this.cc) {
                    case '\uffff': {
                        return;
                    }
                    case '>': {
                        if (!"</title".equals(new String(byArray, n - 7, 7).toLowerCase())) break;
                        this.state = 0;
                        this.title = this.charset == null ? new String(byArray, 0, n - 7).trim() : new String(byArray, 0, n - 7, this.charset).trim();
                        return;
                    }
                }
                this.cc = (char)(this.cc == '\n' || this.cc == '\r' ? 32 : (int)this.cc);
                if (n == byArray.length) {
                    byArray = SimpleTitleParser.enlarge(byArray);
                }
                byArray[n++] = (byte)this.cc;
            }
        }

        private static byte[] enlarge(byte[] byArray) {
            byte[] byArray2 = new byte[byArray.length + 200];
            for (int i = 0; i < byArray.length; ++i) {
                byArray2[i] = byArray[i];
            }
            return byArray2;
        }
    }
}

