/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.awt.Component;
import javax.swing.JEditorPane;
import org.netbeans.modules.javadoc.search.GetJavaWord;
import org.netbeans.modules.javadoc.search.IndexSearch;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;
import org.openide.windows.TopComponent;

public final class ShowDocAction
extends CookieAction {
    static final long serialVersionUID = 3578357584245478L;

    public ShowDocAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getBundle(ShowDocAction.class).getString("CTL_SHOWDOC_MenuItem");
    }

    protected final Class[] cookieClasses() {
        return new Class[]{EditorCookie.class};
    }

    protected int mode() {
        return 8;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ShowDocAction.class);
    }

    public void performAction(Node[] nodeArray) {
        String string;
        IndexSearch indexSearch = IndexSearch.getDefault();
        if (nodeArray.length == 1 && nodeArray[0] != null && (string = this.findTextFromNode(nodeArray[0])) != null) {
            indexSearch.setTextToFind(string);
        }
        indexSearch.open();
        indexSearch.requestActive();
    }

    private String findTextFromNode(Node node) {
        JEditorPane[] jEditorPaneArray;
        EditorCookie editorCookie = (EditorCookie)node.getCookie(EditorCookie.class);
        if (editorCookie != null && (jEditorPaneArray = editorCookie.getOpenedPanes()) != null) {
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            for (int i = 0; i < jEditorPaneArray.length; ++i) {
                if (!topComponent.isAncestorOf((Component)jEditorPaneArray[i])) continue;
                String string = GetJavaWord.forPane(jEditorPaneArray[i]);
                if (string == null) break;
                return string;
            }
        }
        return node.getName();
    }

    protected boolean asynchronous() {
        return false;
    }
}

