/*
 * Decompiled with CFR 0.152.
 */
package org.gjava.actoreditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjava.actoreditor.ActionValue;
import org.gjava.actoreditor.ImageData;
import org.gjava.actoreditor.Utilz;
import org.gjava.actoreditor.Value;
import org.gjava.actoreditor.actorDataObject;
import org.gjava.actoreditor.beans.ActionList;
import org.gjava.actoreditor.beans.EventList;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteController;
import org.netbeans.spi.palette.PaletteFactory;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileLock;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ActorEditorTopComponent
extends TopComponent
implements PropertyChangeListener {
    private static ActorEditorTopComponent instance;
    static final String ICON_PATH = "org/gjava/actoreditor/object.png";
    public actorDataObject ado;
    public String oldDisplayName;
    private static final String PREFERRED_ID = "ActorEditorTopComponent";
    public String path = "";
    public String image = "";
    private ExplorerManager explorerManager;
    private int draggingIndex = -1;
    public actorDataObject a;
    public ActionList actionList1;
    public EventList eventList;
    private JButton jButton1;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JSplitPane jSplitPane1;
    public final JLabel jLabel4 = new JLabel("Drop image here!");

    ActorEditorTopComponent(actorDataObject a) {
        this(new InstanceContent());
        this.a = a;
        this.oldDisplayName = this.getHtmlDisplayName();
        this.a.ae = this;
        this.path = a.getPrimaryFile().getPath();
        this.ado = a;
    }

    public ActorEditorTopComponent(InstanceContent content) {
        super((Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.explorerManager = new ExplorerManager();
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        content.add((Object)this.explorerManager);
        PaletteController controller = this.initializePalette();
        content.add((Object)controller);
        controller.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent arg0) {
            }
        });
        this.initComponents();
        this.actionList1.setDragEnabled(true);
        this.setName(NbBundle.getMessage((Class)ActorEditorTopComponent.class, (String)"CTL_ActorEditorTopComponent"));
        this.setToolTipText(NbBundle.getMessage((Class)ActorEditorTopComponent.class, (String)"HINT_ActorEditorTopComponent"));
        this.setIcon(Utilities.loadImage((String)ICON_PATH, (boolean)true));
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.actionList1 = new ActionList(this);
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.eventList = new EventList(this);
        this.jButton1 = new JButton();
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBox2 = new JCheckBox();
        this.jScrollPane3 = new JScrollPane();
        this.jSplitPane1.setDividerSize(8);
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setForeground(new Color(0, 51, 255));
        this.jLabel3.setText("Actions: ");
        this.jScrollPane2.setViewportView(this.actionList1);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel3).addContainerGap(262, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jScrollPane2, -1, 300, Short.MAX_VALUE).add(20, 20, 20)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 454, Short.MAX_VALUE)));
        this.jSplitPane1.setRightComponent(this.jPanel1);
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setForeground(new Color(0, 51, 255));
        this.jLabel2.setText("Events: ");
        this.jScrollPane1.setViewportView(this.eventList);
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel2).addContainerGap(284, Short.MAX_VALUE)).add((Component)this.jScrollPane1, -1, 238, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 454, Short.MAX_VALUE)));
        this.jSplitPane1.setLeftComponent(this.jPanel2);
        this.jButton1.setText("Save");
        this.jButton1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ActorEditorTopComponent.this.jButton1MouseClicked(evt);
            }
        });
        this.jCheckBox1.setText("Solid");
        this.jCheckBox1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox1.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox2.setText("Visible");
        this.jCheckBox2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox2.setMargin(new Insets(0, 0, 0, 0));
        this.eventList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ActorEditorTopComponent.this.eventListValueChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane3, -2, 108, -2).add((Component)this.jCheckBox1).add((Component)this.jCheckBox2).add((Component)this.jButton1)).add(14, 14, 14).add((Component)this.jSplitPane1, -1, 568, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane3, -2, 125, -2).add(16, 16, 16).add((Component)this.jCheckBox1).add(14, 14, 14).add((Component)this.jCheckBox2).add(15, 15, 15).addContainerGap().add((Component)this.jButton1).add(264, 264, 264)).add((Component)this.jSplitPane1, -1, 487, Short.MAX_VALUE));
        this.jScrollPane3.setViewportView(this.jLabel4);
        this.jSplitPane1.setDividerLocation(0.5);
        this.setDropTarget(new DropTarget((Component)((Object)this), new DropTargetListener(){

            public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            }

            public void dragExit(DropTargetEvent dropTargetEvent) {
            }

            public void dragOver(DropTargetDragEvent dtde) {
                if (dtde.isDataFlavorSupported(Utilz.IMAGE_DATA_FLAVOR)) {
                    dtde.acceptDrag(3);
                } else {
                    dtde.rejectDrag();
                }
            }

            public void drop(DropTargetDropEvent dtde) {
                if (!dtde.isDataFlavorSupported(Utilz.IMAGE_DATA_FLAVOR)) {
                    dtde.rejectDrop();
                }
                dtde.acceptDrop(3);
                ImageData data = null;
                try {
                    data = (ImageData)dtde.getTransferable().getTransferData(Utilz.IMAGE_DATA_FLAVOR);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (UnsupportedFlavorException ex) {
                    ex.printStackTrace();
                }
                dtde.dropComplete(null != data);
                if (null != data) {
                    // empty if block
                }
                ActorEditorTopComponent.this.ado.data.img = data.path;
                ImageIcon image = new ImageIcon(data.path);
                ActorEditorTopComponent.this.setimage(data.path);
                ActorEditorTopComponent.this.jLabel4.setIcon(image);
            }

            public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            }
        }));
    }

    private void jButton1MouseClicked(MouseEvent evt) {
        try {
            this.savefile();
            this.a.setModified(false);
            this.a.writejava();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public final void setimage(String image) {
        this.image = image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savefile() {
        FileLock lock;
        try {
            lock = this.ado.getPrimaryFile().lock();
        }
        catch (Exception e) {
            return;
        }
        PrintWriter to = null;
        try {
            to = new PrintWriter(this.ado.getPrimaryFile().getOutputStream(lock));
            try {
                to.println("<?xml version=\"1.0\"?>");
                if (this.jLabel4.getIcon() == null) {
                    to.println("<Image>null</Image>");
                } else {
                    to.println("<Image>" + this.image + "</Image>");
                }
                if (this.jCheckBox1.isSelected()) {
                    to.println("<Solid>True</Solid>");
                } else {
                    to.println("<Solid>False</Solid>");
                }
                if (this.jCheckBox2.isSelected()) {
                    to.println("<Visible>True</Visible>");
                } else {
                    to.println("<Visible>False</Visible>");
                }
                Enumeration e = this.eventList.events.elements();
                while (e.hasMoreElements()) {
                    Value v = (Value)e.nextElement();
                    to.println("<Event>");
                    to.println("<Name>" + v.value + "</Name>");
                    to.println("<Image>" + v.img + "</Image>");
                    Enumeration ee = v.actions.elements();
                    while (ee.hasMoreElements()) {
                        ActionValue vv = (ActionValue)ee.nextElement();
                        to.println("<Action>");
                        to.println("<Name>" + vv.value + "</Name>");
                        to.println("<Image>" + vv.img + "</Image>");
                        to.println("<Code>" + vv.code + "</Code>");
                        to.println("</Action>");
                    }
                    to.println("</Event>");
                }
            }
            finally {
                to.close();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            lock.releaseLock();
            to.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openfile() throws Exception {
        this.eventList.events.clear();
        BufferedReader from = new BufferedReader(new InputStreamReader(this.ado.getPrimaryFile().getInputStream()));
        try {
            String line;
            while ((line = from.readLine()) != null) {
                if (line.contains("<Image>") && line.contains("</Image>")) {
                    this.image = line.replaceAll("<Image>", "").replaceAll("</Image>", "");
                    if (!this.image.equals("null")) {
                        this.jLabel4.setIcon(new ImageIcon(this.image));
                    }
                }
                if (line.contains("<Solid>") && line.contains("</Solid>")) {
                    if (line.contains("True")) {
                        this.jCheckBox1.setSelected(true);
                    } else {
                        this.jCheckBox1.setSelected(false);
                    }
                }
                if (line.contains("<Visible>") && line.contains("</Visible>")) {
                    if (line.contains("True")) {
                        this.jCheckBox2.setSelected(true);
                    } else {
                        this.jCheckBox2.setSelected(false);
                    }
                }
                if (!line.equals("<Event>")) continue;
                line = from.readLine();
                String name = "";
                String img = "";
                String code = "";
                if (line.contains("<Name>") && line.contains("</Name>")) {
                    name = line.replaceAll("<Name>", "").replaceAll("</Name>", "");
                }
                if ((line = from.readLine()).contains("<Image>") && line.contains("</Image>")) {
                    img = line.replaceAll("<Image>", "").replaceAll("</Image>", "");
                }
                this.eventList.events.addElement(new Value(name, img, new DefaultListModel()));
                line = from.readLine();
                while (!line.equals("</Event>")) {
                    if (line.equals("<Action>")) {
                        line = from.readLine();
                        if (line.contains("<Name>") && line.contains("</Name>")) {
                            name = line.replaceAll("<Name>", "").replaceAll("</Name>", "");
                        }
                        if ((line = from.readLine()).contains("<Image>") && line.contains("</Image>")) {
                            img = line.replaceAll("<Image>", "").replaceAll("</Image>", "");
                            System.out.println(img);
                        }
                        if ((line = from.readLine()).contains("<Code>") && line.contains("</Code>")) {
                            code = line.replaceAll("<Image>", "").replaceAll("</Image>", "");
                            System.out.println(img);
                        }
                        line = from.readLine();
                        Value v = (Value)this.eventList.events.lastElement();
                        v.actions.addElement(new ActionValue(name, img, code));
                    }
                    line = from.readLine();
                }
            }
        }
        finally {
            from.close();
        }
    }

    private void eventListValueChanged(ListSelectionEvent evt) {
        if (this.eventList.getSelectedValue() == null) {
            return;
        }
        this.actionList1.setModel(((Value)this.eventList.getSelectedValue()).actions);
    }

    private void actionList1MouseDragged(MouseEvent evt) {
        int newIndex = this.actionList1.locationToIndex(evt.getPoint());
        if (newIndex != this.draggingIndex) {
            Object temp = ActionList.model.get(this.draggingIndex);
            ActionList.model.set(this.draggingIndex, ActionList.model.get(newIndex));
            ActionList.model.set(newIndex, temp);
            this.draggingIndex = newIndex;
        }
    }

    private void actionList1MouseReleased(MouseEvent evt) {
        this.draggingIndex = -1;
    }

    private void MousePressed(MouseEvent evt) {
        this.draggingIndex = this.actionList1.locationToIndex(evt.getPoint());
    }

    public static synchronized ActorEditorTopComponent getDefault() {
        if (instance == null) {
            // empty if block
        }
        return instance;
    }

    public static synchronized ActorEditorTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(16, "Cannot find MyWindow component. It will not be located properly in the window system.");
            return ActorEditorTopComponent.getDefault();
        }
        if (win instanceof ActorEditorTopComponent) {
            return (ActorEditorTopComponent)win;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'ActorEditorTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return ActorEditorTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        this.setActivatedNodes(new Node[]{this.a.getNodeDelegate()});
    }

    public void componentClosed() {
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private PaletteController initializePalette() {
        try {
            return PaletteFactory.createPalette((String)"ActorEditorPalette", (PaletteActions)new PaletteActions(){

                public Action[] getCustomCategoryActions(Lookup lookup) {
                    return new Action[0];
                }

                public Action[] getCustomItemActions(Lookup lookup) {
                    return new Action[0];
                }

                public Action[] getCustomPaletteActions() {
                    return new Action[0];
                }

                public Action[] getImportActions() {
                    return new Action[0];
                }

                public Action getPreferredAction(Lookup lookup) {
                    return null;
                }
            });
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static ActorEditorTopComponent getInstance(String name, actorDataObject a) {
        Iterator opened = TopComponent.getRegistry().getOpened().iterator();
        while (opened.hasNext()) {
            Object tc = opened.next();
            if (!(tc instanceof ActorEditorTopComponent)) continue;
            ActorEditorTopComponent elc = (ActorEditorTopComponent)tc;
            System.out.println(name + " " + elc.path);
            if (!name.equals(elc.path)) continue;
            return elc;
        }
        return new ActorEditorTopComponent(a);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.explorerManager && "selectedNodes".equals(evt.getPropertyName())) {
            this.setActivatedNodes(this.explorerManager.getSelectedNodes());
        }
    }

    public void save() throws IOException {
        this.savefile();
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return ActorEditorTopComponent.getDefault();
        }
    }
}

