/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openide.util.Utilities;

public class ExtIcon {
    private Image image;

    public ExtIcon() {
    }

    public ExtIcon(byte[] byArray) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        ColorModel colorModel = ColorModel.getRGBdefault();
        this.image = toolkit.createImage(new MemoryImageSource(16, 16, colorModel, byArray, 0, 64));
    }

    public void setIcon(Icon icon) {
        this.image = Utilities.icon2Image((Icon)icon);
    }

    public Icon getIcon() {
        return new ImageIcon(this.image);
    }

    public byte[] getBytes() throws IOException {
        PixelGrabber pixelGrabber = new PixelGrabber(this.image, 0, 0, 16, 16, false);
        try {
            pixelGrabber.grabPixels();
            if ((pixelGrabber.getStatus() & 0x80) != 0) {
                throw new IOException("Cannot load image data");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Loading image interrupted");
        }
        Object object = pixelGrabber.getPixels();
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        return ExtIcon.intToByteArray((int[])object);
    }

    public static byte[] intToByteArray(int[] nArray) {
        byte[] byArray = new byte[nArray.length * 4];
        for (int i = 0; i < byArray.length; i += 4) {
            int n = nArray[i / 4];
            byArray[i] = (byte)(n >>> 24);
            byArray[i + 1] = (byte)(n >> 16 & 0xFF);
            byArray[i + 2] = (byte)(n >> 8 & 0xFF);
            byArray[i + 3] = (byte)(n & 0xFF);
        }
        return byArray;
    }
}

