/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.ExtIcon;
import org.netbeans.modules.project.ui.OpenProjectListSettings;
import org.netbeans.modules.project.ui.OpeningProjectPanel;
import org.netbeans.modules.project.ui.ProjectInfoAccessor;
import org.netbeans.modules.project.ui.ProjectUtilities;
import org.netbeans.modules.project.ui.api.UnloadedProjectInformation;
import org.netbeans.modules.project.uiapi.ProjectOpenedTrampoline;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OpenProjectList {
    public static final Comparator<Project> PROJECT_BY_DISPLAYNAME = new ProjectByDisplayNameComparator();
    public static final String PROPERTY_OPEN_PROJECTS = "OpenProjects";
    public static final String PROPERTY_MAIN_PROJECT = "MainProject";
    public static final String PROPERTY_RECENT_PROJECTS = "RecentProjects";
    private static OpenProjectList INSTANCE;
    private static final int NUM_TEMPLATES = 15;
    private static final ErrorManager ERR;
    private static final RequestProcessor OPENING_RP;
    private List<Project> openProjects;
    private HashMap<ModuleInfo, List<Project>> openProjectsModuleInfos;
    private Project mainProject;
    private final RecentProjectList recentProjects;
    private List<String> recentTemplates;
    private final PropertyChangeSupport pchSupport;
    private ProjectDeletionListener deleteListener = new ProjectDeletionListener();
    private PropertyChangeListener infoListener;

    OpenProjectList() {
        this.openProjects = new ArrayList<Project>();
        this.openProjectsModuleInfos = new HashMap();
        this.infoListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                    OpenProjectList.this.checkModuleInfo((ModuleInfo)propertyChangeEvent.getSource());
                }
            }
        };
        this.pchSupport = new PropertyChangeSupport(this);
        this.recentProjects = new RecentProjectList(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenProjectList getDefault() {
        boolean bl = false;
        Class<OpenProjectList> clazz = OpenProjectList.class;
        synchronized (OpenProjectList.class) {
            if (INSTANCE == null) {
                bl = true;
                INSTANCE = new OpenProjectList();
                OpenProjectList.INSTANCE.openProjects = OpenProjectList.loadProjectList();
                OpenProjectList.INSTANCE.recentTemplates = new ArrayList<String>(OpenProjectListSettings.getInstance().getRecentTemplates());
                URL uRL = OpenProjectListSettings.getInstance().getMainProjectURL();
                OpenProjectList.INSTANCE.recentProjects.load();
                for (Project project : OpenProjectList.INSTANCE.openProjects) {
                    INSTANCE.addModuleInfo(project);
                    try {
                        if (uRL == null || !uRL.equals(project.getProjectDirectory().getURL())) continue;
                        OpenProjectList.INSTANCE.mainProject = project;
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {}
                }
            }
            // ** MonitorExit[clazz] (shouldn't be in output)
            if (bl) {
                for (Project project : new ArrayList<Project>(OpenProjectList.INSTANCE.openProjects)) {
                    OpenProjectList.notifyOpened(project);
                }
            }
            return INSTANCE;
        }
    }

    public void open(Project project) {
        this.open(new Project[]{project}, false);
    }

    public void open(Project project, boolean bl) {
        this.open(new Project[]{project}, bl);
    }

    public void open(Project[] projectArray, boolean bl) {
        this.open(projectArray, bl, false);
    }

    public void open(final Project[] projectArray, final boolean bl, final boolean bl2) {
        if (projectArray.length == 0) {
            return;
        }
        long l = System.currentTimeMillis();
        if (bl2) {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        OpenProjectList.this.open(projectArray, bl, bl2);
                    }
                });
                return;
            }
            final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(OpenProjectList.class, (String)"CAP_Opening_Projects"));
            Frame frame = WindowManager.getDefault().getMainWindow();
            final JDialog jDialog = new JDialog(frame, NbBundle.getMessage(OpenProjectList.class, (String)"LBL_Opening_Projects_Progress"), true);
            final OpeningProjectPanel openingProjectPanel = new OpeningProjectPanel(progressHandle);
            jDialog.getContentPane().add(openingProjectPanel);
            jDialog.setDefaultCloseOperation(0);
            jDialog.pack();
            Rectangle rectangle = frame.getBounds();
            int n = rectangle.x + rectangle.width / 2;
            int n2 = rectangle.y + rectangle.height / 2;
            Dimension dimension = jDialog.getPreferredSize();
            jDialog.setBounds(n - dimension.width / 2, n2 - dimension.height / 2, dimension.width, dimension.height);
            OPENING_RP.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        OpenProjectList.this.doOpen(projectArray, bl, progressHandle, openingProjectPanel);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                try {
                                    Thread.currentThread();
                                    Thread.sleep(50L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                jDialog.setVisible(false);
                                jDialog.dispose();
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            });
            jDialog.setVisible(true);
        } else {
            this.doOpen(projectArray, bl, null, null);
        }
        long l2 = System.currentTimeMillis();
        if (ERR.isLoggable(1)) {
            ERR.log(1, "opening projects took: " + (l2 - l) + "ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOpen(Project[] projectArray, boolean bl, ProgressHandle progressHandle, OpeningProjectPanel openingProjectPanel) {
        int n;
        assert (!Arrays.asList(projectArray).contains(null)) : "Projects can't be null";
        boolean bl2 = false;
        int n2 = 1000;
        int n3 = n2 / 2;
        double d = 0.0;
        LinkedHashSet<Project> linkedHashSet = new LinkedHashSet<Project>();
        if (progressHandle != null) {
            progressHandle.start(n2);
            progressHandle.progress(0);
        }
        if (openingProjectPanel != null) {
            assert (projectArray.length > 0) : "at least one project to open";
            openingProjectPanel.setProjectName(ProjectUtils.getInformation((Project)projectArray[0]).getDisplayName());
        }
        HashMap<Project, Set> hashMap = new HashMap<Project, Set>();
        LinkedList<Project> linkedList = new LinkedList<Project>(Arrays.asList(projectArray));
        while (!linkedList.isEmpty()) {
            Set set;
            Project project = (Project)linkedList.remove(0);
            Set set2 = set = bl ? (Set)hashMap.get(project) : Collections.emptySet();
            if (set == null) {
                SubprojectProvider subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
                set = subprojectProvider != null ? subprojectProvider.getSubprojects() : Collections.emptySet();
                hashMap.put(project, set);
            }
            linkedHashSet.add(project);
            for (Project project2 : set) {
                if (linkedHashSet.contains(project2) || linkedList.contains(project2)) continue;
                linkedList.add(project2);
            }
            double d2 = ((double)n3 - d) / (double)(linkedList.size() + 1);
            n = (int)d;
            if (progressHandle == null || n >= (int)(d += d2)) continue;
            progressHandle.progress((int)d);
        }
        double d3 = (n2 - n3) / linkedHashSet.size();
        for (Project project2 : linkedHashSet) {
            if (openingProjectPanel != null) {
                openingProjectPanel.setProjectName(ProjectUtils.getInformation((Project)project2).getDisplayName());
            }
            bl2 |= this.doOpenProject(project2);
            n = (int)d;
            if (progressHandle == null || n >= (int)(d += d3)) continue;
            progressHandle.progress((int)d);
        }
        OpenProjectList openProjectList = this;
        synchronized (openProjectList) {
            OpenProjectList.saveProjectList(this.openProjects);
            if (bl2) {
                this.recentProjects.save();
            }
        }
        if (progressHandle != null) {
            progressHandle.finish();
        }
        final boolean bl3 = bl2;
        Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                OpenProjectList.this.pchSupport.firePropertyChange(OpenProjectList.PROPERTY_OPEN_PROJECTS, null, null);
                if (bl3) {
                    OpenProjectList.this.pchSupport.firePropertyChange(OpenProjectList.PROPERTY_RECENT_PROJECTS, null, null);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Project[] projectArray, boolean bl) {
        if (!ProjectUtilities.closeAllDocuments(projectArray, bl)) {
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        OpenProjectList openProjectList = this;
        synchronized (openProjectList) {
            for (int i = 0; i < projectArray.length; ++i) {
                if (!this.openProjects.contains(projectArray[i])) continue;
                if (!bl2) {
                    bl2 = this.isMainProject(projectArray[i]);
                }
                this.openProjects.remove(projectArray[i]);
                this.removeModuleInfo(projectArray[i]);
                projectArray[i].getProjectDirectory().removeFileChangeListener((FileChangeListener)this.deleteListener);
                this.recentProjects.add(projectArray[i]);
                OpenProjectList.notifyClosed(projectArray[i]);
                bl3 = true;
            }
            if (bl3) {
                OpenProjectList.saveProjectList(this.openProjects);
            }
            if (bl2) {
                this.mainProject = null;
                OpenProjectList.saveMainProject(this.mainProject);
            }
            if (bl3) {
                this.recentProjects.save();
            }
        }
        if (bl3) {
            this.pchSupport.firePropertyChange(PROPERTY_OPEN_PROJECTS, null, null);
        }
        if (bl2) {
            this.pchSupport.firePropertyChange(PROPERTY_MAIN_PROJECT, null, null);
        }
        if (bl3) {
            this.pchSupport.firePropertyChange(PROPERTY_RECENT_PROJECTS, null, null);
        }
        for (int i = 0; i < projectArray.length; ++i) {
            try {
                ProjectManager.getDefault().saveProject(projectArray[i]);
                continue;
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
    }

    public synchronized Project[] getOpenProjects() {
        Project[] projectArray = new Project[this.openProjects.size()];
        this.openProjects.toArray(projectArray);
        return projectArray;
    }

    public synchronized boolean isOpen(Project project) {
        for (Project project2 : this.openProjects) {
            if (!project.getProjectDirectory().equals(project2.getProjectDirectory())) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isMainProject(Project project) {
        return this.mainProject != null && project != null && this.mainProject.getProjectDirectory().equals(project.getProjectDirectory());
    }

    public synchronized Project getMainProject() {
        return this.mainProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMainProject(Project project) {
        OpenProjectList openProjectList = this;
        synchronized (openProjectList) {
            if (project != null && !this.openProjects.contains(project)) {
                throw new IllegalArgumentException("Project " + ProjectUtils.getInformation((Project)project).getDisplayName() + " is not open and cannot be set as main.");
            }
            this.mainProject = project;
            OpenProjectList.saveMainProject(project);
        }
        this.pchSupport.firePropertyChange(PROPERTY_MAIN_PROJECT, null, null);
    }

    public synchronized List getRecentProjects() {
        return this.recentProjects.getProjects();
    }

    public synchronized boolean isRecentProjectsEmpty() {
        return this.recentProjects.isEmpty();
    }

    public synchronized List getRecentProjectsInformation() {
        return this.recentProjects.getRecentProjectsInfo();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pchSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pchSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public List<DataObject> getTemplatesLRU(Project project) {
        ArrayList<FileObject> arrayList = this.getTemplateNamesLRU(project);
        ArrayList<DataObject> arrayList2 = new ArrayList<DataObject>();
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject = (FileObject)iterator.next();
            if (fileObject != null) {
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    arrayList2.add(dataObject);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    iterator.remove();
                    ErrorManager.getDefault().notify(1, (Throwable)dataObjectNotFoundException);
                }
                continue;
            }
            iterator.remove();
        }
        return arrayList2;
    }

    public void updateTemplatesLRU(FileObject fileObject) {
        String string = fileObject.getPath();
        if (this.recentTemplates.contains(string)) {
            this.recentTemplates.remove(string);
        }
        this.recentTemplates.add(0, string);
        if (this.recentTemplates.size() > 100) {
            this.recentTemplates.remove(100);
        }
        OpenProjectListSettings.getInstance().setRecentTemplates(new ArrayList<String>(this.recentTemplates));
    }

    static void shutdown() {
        if (INSTANCE != null) {
            for (Project project : OpenProjectList.INSTANCE.openProjects) {
                OpenProjectList.notifyClosed(project);
            }
        }
    }

    public static Project fileToProject(File file) {
        try {
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject != null && fileObject.isFolder()) {
                return ProjectManager.getDefault().findProject(fileObject);
            }
            return null;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            return null;
        }
    }

    private static List<Project> URLs2Projects(Collection<URL> collection) {
        ArrayList<Project> arrayList = new ArrayList<Project>(collection.size());
        for (URL uRL : collection) {
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            if (fileObject == null || !fileObject.isFolder()) continue;
            try {
                Project project = ProjectManager.getDefault().findProject(fileObject);
                if (project == null) continue;
                arrayList.add(project);
            }
            catch (Throwable throwable) {
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                ErrorManager.getDefault().notify(1, throwable);
            }
        }
        return arrayList;
    }

    private static List<URL> projects2URLs(Collection<Project> collection) {
        ArrayList<URL> arrayList = new ArrayList<URL>(collection.size());
        for (Project project : collection) {
            try {
                URL uRL = project.getProjectDirectory().getURL();
                if (uRL == null) continue;
                arrayList.add(uRL);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
            }
        }
        return arrayList;
    }

    private static void notifyOpened(Project project) {
        for (ProjectOpenedHook projectOpenedHook : project.getLookup().lookupAll(ProjectOpenedHook.class)) {
            try {
                ProjectOpenedTrampoline.DEFAULT.projectOpened(projectOpenedHook);
            }
            catch (RuntimeException runtimeException) {
                ErrorManager.getDefault().notify((Throwable)runtimeException);
                OpenProjectList.INSTANCE.openProjects.remove(project);
                INSTANCE.removeModuleInfo(project);
            }
            catch (Error error) {
                ErrorManager.getDefault().notify((Throwable)error);
                OpenProjectList.INSTANCE.openProjects.remove(project);
                INSTANCE.removeModuleInfo(project);
            }
        }
    }

    private static void notifyClosed(Project project) {
        for (ProjectOpenedHook projectOpenedHook : project.getLookup().lookupAll(ProjectOpenedHook.class)) {
            try {
                ProjectOpenedTrampoline.DEFAULT.projectClosed(projectOpenedHook);
            }
            catch (RuntimeException runtimeException) {
                ErrorManager.getDefault().notify((Throwable)runtimeException);
            }
            catch (Error error) {
                ErrorManager.getDefault().notify((Throwable)error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doOpenProject(final Project project) {
        boolean bl;
        OpenProjectList openProjectList = this;
        synchronized (openProjectList) {
            if (this.openProjects.contains(project)) {
                return false;
            }
            this.openProjects.add(project);
            this.addModuleInfo(project);
            project.getProjectDirectory().addFileChangeListener((FileChangeListener)this.deleteListener);
            bl = this.recentProjects.remove(project);
        }
        OpenProjectList.notifyOpened(project);
        Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                ProjectUtilities.openProjectFiles(project);
                return null;
            }
        });
        return bl;
    }

    private static List<Project> loadProjectList() {
        List<URL> list = OpenProjectListSettings.getInstance().getOpenProjectsURLs();
        List<Project> list2 = OpenProjectList.URLs2Projects(list);
        return list2;
    }

    private static void saveProjectList(List<Project> list) {
        List<URL> list2 = OpenProjectList.projects2URLs(list);
        OpenProjectListSettings.getInstance().setOpenProjectsURLs(list2);
    }

    private static void saveMainProject(Project project) {
        try {
            URL uRL = project == null ? null : project.getProjectDirectory().getURL();
            OpenProjectListSettings.getInstance().setMainProjectURL(uRL);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            OpenProjectListSettings.getInstance().setMainProjectURL(null);
        }
    }

    private ArrayList<FileObject> getTemplateNamesLRU(Project project) {
        FileObject fileObject;
        String string;
        int n;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(15);
        RecommendedTemplates recommendedTemplates = (RecommendedTemplates)project.getLookup().lookup(RecommendedTemplates.class);
        String[] stringArray = recommendedTemplates == null ? new String[]{} : recommendedTemplates.getRecommendedTypes();
        PrivilegedTemplates privilegedTemplates = (PrivilegedTemplates)project.getLookup().lookup(PrivilegedTemplates.class);
        String[] stringArray2 = privilegedTemplates == null ? null : privilegedTemplates.getPrivilegedTemplates();
        ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(privilegedTemplates == null ? new String[]{} : stringArray2));
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        Iterator<String> iterator = this.recentTemplates.iterator();
        for (n = 0; n < 15 && iterator.hasNext(); ++n) {
            string = iterator.next();
            fileObject = fileSystem.findResource(string);
            if (fileObject == null) {
                iterator.remove();
                continue;
            }
            if (!OpenProjectList.isRecommended(project, fileObject)) continue;
            arrayList.add(fileObject);
            arrayList2.remove(string);
        }
        iterator = arrayList2.iterator();
        for (n = arrayList.size(); n < 15 && iterator.hasNext(); ++n) {
            string = iterator.next();
            fileObject = fileSystem.findResource(string);
            if (fileObject == null) continue;
            arrayList.add(fileObject);
        }
        return arrayList;
    }

    static boolean isRecommended(Project project, FileObject fileObject) {
        if (OpenProjectList.getRecommendedTypes(project) == null || OpenProjectList.getRecommendedTypes(project).length == 0) {
            return true;
        }
        Object object = fileObject.getAttribute("templateCategory");
        if (object != null) {
            assert (object instanceof String) : fileObject + " attr templateCategory = " + object;
            Iterator<String> iterator = OpenProjectList.getCategories((String)object).iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                String string = iterator.next();
                if (!Arrays.asList(OpenProjectList.getRecommendedTypes(project)).contains(string)) continue;
                bl = true;
                break;
            }
            return bl;
        }
        return true;
    }

    private static String[] getRecommendedTypes(Project project) {
        RecommendedTemplates recommendedTemplates = (RecommendedTemplates)project.getLookup().lookup(RecommendedTemplates.class);
        return recommendedTemplates == null ? null : recommendedTemplates.getRecommendedTypes();
    }

    private static List<String> getCategories(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken().trim());
        }
        return arrayList;
    }

    private static ModuleInfo findModuleForProject(Project project) {
        Collection collection = Lookup.getDefault().lookupAll(ModuleInfo.class);
        ModuleInfo moduleInfo = null;
        for (ModuleInfo moduleInfo2 : collection) {
            if (!moduleInfo2.isEnabled() || moduleInfo2.getClassLoader() != project.getClass().getClassLoader()) continue;
            moduleInfo = moduleInfo2;
            break;
        }
        return moduleInfo;
    }

    private void addModuleInfo(Project project) {
        ModuleInfo moduleInfo = OpenProjectList.findModuleForProject(project);
        if (moduleInfo != null) {
            if (!this.openProjectsModuleInfos.containsKey(moduleInfo)) {
                this.openProjectsModuleInfos.put(moduleInfo, new ArrayList());
                moduleInfo.addPropertyChangeListener(this.infoListener);
            }
            this.openProjectsModuleInfos.get(moduleInfo).add(project);
        }
    }

    private void removeModuleInfo(Project project) {
        ModuleInfo moduleInfo = OpenProjectList.findModuleForProject(project);
        this.removeModuleInfo(project, moduleInfo);
    }

    private void removeModuleInfo(Project project, ModuleInfo moduleInfo) {
        if (moduleInfo != null) {
            this.openProjectsModuleInfos.get(moduleInfo).remove(project);
            if (this.openProjectsModuleInfos.get(moduleInfo).size() == 0) {
                moduleInfo.removePropertyChangeListener(this.infoListener);
                this.openProjectsModuleInfos.remove(moduleInfo);
            }
        }
    }

    private void checkModuleInfo(ModuleInfo moduleInfo) {
        if (moduleInfo.isEnabled()) {
            return;
        }
        ArrayList arrayList = new ArrayList(this.openProjectsModuleInfos.get(moduleInfo));
        if (arrayList != null && arrayList.size() > 0) {
            for (Project project : arrayList) {
                this.removeModuleInfo(project, moduleInfo);
            }
            this.close(arrayList.toArray(new Project[arrayList.size()]), false);
        }
    }

    static {
        ERR = ErrorManager.getDefault().getInstance(OpenProjectList.class.getName());
        OPENING_RP = new RequestProcessor("Opening projects", 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProjectByDisplayNameComparator
    implements Comparator<Project> {
        private static Comparator<Object> COLLATOR = Collator.getInstance();

        @Override
        public int compare(Project project, Project project2) {
            String string = ProjectUtils.getInformation((Project)project).getDisplayName();
            String string2 = ProjectUtils.getInformation((Project)project2).getDisplayName();
            if (string != null && string2 != null) {
                return COLLATOR.compare(string, string2);
            }
            if (string == null && string2 != null) {
                ERR.log(16, project + ": ProjectInformation.getDisplayName() should not return null!");
                return -1;
            }
            if (string != null && string2 == null) {
                ERR.log(16, project2 + ": ProjectInformation.getDisplayName() should not return null!");
                return 1;
            }
            return 0;
        }
    }

    private final class ProjectDeletionListener
    extends FileChangeAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileDeleted(FileEvent fileEvent) {
            OpenProjectList openProjectList = OpenProjectList.this;
            synchronized (openProjectList) {
                Project project = null;
                for (Project project2 : OpenProjectList.this.openProjects) {
                    if (!fileEvent.getFile().equals(project2.getProjectDirectory())) continue;
                    project = project2;
                    break;
                }
                if (project != null) {
                    OpenProjectList.this.close(new Project[]{project}, false);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RecentProjectList {
        private List<ProjectReference> recentProjects;
        private List<UnloadedProjectInformation> recentProjectsInfos;
        private int size;

        public RecentProjectList(int n) {
            this.size = n;
            this.recentProjects = new ArrayList<ProjectReference>(n);
            this.recentProjectsInfos = new ArrayList<UnloadedProjectInformation>(n);
            if (ERR.isLoggable(1)) {
                ERR.log("created a RecentProjectList: size=" + n);
            }
        }

        public void add(Project project) {
            int n = this.getIndex(project);
            if (n == -1) {
                if (ERR.isLoggable(1)) {
                    ERR.log("add new recent project: " + project);
                }
                if (this.recentProjects.size() == this.size) {
                    this.recentProjects.remove(this.size - 1);
                    this.recentProjectsInfos.remove(this.size - 1);
                }
                this.recentProjects.add(0, new ProjectReference(project));
                try {
                    this.recentProjectsInfos.add(0, ProjectInfoAccessor.DEFAULT.getProjectInfo(ProjectUtils.getInformation((Project)project).getDisplayName(), ProjectUtils.getInformation((Project)project).getIcon(), project.getProjectDirectory().getURL()));
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
                }
            } else {
                if (ERR.isLoggable(1)) {
                    ERR.log("re-add recent project: " + project);
                }
                this.recentProjects.remove(n);
                this.recentProjects.add(0, new ProjectReference(project));
                this.recentProjectsInfos.remove(n);
                try {
                    this.recentProjectsInfos.add(0, ProjectInfoAccessor.DEFAULT.getProjectInfo(ProjectUtils.getInformation((Project)project).getDisplayName(), ProjectUtils.getInformation((Project)project).getIcon(), project.getProjectDirectory().getURL()));
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
                }
            }
        }

        public boolean remove(Project project) {
            int n = this.getIndex(project);
            if (n != -1) {
                if (ERR.isLoggable(1)) {
                    ERR.log("remove recent project: " + project);
                }
                this.recentProjects.remove(n);
                this.recentProjectsInfos.remove(n);
                return true;
            }
            return false;
        }

        public List<Project> getProjects() {
            ArrayList<Project> arrayList = new ArrayList<Project>(this.recentProjects.size());
            ArrayList<ProjectReference> arrayList2 = new ArrayList<ProjectReference>(this.recentProjects);
            for (ProjectReference projectReference : arrayList2) {
                Project project = projectReference.getProject();
                if (project == null || !project.getProjectDirectory().isValid()) {
                    this.remove(project);
                    if (!ERR.isLoggable(1)) continue;
                    ERR.log("removing dead recent project: " + project);
                    continue;
                }
                arrayList.add(project);
            }
            if (ERR.isLoggable(1)) {
                ERR.log("recent projects: " + arrayList);
            }
            return arrayList;
        }

        public boolean isEmpty() {
            boolean bl = this.recentProjects.isEmpty();
            if (ERR.isLoggable(1)) {
                ERR.log("recent projects empty? " + bl);
            }
            return bl;
        }

        public void load() {
            List<URL> list = OpenProjectListSettings.getInstance().getRecentProjectsURLs();
            List<String> list2 = OpenProjectListSettings.getInstance().getRecentProjectsDisplayNames();
            List<ExtIcon> list3 = OpenProjectListSettings.getInstance().getRecentProjectsIcons();
            if (ERR.isLoggable(1)) {
                ERR.log("recent project list load: " + list);
            }
            this.recentProjects.clear();
            Iterator<Object> iterator = list.iterator();
            while (iterator.hasNext()) {
                this.recentProjects.add(new ProjectReference(iterator.next()));
            }
            this.recentProjectsInfos.clear();
            iterator = list2.iterator();
            Iterator<URL> iterator2 = list.iterator();
            Iterator<ExtIcon> iterator3 = list3.iterator();
            while (iterator.hasNext() && iterator2.hasNext() && iterator3.hasNext()) {
                String string = (String)iterator.next();
                URL uRL = iterator2.next();
                Icon icon = iterator3.next().getIcon();
                this.recentProjectsInfos.add(ProjectInfoAccessor.DEFAULT.getProjectInfo(string, icon, uRL));
            }
            if (this.recentProjects.size() != this.recentProjectsInfos.size()) {
                this.recentProjects.clear();
                this.recentProjectsInfos.clear();
            }
        }

        public void save() {
            Serializable serializable;
            ArrayList<URL> arrayList = new ArrayList<URL>(this.recentProjects.size());
            for (ProjectReference object2 : this.recentProjects) {
                serializable = object2.getURL();
                if (serializable == null) continue;
                arrayList.add((URL)serializable);
            }
            if (ERR.isLoggable(1)) {
                ERR.log("recent project list save: " + arrayList);
            }
            OpenProjectListSettings.getInstance().setRecentProjectsURLs(arrayList);
            int n = this.recentProjectsInfos.size();
            ArrayList<String> arrayList2 = new ArrayList<String>(n);
            serializable = new ArrayList(n);
            for (UnloadedProjectInformation unloadedProjectInformation : this.recentProjectsInfos) {
                arrayList2.add(unloadedProjectInformation.getDisplayName());
                ExtIcon extIcon = new ExtIcon();
                extIcon.setIcon(unloadedProjectInformation.getIcon());
                serializable.add(extIcon);
            }
            OpenProjectListSettings.getInstance().setRecentProjectsDisplayNames(arrayList2);
            OpenProjectListSettings.getInstance().setRecentProjectsIcons((List<ExtIcon>)((Object)serializable));
        }

        private int getIndex(Project project) {
            URL uRL;
            try {
                if (project == null || project.getProjectDirectory() == null) {
                    return -1;
                }
                uRL = project.getProjectDirectory().getURL();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                return -1;
            }
            int n = 0;
            Iterator<ProjectReference> iterator = this.recentProjects.iterator();
            while (iterator.hasNext()) {
                URL uRL2 = iterator.next().getURL();
                if (uRL.equals(uRL2)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        private List getRecentProjectsInfo() {
            return this.recentProjectsInfos;
        }

        private static class ProjectReference {
            private WeakReference<Project> projectReference;
            private URL projectURL;

            public ProjectReference(URL uRL) {
                this.projectURL = uRL;
            }

            public ProjectReference(Project project) {
                block2: {
                    this.projectReference = new WeakReference<Project>(project);
                    try {
                        this.projectURL = project.getProjectDirectory().getURL();
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        if (!ERR.isLoggable(1)) break block2;
                        ERR.log("FSIE getting URL for project: " + project.getProjectDirectory());
                    }
                }
            }

            public Project getProject() {
                block9: {
                    FileObject fileObject;
                    Project project = null;
                    if (this.projectReference != null && (project = (Project)this.projectReference.get()) != null) {
                        if (ProjectManager.getDefault().isValid(project)) {
                            return project;
                        }
                        return null;
                    }
                    if (ERR.isLoggable(1)) {
                        ERR.log("no active project reference for " + this.projectURL);
                    }
                    if (this.projectURL != null && (fileObject = URLMapper.findFileObject((URL)this.projectURL)) != null && fileObject.isFolder()) {
                        try {
                            project = ProjectManager.getDefault().findProject(fileObject);
                            if (project != null) {
                                this.projectReference = new WeakReference<Project>(project);
                                if (ERR.isLoggable(1)) {
                                    ERR.log("found " + project);
                                }
                                return project;
                            }
                        }
                        catch (IOException iOException) {
                            if (!ERR.isLoggable(1)) break block9;
                            ERR.log("could not load recent project from " + this.projectURL);
                        }
                    }
                }
                if (ERR.isLoggable(1)) {
                    ERR.log("no recent project in " + this.projectURL);
                }
                return null;
            }

            public URL getURL() {
                return this.projectURL;
            }
        }
    }
}

