/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.ErrorManager;
import org.openide.actions.PropertiesAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class PhysicalView {
    public static boolean isProjectDirNode(Node node) {
        return node instanceof GroupNode && ((GroupNode)node).isProjectDir;
    }

    public static Node[] createNodesForProject(Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("generic");
        FileObject fileObject = project.getProjectDirectory();
        SourceGroup sourceGroup = null;
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            FileObject fileObject2 = sourceGroupArray[i].getRootFolder();
            if (!fileObject.equals(fileObject2) && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            if (sourceGroup != null) {
                sourceGroup = null;
                break;
            }
            sourceGroup = sourceGroupArray[i];
        }
        if (sourceGroup == null) {
            ErrorManager.getDefault().log(16, "Project " + project + "either does not contain it's project directory under the " + "Generic source groups or the project directory is under " + "more than one source group");
            return new Node[0];
        }
        ArrayList<GroupNode> arrayList = new ArrayList<GroupNode>(sourceGroupArray.length);
        arrayList.add(new GroupNode(project, sourceGroup, true, DataFolder.findFolder((FileObject)sourceGroup.getRootFolder())));
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            if (sourceGroupArray[i] == sourceGroup) continue;
            arrayList.add(new GroupNode(project, sourceGroupArray[i], false, DataFolder.findFolder((FileObject)sourceGroupArray[i].getRootFolder())));
        }
        Node[] nodeArray = new Node[arrayList.size()];
        arrayList.toArray(nodeArray);
        return nodeArray;
    }

    static final class GroupNode
    extends FilterNode
    implements PropertyChangeListener {
        private static final DataFilter VISIBILITY_QUERY_FILTER = new VisibilityQueryDataFilter();
        static final String GROUP_NAME_PATTERN = NbBundle.getMessage(PhysicalView.class, (String)"FMT_PhysicalView_GroupName");
        private Project project;
        private ProjectInformation pi;
        private SourceGroup group;
        private boolean isProjectDir;

        public GroupNode(Project project, SourceGroup sourceGroup, boolean bl, DataFolder dataFolder) {
            super(dataFolder.getNodeDelegate(), dataFolder.createNodeChildren(VISIBILITY_QUERY_FILTER), GroupNode.createLookup(project, sourceGroup, dataFolder));
            this.project = project;
            this.pi = ProjectUtils.getInformation((Project)project);
            this.group = sourceGroup;
            this.isProjectDir = bl;
            this.pi.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.pi));
            sourceGroup.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)sourceGroup));
        }

        public String getName() {
            if (this.isProjectDir) {
                return this.pi.getName();
            }
            String string = this.group.getName();
            if (string == null) {
                string = "???";
                ErrorManager.getDefault().log(16, "SourceGroup impl of type " + this.group.getClass().getName() + " specified a null getName(); this is illegal");
            }
            return string;
        }

        public String getDisplayName() {
            if (this.isProjectDir) {
                return this.pi.getDisplayName();
            }
            return MessageFormat.format(GROUP_NAME_PATTERN, this.group.getDisplayName(), this.pi.getDisplayName(), this.getOriginal().getDisplayName());
        }

        public String getShortDescription() {
            FileObject fileObject = this.group.getRootFolder();
            String string = FileUtil.getFileDisplayName((FileObject)fileObject);
            return NbBundle.getMessage(PhysicalView.class, (String)(this.isProjectDir ? "HINT_project" : "HINT_group"), (Object)string);
        }

        public boolean canRename() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }

        public Action[] getActions(boolean bl) {
            Action[] actionArray;
            if (bl) {
                return super.getActions(true);
            }
            Action[] actionArray2 = super.getActions(false);
            if (this.isProjectDir) {
                actionArray = new Action[actionArray2.length];
                for (int i = 0; i < actionArray2.length; ++i) {
                    actionArray[i] = actionArray2[i] instanceof PropertiesAction ? CommonProjectActions.customizeProjectAction() : actionArray2[i];
                }
            } else {
                actionArray = actionArray2;
            }
            return actionArray;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("displayName".equals(string)) {
                this.fireDisplayNameChange(null, null);
            } else if ("name".equals(string)) {
                this.fireNameChange(null, null);
            } else if (!"icon".equals(string)) {
                if ("name".equals(string)) {
                    this.fireNameChange(null, null);
                } else if ("displayName".equals(string)) {
                    this.fireDisplayNameChange(null, null);
                } else if (!"icon".equals(string)) {
                    if ("rootFolder".equals(string)) {
                        this.fireNameChange(null, null);
                        this.fireDisplayNameChange(null, null);
                        this.fireShortDescriptionChange(null, null);
                    } else if (!"containership".equals(string)) assert (false) : "Attempt to fire an unsupported property change event from " + this.pi.getClass().getName() + ": " + string;
                }
            }
        }

        private static Lookup createLookup(Project project, SourceGroup sourceGroup, DataFolder dataFolder) {
            return new ProxyLookup(new Lookup[]{dataFolder.getNodeDelegate().getLookup(), Lookups.fixed((Object[])new Object[]{project, new PathFinder(sourceGroup)}), project.getLookup()});
        }
    }

    public static class PathFinder {
        private SourceGroup group;

        public PathFinder(SourceGroup sourceGroup) {
            this.group = sourceGroup;
        }

        public Node findPath(Node node, Object object) {
            if (!(object instanceof FileObject)) {
                return null;
            }
            FileObject fileObject = (FileObject)object;
            FileObject fileObject2 = this.group.getRootFolder();
            if (FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) {
                String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
                ArrayList<String> arrayList = new ArrayList<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
                String string2 = fileObject.getName();
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    string2 = dataObject.getNodeDelegate().getName();
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    // empty catch block
                }
                arrayList.set(arrayList.size() - 1, string2);
                try {
                    return NodeOp.findPath((Node)node, Collections.enumeration(arrayList));
                }
                catch (NodeNotFoundException nodeNotFoundException) {
                    return null;
                }
            }
            if (fileObject2.equals(fileObject)) {
                return node;
            }
            return null;
        }
    }

    static final class VisibilityQueryDataFilter
    implements ChangeListener,
    ChangeableDataFilter {
        EventListenerList ell = new EventListenerList();

        public VisibilityQueryDataFilter() {
            VisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
        }

        public boolean acceptDataObject(DataObject dataObject) {
            FileObject fileObject = dataObject.getPrimaryFile();
            return VisibilityQuery.getDefault().isVisible(fileObject);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object[] objectArray = this.ell.getListenerList();
            ChangeEvent changeEvent2 = null;
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ChangeListener.class) continue;
                if (changeEvent2 == null) {
                    changeEvent2 = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent2);
            }
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.ell.add(ChangeListener.class, changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.ell.remove(ChangeListener.class, changeListener);
        }
    }
}

