/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.TemplateChooserPanelGUI;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class TemplateChooserPanel
implements WizardDescriptor.Panel,
ChangeListener {
    private static String lastCategory = null;
    private static String lastTemplate = null;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private TemplateChooserPanelGUI gui;
    private Project project;

    TemplateChooserPanel(Project project) {
        this.project = project;
    }

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new TemplateChooserPanelGUI();
            this.gui.addChangeListener(this);
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        return null;
    }

    public boolean isValid() {
        return this.gui != null && this.gui.getTemplate() != null;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> arrayList;
        ChangeEvent changeEvent = new ChangeEvent(this);
        TemplateChooserPanel templateChooserPanel = this;
        synchronized (templateChooserPanel) {
            arrayList = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener changeListener : arrayList) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public void readSettings(Object object) {
        TemplateChooserPanelGUI templateChooserPanelGUI = (TemplateChooserPanelGUI)this.getComponent();
        templateChooserPanelGUI.readValues(this.project, lastCategory, lastTemplate);
        ((WizardDescriptor)object).putProperty("WizardPanel_contentSelectedIndex", (Object)new Integer(0));
        ((WizardDescriptor)object).putProperty("WizardPanel_contentData", (Object)new String[]{NbBundle.getBundle(TemplateChooserPanel.class).getString("LBL_TemplatesPanel_Name"), NbBundle.getBundle(TemplateChooserPanel.class).getString("LBL_TemplatesPanel_Dots")});
        ((WizardDescriptor)object).putProperty("NewFileWizard_Title", null);
    }

    public void storeSettings(Object object) {
        WizardDescriptor wizardDescriptor = (WizardDescriptor)object;
        Object object2 = wizardDescriptor.getValue();
        if (NotifyDescriptor.CANCEL_OPTION != object2 && NotifyDescriptor.CLOSED_OPTION != object2) {
            try {
                Project project = this.gui.getProject();
                if (!this.project.equals(project)) {
                    this.project = project;
                    wizardDescriptor.putProperty("project", (Object)project);
                }
                if (this.gui.getTemplate() == null) {
                    return;
                }
                if (wizardDescriptor instanceof TemplateWizard) {
                    ((TemplateWizard)wizardDescriptor).setTemplate(DataObject.find((FileObject)this.gui.getTemplate()));
                } else {
                    wizardDescriptor.putProperty("targetTemplate", (Object)this.gui.getTemplate());
                }
                lastCategory = this.gui.getCategoryName();
                lastTemplate = this.gui.getTemplateName();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChange();
    }
}

