/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.OpenProjectListSettings;
import org.netbeans.modules.project.ui.ProjectChooserAccessory;
import org.netbeans.modules.project.ui.ProjectTab;
import org.netbeans.modules.project.ui.actions.BasicAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public class OpenProject
extends BasicAction {
    private static final String NAME = NbBundle.getMessage(OpenProject.class, (String)"LBL_OpenProjectAction_Name");
    private static final String _SHORT_DESCRIPTION = NbBundle.getMessage(OpenProject.class, (String)"LBL_OpenProjectAction_Tooltip");

    public OpenProject() {
        super(NAME, new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/project/ui/resources/openProject.gif")));
        this.putValue("iconBase", "org/netbeans/modules/project/ui/resources/openProject.gif");
        this.putValue("ShortDescription", _SHORT_DESCRIPTION);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2;
        OpenProjectListSettings openProjectListSettings2;
        JFileChooser jFileChooser;
        block5: {
            int n;
            jFileChooser = ProjectChooserAccessory.createProjectChooser(true);
            jFileChooser.setMultiSelectionEnabled(true);
            for (OpenProjectListSettings openProjectListSettings2 : Utilities.actionsGlobalContext().lookupAll(DataObject.class)) {
                Project project = FileOwnerQuery.getOwner((FileObject)openProjectListSettings2.getPrimaryFile());
                if (project == null || OpenProjectList.getDefault().isOpen(project) || (object2 = FileUtil.toFile((FileObject)project.getProjectDirectory())) == null) continue;
                jFileChooser.setCurrentDirectory(((File)object2).getParentFile());
                jFileChooser.setSelectedFiles(new File[]{object2});
                break;
            }
            openProjectListSettings2 = OpenProjectListSettings.getInstance();
            while ((n = jFileChooser.showOpenDialog(WindowManager.getDefault().getMainWindow())) == 0) {
                object2 = jFileChooser.isMultiSelectionEnabled() ? jFileChooser.getSelectedFiles() : new File[]{jFileChooser.getSelectedFile()};
                ArrayList<Project> arrayList = new ArrayList<Project>(((File[])object2).length);
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    object = OpenProjectList.fileToProject(FileUtil.normalizeFile((File)object2[i]));
                    if (object == null) continue;
                    arrayList.add((Project)object);
                }
                if (arrayList.isEmpty()) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(OpenProject.class, (String)"MSG_notProjectDir"), 2));
                    continue;
                }
                Project[] projectArray = new Project[arrayList.size()];
                arrayList.toArray(projectArray);
                OpenProjectList.getDefault().open(projectArray, openProjectListSettings2.isOpenSubprojects(), true);
                if (openProjectListSettings2.isOpenAsMain() && projectArray.length == 1) {
                    OpenProjectList.getDefault().setMainProject(projectArray[0]);
                }
                break block5;
            }
            return;
        }
        object = ProjectTab.findDefault("projectTabLogical_tc");
        SwingUtilities.invokeLater(new Runnable((ProjectTab)((Object)object), (File[])object2){
            final /* synthetic */ ProjectTab val$ptLogial;
            final /* synthetic */ File[] val$projectDirs;
            {
                this.val$ptLogial = projectTab;
                this.val$projectDirs = fileArray;
            }

            public void run() {
                Node node = this.val$ptLogial.getExplorerManager().getRootContext();
                ArrayList<Node> arrayList = new ArrayList<Node>(this.val$projectDirs.length);
                for (int i = 0; i < this.val$projectDirs.length; ++i) {
                    Node node2 = node.getChildren().findChild(this.val$projectDirs[i].getName());
                    if (node2 == null) continue;
                    arrayList.add(node2);
                }
                try {
                    Node[] nodeArray = new Node[arrayList.size()];
                    arrayList.toArray(nodeArray);
                    this.val$ptLogial.getExplorerManager().setSelectedNodes(nodeArray);
                    if (!Boolean.getBoolean("project.tab.no.selection")) {
                        this.val$ptLogial.open();
                        this.val$ptLogial.requestActive();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        openProjectListSettings2.setLastOpenProjectDir(jFileChooser.getCurrentDirectory().getPath());
    }
}

