/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.ProjectTab;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public class RecentProjects
extends AbstractAction
implements Presenter.Menu,
Presenter.Popup,
PropertyChangeListener {
    private static final String PROJECT_URL_KEY = "org.netbeans.modules.project.ui.RecentProjectItem.Project_URL";
    private final ProjectDirListener prjDirListener = new ProjectDirListener();
    private UpdatingMenu subMenu;
    private boolean recreate;

    public RecentProjects() {
        super(NbBundle.getMessage(RecentProjects.class, (String)"LBL_RecentProjectsAction_Name"));
        OpenProjectList.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjectList.getDefault()));
        this.recreate = true;
    }

    public boolean isEnabled() {
        return !OpenProjectList.getDefault().isRecentProjectsEmpty();
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public JMenuItem getMenuPresenter() {
        this.createMainSubMenu();
        return this.subMenu;
    }

    public JMenuItem getPopupPresenter() {
        UpdatingMenu updatingMenu = this.createSubMenu();
        this.fillSubMenu(updatingMenu);
        return updatingMenu;
    }

    private UpdatingMenu createSubMenu() {
        UpdatingMenu updatingMenu = new UpdatingMenu(this);
        updatingMenu.setMnemonic(NbBundle.getMessage(RecentProjects.class, (String)"MNE_RecentProjectsAction_Name").charAt(0));
        return updatingMenu;
    }

    private void createMainSubMenu() {
        if (this.subMenu == null) {
            this.subMenu = this.createSubMenu();
            this.subMenu.getModel().addChangeListener(this.subMenu);
        }
    }

    private void fillSubMenu(JMenu jMenu) {
        jMenu.removeAll();
        List list = OpenProjectList.getDefault().getRecentProjects();
        if (list.isEmpty()) {
            jMenu.setEnabled(false);
            return;
        }
        jMenu.setEnabled(true);
        MenuItemActionListener menuItemActionListener = new MenuItemActionListener();
        for (Project project : list) {
            FileObject fileObject = project.getProjectDirectory();
            try {
                URL uRL = fileObject.getURL();
                if (uRL == null || fileObject == null || !fileObject.isValid()) continue;
                fileObject.removeFileChangeListener((FileChangeListener)this.prjDirListener);
                fileObject.addFileChangeListener((FileChangeListener)this.prjDirListener);
                ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
                JMenuItem jMenuItem = new JMenuItem(projectInformation.getDisplayName(), projectInformation.getIcon());
                jMenu.add(jMenuItem);
                jMenuItem.putClientProperty(PROJECT_URL_KEY, uRL);
                jMenuItem.addActionListener(menuItemActionListener);
            }
            catch (FileStateInvalidException fileStateInvalidException) {}
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("RecentProjects".equals(propertyChangeEvent.getPropertyName())) {
            this.createMainSubMenu();
            this.subMenu.setEnabled(!OpenProjectList.getDefault().isRecentProjectsEmpty());
            this.recreate = true;
        }
    }

    private static class MenuItemActionListener
    implements ActionListener {
        private MenuItemActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JMenuItem) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                URL uRL = (URL)jMenuItem.getClientProperty(RecentProjects.PROJECT_URL_KEY);
                Project project = null;
                FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                if (fileObject != null && fileObject.isFolder()) {
                    try {
                        project = ProjectManager.getDefault().findProject(fileObject);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (project != null) {
                    OpenProjectList.getDefault().open(new Project[]{project}, false, true);
                    ProjectTab projectTab = ProjectTab.findDefault("projectTabLogical_tc");
                    Node node = projectTab.getExplorerManager().getRootContext();
                    Node node2 = node.getChildren().findChild(project.getProjectDirectory().getName());
                    try {
                        projectTab.getExplorerManager().setSelectedNodes(new Node[]{node2});
                        projectTab.open();
                        projectTab.requestActive();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private class ProjectDirListener
    extends FileChangeAdapter {
        private ProjectDirListener() {
        }

        public void fileDeleted(FileEvent fileEvent) {
            RecentProjects.this.recreate = true;
        }
    }

    private class UpdatingMenu
    extends JMenu
    implements ChangeListener {
        public UpdatingMenu(Action action) {
            super(action);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (RecentProjects.this.recreate && this.getModel().isSelected()) {
                RecentProjects.this.fillSubMenu(this);
                RecentProjects.this.recreate = false;
            }
        }
    }
}

