/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.ProjectAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public class SetMainProject
extends ProjectAction
implements Presenter.Menu,
PropertyChangeListener {
    private static final String namePattern = NbBundle.getMessage(SetMainProject.class, (String)"LBL_SetAsMainProjectAction_Name");
    private static final String PROJECT_KEY = "org.netbeans.modules.project.ui.MainProjectItem";
    protected JMenu subMenu;

    public SetMainProject() {
        this((Lookup)null);
    }

    public SetMainProject(Lookup lookup) {
        super(SetMainProject.class.getName(), namePattern, null, lookup);
        if (lookup == null) {
            OpenProjectList.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjectList.getDefault()));
        }
        this.refresh(this.getLookup());
    }

    protected void actionPerformed(Lookup lookup) {
        Project[] projectArray = ActionsUtil.getProjectsFromLookup(lookup, null);
        if (projectArray != null && projectArray.length > 0) {
            OpenProjectList.getDefault().setMainProject(projectArray[0]);
        }
    }

    public void refresh(Lookup lookup) {
        super.refresh(lookup);
        Project[] projectArray = ActionsUtil.getProjectsFromLookup(lookup, null);
        if (projectArray.length != 1) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new SetMainProject(lookup);
    }

    public JMenuItem getMenuPresenter() {
        this.createSubMenu();
        return this.subMenu;
    }

    private void createSubMenu() {
        Object object;
        Project[] projectArray = OpenProjectList.getDefault().getOpenProjects();
        Arrays.sort(projectArray, OpenProjectList.PROJECT_BY_DISPLAYNAME);
        if (projectArray == null || projectArray.length == 0) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
        if (this.subMenu == null) {
            object = NbBundle.getMessage(SetMainProject.class, (String)"LBL_SetMainProjectAction_Name");
            this.subMenu = new JMenu((String)object);
            this.subMenu.setMnemonic(NbBundle.getMessage(SetMainProject.class, (String)"MNE_SetMainProjectAction_Name").charAt(0));
            this.subMenu.putClientProperty(SetMainProject.class, this);
        }
        this.subMenu.removeAll();
        object = new MenuItemActionListener();
        for (int i = 0; i < projectArray.length; ++i) {
            ProjectInformation projectInformation = ProjectUtils.getInformation((Project)projectArray[i]);
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(projectInformation.getDisplayName(), projectInformation.getIcon(), false);
            this.subMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.putClientProperty(PROJECT_KEY, projectArray[i]);
            jRadioButtonMenuItem.addActionListener((ActionListener)object);
        }
        this.selectMainProject();
        this.subMenu.setEnabled(projectArray.length > 0);
    }

    private void selectMainProject() {
        for (int i = 0; i < this.subMenu.getItemCount(); ++i) {
            JMenuItem jMenuItem = this.subMenu.getItem(i);
            Project project = (Project)jMenuItem.getClientProperty(PROJECT_KEY);
            if (!(jMenuItem instanceof JRadioButtonMenuItem)) continue;
            if (OpenProjectList.getDefault().isMainProject(project)) {
                ((JRadioButtonMenuItem)jMenuItem).setSelected(true);
                continue;
            }
            ((JRadioButtonMenuItem)jMenuItem).setSelected(false);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("OpenProjects".equals(propertyChangeEvent.getPropertyName())) {
            this.createSubMenu();
        } else if ("MainProject".equals(propertyChangeEvent.getPropertyName()) && this.subMenu != null) {
            this.selectMainProject();
        }
    }

    private static class MenuItemActionListener
    implements ActionListener {
        private MenuItemActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem;
            Project project;
            if (actionEvent.getSource() instanceof JMenuItem && (project = (Project)(jMenuItem = (JMenuItem)actionEvent.getSource()).getClientProperty(SetMainProject.PROJECT_KEY)) != null) {
                OpenProjectList.getDefault().setMainProject(project);
            }
        }
    }

    public static final class PopupWithoutContext
    extends SetMainProject
    implements Presenter.Popup {
        public PopupWithoutContext() {
        }

        private PopupWithoutContext(Lookup lookup) {
            super(lookup);
        }

        public JMenuItem getPopupPresenter() {
            this.subMenu = null;
            return this.getMenuPresenter();
        }

        public Action createContextAwareInstance(Lookup lookup) {
            return new PopupWithoutContext(lookup);
        }
    }
}

