/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.help.HelpSet;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.javahelp.Help;
import org.netbeans.modules.javahelp.HelpConstants;
import org.netbeans.modules.javahelp.Installer;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHelp
extends Help
implements HelpConstants {
    private Lookup.Result<HelpSet> helpsets = null;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    protected AbstractHelp() {
    }

    protected final Collection<? extends HelpSet> getHelpSets() {
        if (this.helpsets == null) {
            Installer.log.fine("searching for instances of HelpSet...");
            this.helpsets = Lookup.getDefault().lookupResult(HelpSet.class);
            this.helpsets.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    AbstractHelp.this.helpSetsChanged();
                }
            });
            this.fireChangeEvent();
        }
        Collection collection = this.helpsets.allInstances();
        if (Installer.log.isLoggable(Level.FINE)) {
            ArrayList<String> arrayList = new ArrayList<String>(Math.min(1, collection.size()));
            for (HelpSet helpSet : collection) {
                arrayList.add(helpSet.getTitle());
            }
            Installer.log.fine("listing helpsets: " + arrayList);
        }
        return collection;
    }

    protected final boolean helpSetsReady() {
        return this.helpsets != null;
    }

    protected final boolean shouldMerge(HelpSet helpSet) {
        Boolean bl = (Boolean)helpSet.getKeyData("OpenIDE", "mergeIntoMaster");
        return bl == null || bl != false;
    }

    protected void helpSetsChanged() {
        Installer.log.fine("helpSetsChanged");
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fireChangeEvent() {
        HashSet<ChangeListener> hashSet;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AbstractHelp.this.fireChangeEvent();
                }
            });
            return;
        }
        Object object = this.listeners;
        synchronized (object) {
            hashSet = new HashSet<ChangeListener>(this.listeners);
        }
        object = new ChangeEvent(this);
        Installer.log.fine("Help.stateChanged");
        for (ChangeListener changeListener : hashSet) {
            changeListener.stateChanged((ChangeEvent)object);
        }
    }
}

