/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.io.File;
import org.netbeans.modules.openfile.OpenFileImpl;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class OpenFile {
    private OpenFile() {
    }

    public static boolean open(FileObject fileObject, int n) {
        for (OpenFileImpl openFileImpl : Lookup.getDefault().lookupAll(OpenFileImpl.class)) {
            if (!openFileImpl.open(fileObject, n)) continue;
            return true;
        }
        return false;
    }

    static boolean openFile(File file, int n) {
        if (!OpenFile.checkFileExists(file)) {
            return false;
        }
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        if (fileObject != null) {
            return OpenFile.open(fileObject, n);
        }
        return false;
    }

    private static boolean checkFileExists(File file) {
        String string;
        if (!file.exists()) {
            string = "MSG_fileNotFound";
        } else if (OpenFile.isSpecifiedByUNCPath(file)) {
            string = "MSG_UncNotSupported";
        } else if (!file.isFile() && !file.isDirectory()) {
            string = "MSG_fileNotFound";
        } else {
            return true;
        }
        String string2 = file.toString();
        String string3 = NbBundle.getMessage(OpenFile.class, (String)string, (Object)string2);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)string3));
        return false;
    }

    static boolean isSpecifiedByUNCPath(File file) {
        assert (file != null && file.exists());
        file = FileUtil.normalizeFile((File)file);
        return file.getPath().startsWith("\\\\");
    }
}

