/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.pdf;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import org.netbeans.modules.pdf.PDFOpenSupport;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.XMLDataObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LinkProcessor
implements InstanceCookie,
XMLDataObject.Processor,
ActionListener {
    public static final String PUBLIC_ID = "-//NetBeans//DTD PDF Document Menu Link 1.0//EN";
    public static final String PUBLIC_WWW = "http://www.netbeans.org/dtds/pdf_link-1_0.dtd";
    private XMLDataObject xmlDataObject;

    public void attachTo(XMLDataObject xMLDataObject) {
        this.xmlDataObject = xMLDataObject;
    }

    public Class instanceClass() throws IOException, ClassNotFoundException {
        return JMenuItem.class;
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        String string = this.xmlDataObject.getNodeDelegate().getDisplayName();
        JMenuItem jMenuItem = new JMenuItem();
        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)string);
        jMenuItem.addActionListener(this);
        return jMenuItem;
    }

    public String instanceName() {
        return this.xmlDataObject.getName();
    }

    private String getXMLFileName() {
        FileObject fileObject = this.xmlDataObject.getPrimaryFile();
        return FileUtil.getFileDisplayName((FileObject)fileObject);
    }

    private void notifyXMLFileBroken() {
        String string = NbBundle.getMessage(LinkProcessor.class, (String)"EXC_file_not_matching_DTD", (Object)this.getXMLFileName());
        ErrorManager.getDefault().log(256, string);
    }

    private void notifyBadFileSpec(String string, String string2, boolean bl) {
        String string3 = NbBundle.getMessage(LinkProcessor.class, (String)string, (Object)this.getXMLFileName(), (Object)string2);
        ErrorManager.getDefault().log(bl ? 16 : 256, string3);
    }

    private void notifyFileDoesNotExist(String string) {
        String string2 = NbBundle.getMessage(LinkProcessor.class, (String)"MSG_File_does_not_exist", (Object)string);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 2));
    }

    private File grabFile(Element element) {
        String string = element.getTagName();
        if (string.equals("file")) {
            if (!element.hasAttribute("path")) {
                this.notifyXMLFileBroken();
                return null;
            }
            return new File(element.getAttribute("path"));
        }
        if (string.equals("idefile")) {
            if (!element.hasAttribute("base")) {
                this.notifyXMLFileBroken();
                return null;
            }
            String string2 = element.getAttribute("base");
            String string3 = string2.replace('.', '/') + ".pdf";
            File file = InstalledFileLocator.getDefault().locate(string3, null, true);
            if (file == null) {
                this.notifyFileDoesNotExist(string3);
                return null;
            }
            return file;
        }
        if (string.equals("url")) {
            URL uRL;
            if (!element.hasAttribute("name")) {
                this.notifyXMLFileBroken();
                return null;
            }
            String string4 = element.getAttribute("name");
            try {
                uRL = new URL(string4);
            }
            catch (MalformedURLException malformedURLException) {
                this.notifyBadFileSpec("MSG_Cannot_open_malformed_URL", string4, true);
                return null;
            }
            if (!uRL.getProtocol().equals("file")) {
                this.notifyBadFileSpec("MSG_Cannot_open_unsupported_URL", string4, false);
            }
            try {
                return new File(new URI("file://" + uRL.getPath()));
            }
            catch (URISyntaxException uRISyntaxException) {
                ErrorManager.getDefault().notify((Throwable)uRISyntaxException);
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorManager.getDefault().notify((Throwable)illegalArgumentException);
                return null;
            }
        }
        this.notifyXMLFileBroken();
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Document document = this.xmlDataObject.getDocument();
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            Node node = null;
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                if (node == null) {
                    node = node2;
                    continue;
                }
                this.notifyXMLFileBroken();
                return;
            }
            if (node == null) {
                this.notifyXMLFileBroken();
                return;
            }
            Element element2 = (Element)node;
            File file = this.grabFile(element2);
            if (file != null) {
                try {
                    new PDFOpenSupport(file).open();
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.notifyFileDoesNotExist(file.getPath());
                }
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }
}

