/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.pdf;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.pdf.ReconfigureReaderPanel;
import org.netbeans.modules.pdf.Settings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.util.NbBundle;

class PDFOpenSupport
implements OpenCookie {
    private static final String[] APP_DIRS = new String[]{"/usr/bin", "/usr/local/bin"};
    private static final String[] VIEWER_NAMES = new String[]{"evince", "xpdf", "kghostview", "ggv", "acroread"};
    private static final String[] NO_PATH_VIEWERS = new String[]{"acroread", "open"};
    static final String FALLBACK_VIEWER_NAME = "acroread";
    private File f;

    public PDFOpenSupport(File file) {
        this.f = file;
    }

    public void open() {
        boolean bl;
        Settings settings = Settings.getDefault();
        File file = settings.getPDFViewer();
        boolean bl2 = bl = file == null;
        if (bl && (file = PDFOpenSupport.tryPredefinedViewers(this.f)) != null) {
            settings.setPDFViewer(file);
            return;
        }
        if (bl) {
            file = new File(FALLBACK_VIEWER_NAME);
        }
        boolean bl3 = false;
        while (true) {
            try {
                Process process = Runtime.getRuntime().exec(new String[]{file.getPath(), this.f.getAbsolutePath()});
                if (!bl && !bl3) break;
                settings.setPDFViewer(file);
            }
            catch (IOException iOException) {
                bl3 = true;
                String string = iOException.getLocalizedMessage();
                ReconfigureReaderPanel reconfigureReaderPanel = new ReconfigureReaderPanel(file, string);
                String string2 = NbBundle.getMessage(PDFOpenSupport.class, (String)"TITLE_pick_a_viewer");
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)reconfigureReaderPanel, string2);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) != DialogDescriptor.OK_OPTION) break;
                file = reconfigureReaderPanel.getSelectedFile();
                settings.setPDFViewer(file);
                continue;
            }
            break;
        }
    }

    private static File tryPredefinedViewers(File file) {
        Object object;
        int n;
        for (n = 0; n < APP_DIRS.length; ++n) {
            object = new File(APP_DIRS[n]);
            if (!((File)object).exists() || !((File)object).isDirectory()) continue;
            for (int i = 0; i < VIEWER_NAMES.length; ++i) {
                String string = APP_DIRS[n] + File.separatorChar + VIEWER_NAMES[i];
                File file2 = new File(string);
                if (!file2.exists()) continue;
                try {
                    Process process = Runtime.getRuntime().exec(new String[]{string, file.getAbsolutePath()});
                    return file2;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        for (n = 0; n < NO_PATH_VIEWERS.length; ++n) {
            try {
                object = Runtime.getRuntime().exec(new String[]{NO_PATH_VIEWERS[n], file.getAbsolutePath()});
                return new File(NO_PATH_VIEWERS[n]);
            }
            catch (IOException iOException) {
                continue;
            }
        }
        return null;
    }
}

