/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.types.FullTextType;
import org.netbeans.modules.search.types.TextDetail;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

final class MatchingObject
implements PropertyChangeListener {
    private final ResultModel resultModel;
    private final File file;
    private final long timestamp;
    final Object object;
    private boolean selected = true;
    private boolean expanded = false;
    private boolean[] selectedMatches;
    private boolean childrenSelectionDirty;
    private boolean valid = true;
    private StringBuilder text;
    boolean wasCrLf = false;
    private static final boolean REALLY_WRITE = true;

    MatchingObject(ResultModel resultModel, Object object) {
        if (resultModel == null) {
            throw new IllegalArgumentException("resultModel = null");
        }
        if (object == null) {
            throw new IllegalArgumentException("object = null");
        }
        this.resultModel = resultModel;
        this.object = object;
        FileObject fileObject = this.getFileObject();
        this.file = FileUtil.toFile((FileObject)fileObject);
        this.timestamp = this.file != null ? this.file.lastModified() : 0L;
        this.valid = this.timestamp != 0L;
        this.setUpDataObjValidityChecking();
    }

    private void setUpDataObjValidityChecking() {
        DataObject dataObject = (DataObject)this.object;
        if (dataObject.isValid()) {
            dataObject.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    void cleanup() {
        DataObject dataObject = (DataObject)this.object;
        dataObject.removePropertyChangeListener((PropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("valid".equals(propertyChangeEvent.getPropertyName()) && Boolean.FALSE.equals(propertyChangeEvent.getNewValue())) {
            assert (propertyChangeEvent.getSource() == (DataObject)this.object);
            DataObject dataObject = (DataObject)this.object;
            dataObject.removePropertyChangeListener((PropertyChangeListener)this);
            this.resultModel.objectBecameInvalid(this);
        }
    }

    boolean isObjectValid() {
        return ((DataObject)this.object).isValid();
    }

    private FileObject getFileObject() {
        return ((DataObject)this.object).getPrimaryFile();
    }

    void setSelected(boolean bl) {
        if (bl == this.selected) {
            return;
        }
        this.selected = bl;
        this.selectedMatches = null;
    }

    boolean isSelected() {
        return this.selected;
    }

    boolean isUniformSelection() {
        return this.selectedMatches == null;
    }

    Boolean checkSubnodesSelection() {
        if (this.selectedMatches == null) {
            return this.selected;
        }
        boolean bl = this.selectedMatches[0];
        for (int i = 1; i < this.selectedMatches.length; ++i) {
            if (this.selectedMatches[i] == bl) continue;
            return null;
        }
        return bl;
    }

    void toggleSubnodeSelection(ResultModel resultModel, int n) {
        if (this.selectedMatches == null) {
            this.selectedMatches = new boolean[resultModel.getDetailsCount(this)];
            Arrays.fill(this.selectedMatches, this.selected);
        }
        this.selectedMatches[n] = !this.selectedMatches[n];
    }

    void setSubnodeSelected(int n, boolean bl, ResultModel resultModel) {
        if (this.selectedMatches == null) {
            if (bl == this.selected) {
                return;
            }
            this.selectedMatches = new boolean[resultModel.getDetailsCount(this)];
            Arrays.fill(this.selectedMatches, this.selected);
        }
        assert (n >= 0 && n < this.selectedMatches.length);
        this.selectedMatches[n] = bl;
    }

    boolean isSubnodeSelected(int n) {
        assert (this.selectedMatches == null || n >= 0 && n < this.selectedMatches.length);
        return this.selectedMatches == null ? this.selected : this.selectedMatches[n];
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == MatchingObject.class && ((MatchingObject)object).object == this.object;
    }

    public int hashCode() {
        return this.object.hashCode() + 1;
    }

    void markChildrenSelectionDirty() {
        this.childrenSelectionDirty = true;
    }

    void markChildrenSelectionClean() {
        this.childrenSelectionDirty = false;
    }

    boolean isChildrenSelectionDirty() {
        return this.childrenSelectionDirty;
    }

    void markExpanded(boolean bl) {
        this.expanded = bl;
    }

    boolean isExpanded() {
        return this.expanded;
    }

    File getFile() {
        return this.file;
    }

    String getName() {
        return this.getFile().getName();
    }

    long getTimestamp() {
        return this.timestamp;
    }

    String getDescription() {
        return this.getFile().getParent();
    }

    String getText() throws IOException {
        StringBuilder stringBuilder = this.text();
        if (stringBuilder != null) {
            return stringBuilder.toString();
        }
        return null;
    }

    private StringBuilder text() throws IOException {
        return this.text(false);
    }

    private StringBuilder text(boolean bl) throws IOException {
        assert (!EventQueue.isDispatchThread());
        if (bl || this.text == null) {
            this.text = this.readText();
        }
        return this.text == null ? new StringBuilder() : this.text;
    }

    private StringBuilder readText() throws IOException {
        StringBuilder stringBuilder = null;
        ByteBuffer byteBuffer = this.getByteBuffer();
        if (byteBuffer != null) {
            Matcher matcher;
            Charset charset = FullTextType.getCharset(this.getFileObject());
            CharBuffer charBuffer = charset.decode(byteBuffer);
            String string = System.getProperty("line.separator");
            if (!string.equals("\n") && (matcher = Pattern.compile(string).matcher(charBuffer)).find()) {
                this.wasCrLf = true;
                matcher.reset();
                stringBuilder = new StringBuilder(matcher.replaceAll("\n"));
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(charBuffer);
            }
        }
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer getByteBuffer() throws IOException {
        assert (!EventQueue.isDispatchThread());
        File file = this.getFile();
        FileInputStream fileInputStream = new FileInputStream(file);
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)file.length());
        FileChannel fileChannel = fileInputStream.getChannel();
        try {
            fileChannel.read(byteBuffer, 0L);
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            ByteBuffer byteBuffer2 = null;
            return byteBuffer2;
        }
        finally {
            fileChannel.close();
        }
        byteBuffer.rewind();
        return byteBuffer;
    }

    InvalidityStatus checkValidity() {
        InvalidityStatus invalidityStatus = this.getInvalidityStatus();
        if (invalidityStatus != null) {
            this.valid = false;
        }
        return invalidityStatus;
    }

    String getInvalidityDescription() {
        InvalidityStatus invalidityStatus = this.getInvalidityStatus();
        String string = invalidityStatus != null ? invalidityStatus.getDescription(this.getFile().getPath()) : null;
        return string;
    }

    private InvalidityStatus getInvalidityStatus() {
        File file = this.getFile();
        if (!file.exists()) {
            return InvalidityStatus.DELETED;
        }
        if (file.isDirectory()) {
            return InvalidityStatus.BECAME_DIR;
        }
        long l = file.lastModified();
        if (l > this.resultModel.getCreationTime()) {
            return InvalidityStatus.CHANGED;
        }
        if (file.length() > Integer.MAX_VALUE) {
            return InvalidityStatus.TOO_BIG;
        }
        if (!file.canRead()) {
            return InvalidityStatus.CANT_READ;
        }
        FullTextType fullTextType = this.resultModel.fullTextSearchType;
        if (fullTextType.getRe().length() == 0 && file.length() < (long)fullTextType.getMatchString().length()) {
            return InvalidityStatus.TOO_SHORT;
        }
        return null;
    }

    boolean isValid() {
        return this.valid;
    }

    public InvalidityStatus replace() throws IOException {
        boolean bl;
        assert (!EventQueue.isDispatchThread());
        assert (this.isSelected());
        Boolean bl2 = this.checkSubnodesSelection();
        boolean bl3 = bl2 == Boolean.TRUE;
        boolean bl4 = bl = bl2 == Boolean.FALSE;
        if (bl) {
            return null;
        }
        StringBuilder stringBuilder = this.text(true);
        List<TextDetail> list = this.resultModel.fullTextSearchType.getTextDetails(this.object);
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        block0: for (TextDetail textDetail : list) {
            int n6;
            int n7;
            int n8;
            int n9 = textDetail.getLine();
            while (n3 < n9) {
                n8 = stringBuilder.indexOf("\n", n2);
                if (n8 == -1) {
                    assert (false);
                    break block0;
                }
                n2 = n8 + 1;
                ++n3;
                n4 = 0;
                n5 = 0;
            }
            if (!this.isSubnodeSelected(n++)) continue;
            if (++n4 == 1) {
                n8 = 0;
                if (!$assertionsDisabled) {
                    n8 = 1;
                    if (1 == 0) {
                        throw new AssertionError();
                    }
                }
                if (n8 != 0) {
                    String string;
                    n7 = stringBuilder.indexOf("\n", n2);
                    String string2 = string = n7 != -1 ? stringBuilder.substring(n2, n7) : stringBuilder.substring(n2);
                    if (!string.equals(textDetail.getLineText())) {
                        return InvalidityStatus.CHANGED;
                    }
                }
            }
            n8 = textDetail.getMarkLength();
            n7 = n2 + n5 + (textDetail.getColumn() - 1);
            if (!stringBuilder.substring(n7, n6 = n7 + n8).equals(textDetail.getLineText().substring(textDetail.getColumn() - 1, textDetail.getColumn() - 1 + n8))) {
                return InvalidityStatus.CHANGED;
            }
            stringBuilder.replace(n7, n6, this.resultModel.replaceString);
            n5 += this.resultModel.replaceString.length() - n8;
        }
        return null;
    }

    void write() throws IOException {
        Object object;
        if (this.text == null) {
            throw new IllegalStateException("Buffer is gone");
        }
        if (this.wasCrLf) {
            object = System.getProperty("line.separator");
            this.text = new StringBuilder(this.text.toString().replace("\n", (CharSequence)object));
        }
        object = FullTextType.getCharset(this.getFileObject());
        ByteBuffer byteBuffer = ((Charset)object).encode(this.text.toString());
        FileOutputStream fileOutputStream = new FileOutputStream(this.getFile());
        FileChannel fileChannel = fileOutputStream.getChannel();
        fileChannel.write(byteBuffer);
        fileChannel.close();
    }

    public String toString() {
        return super.toString() + "[" + this.getName() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum InvalidityStatus {
        DELETED(true, "Inv_status_Err_deleted"),
        BECAME_DIR(true, "Inv_status_Err_became_dir"),
        CHANGED(false, "Inv_status_Err_changed"),
        TOO_BIG(false, "Inv_status_Err_too_big"),
        CANT_READ(false, "Inv_status_Err_cannot_read"),
        TOO_SHORT(false, "Inv_status_Err_too_short");

        private final boolean fatal;
        private final String descrBundleKey;

        private InvalidityStatus(boolean bl, String string2) {
            this.fatal = bl;
            this.descrBundleKey = string2;
        }

        boolean isFatal() {
            return this.fatal;
        }

        String getDescription(String string) {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)this.descrBundleKey, (Object)string);
        }
    }
}

