/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.ResultTreeModel;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.types.FullTextType;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openidex.search.DataObjectSearchGroup;
import org.openidex.search.SearchGroup;
import org.openidex.search.SearchType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResultModel {
    private static final int COUNT_LIMIT = 500;
    private static final int DETAILS_COUNT_LIMIT = 5000;
    private static final String DEF_SEARCH_TYPES_PACKAGE = "org.netbeans.modules.search.types";
    private static final String FULLTEXT_SEARCH_TYPE = "FullTextType";
    private final long creationTime;
    private int size = 0;
    private int totalDetailsCount = 0;
    private ResultTreeModel treeModel;
    private ResultView resultView;
    private boolean limitReached = false;
    private List<SearchType> searchTypeList;
    private SearchGroup searchGroup;
    private final boolean isDataObjectSearchGroup;
    final boolean defaultSearchTypesOnly;
    final boolean fullTextOnly;
    final FullTextType fullTextSearchType;
    final String replaceString;
    final boolean searchAndReplace;
    final List<MatchingObject> matchingObjects = new ArrayList<MatchingObject>();
    private String finishMessage;
    private MatchingObject infoCacheMatchingObject;
    private Boolean infoCacheHasDetails;
    private int infoCacheDetailsCount;
    private Node[] infoCacheDetailNodes;
    private final Node[] EMPTY_NODES_ARRAY = new Node[0];

    public ResultModel(List<SearchType> list, SearchGroup searchGroup, String string) {
        this.searchTypeList = list;
        this.searchGroup = searchGroup;
        this.replaceString = string;
        this.searchAndReplace = string != null;
        this.isDataObjectSearchGroup = searchGroup.getClass() == DataObjectSearchGroup.class;
        boolean bl = false;
        FullTextType fullTextType = null;
        for (SearchType searchType : searchGroup.getSearchTypes()) {
            Class<?> clazz = searchType.getClass();
            String string2 = clazz.getName();
            if (clazz == FullTextType.class) {
                fullTextType = (FullTextType)searchType;
            } else if (!string2.startsWith(DEF_SEARCH_TYPES_PACKAGE)) {
                bl = true;
            }
            if (bl && fullTextType != null) break;
        }
        this.defaultSearchTypesOnly = !bl;
        this.fullTextSearchType = fullTextType;
        this.fullTextOnly = (this.searchAndReplace || this.defaultSearchTypesOnly) && this.fullTextSearchType != null;
        this.creationTime = System.currentTimeMillis();
    }

    long getCreationTime() {
        return this.creationTime;
    }

    void setObserver(ResultTreeModel resultTreeModel) {
        this.treeModel = resultTreeModel;
    }

    void setObserver(ResultView resultView) {
        this.resultView = resultView;
    }

    void close() {
        if (this.matchingObjects != null && !this.matchingObjects.isEmpty()) {
            for (MatchingObject object : this.matchingObjects) {
                object.cleanup();
            }
        }
        if (this.searchTypeList != null) {
            for (SearchType searchType : this.searchTypeList) {
                if (!(searchType instanceof FullTextType)) continue;
                ((FullTextType)searchType).destroy();
            }
            this.searchTypeList.clear();
            this.searchTypeList = null;
        }
        this.searchGroup = null;
    }

    synchronized boolean objectFound(Object object) {
        MatchingObject matchingObject = new MatchingObject(this, object);
        if (!this.matchingObjects.add(matchingObject)) {
            return true;
        }
        assert (!this.limitReached);
        assert (this.treeModel != null);
        assert (this.resultView != null);
        this.totalDetailsCount += this.getDetailsCount(matchingObject);
        this.treeModel.objectFound(matchingObject, this.size++);
        this.resultView.objectFound(matchingObject, this.totalDetailsCount);
        return this.size < 500 && this.totalDetailsCount < 5000;
    }

    public void objectBecameInvalid(MatchingObject matchingObject) {
        int n = this.matchingObjects.indexOf(matchingObject);
        assert (n != -1);
        this.treeModel.objectBecameInvalid(matchingObject);
    }

    synchronized int getTotalDetailsCount() {
        return this.totalDetailsCount;
    }

    synchronized MatchingObject[] getMatchingObjects() {
        return this.matchingObjects.toArray(new MatchingObject[this.matchingObjects.size()]);
    }

    synchronized Object[] getFoundObjects() {
        Object[] objectArray = new Object[this.matchingObjects.size()];
        int n = 0;
        for (MatchingObject matchingObject : this.matchingObjects) {
            objectArray[n++] = matchingObject.object;
        }
        return objectArray;
    }

    public void run() {
    }

    boolean hasDetails() {
        return this.totalDetailsCount != 0;
    }

    Boolean canHaveDetails() {
        Boolean bl = this.fullTextSearchType != null ? Boolean.TRUE : (this.defaultSearchTypesOnly ? Boolean.FALSE : null);
        return bl;
    }

    private void prepareCacheFor(MatchingObject matchingObject) {
        if (matchingObject != this.infoCacheMatchingObject) {
            this.infoCacheHasDetails = null;
            this.infoCacheDetailsCount = -1;
            this.infoCacheDetailNodes = null;
            this.infoCacheMatchingObject = matchingObject;
        }
    }

    boolean hasDetails(MatchingObject matchingObject) {
        this.prepareCacheFor(matchingObject);
        if (this.infoCacheHasDetails != null) {
            return this.infoCacheHasDetails;
        }
        boolean bl = this.hasDetailsReal(matchingObject);
        this.infoCacheHasDetails = bl;
        assert (this.infoCacheHasDetails == Boolean.TRUE || this.infoCacheHasDetails == Boolean.FALSE);
        return bl;
    }

    private boolean hasDetailsReal(MatchingObject matchingObject) {
        boolean bl;
        if (this.fullTextSearchType != null) {
            bl = true;
        } else if (this.defaultSearchTypesOnly) {
            bl = false;
        } else {
            bl = false;
            Object object = matchingObject.object;
            for (SearchType searchType : this.searchGroup.getSearchTypes()) {
                Node[] nodeArray = searchType.getDetails(object);
                if (nodeArray == null || nodeArray.length == 0) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    int getDetailsCount(MatchingObject matchingObject) {
        this.prepareCacheFor(matchingObject);
        if (this.infoCacheDetailsCount == -1) {
            this.infoCacheDetailsCount = this.getDetailsCountReal(matchingObject);
            if (this.infoCacheDetailsCount == 0) {
                this.infoCacheDetailNodes = this.EMPTY_NODES_ARRAY;
            }
        }
        assert (this.infoCacheDetailsCount >= 0);
        return this.infoCacheDetailsCount;
    }

    private int getDetailsCountReal(MatchingObject matchingObject) {
        if (this.defaultSearchTypesOnly) {
            return this.fullTextSearchType != null ? this.fullTextSearchType.getDetailsCount(matchingObject.object) : 0;
        }
        int n = 0;
        Object object = matchingObject.object;
        for (SearchType searchType : this.searchGroup.getSearchTypes()) {
            if (searchType == this.fullTextSearchType) {
                n += this.fullTextSearchType.getDetailsCount(object);
                continue;
            }
            Node[] nodeArray = searchType.getDetails(object);
            n += nodeArray != null ? nodeArray.length : 0;
        }
        return n;
    }

    Node[] getDetails(MatchingObject matchingObject) {
        Node[] nodeArray;
        this.prepareCacheFor(matchingObject);
        if (this.infoCacheDetailNodes == null) {
            nodeArray = this.getDetailsReal(matchingObject);
            this.infoCacheDetailNodes = nodeArray != null ? nodeArray : this.EMPTY_NODES_ARRAY;
            this.infoCacheDetailsCount = this.infoCacheDetailNodes.length;
        } else {
            Node[] nodeArray2 = nodeArray = this.infoCacheDetailNodes != this.EMPTY_NODES_ARRAY ? this.infoCacheDetailNodes : null;
        }
        assert (this.infoCacheDetailNodes != null && (this.infoCacheDetailNodes == this.EMPTY_NODES_ARRAY || this.infoCacheDetailNodes.length > 0));
        assert (nodeArray == null || nodeArray.length > 0);
        return nodeArray;
    }

    private Node[] getDetailsReal(MatchingObject matchingObject) {
        if (this.defaultSearchTypesOnly) {
            return this.fullTextSearchType != null ? this.fullTextSearchType.getDetails(matchingObject.object) : null;
        }
        Node[] nodeArray = null;
        Object object = matchingObject.object;
        for (SearchType searchType : this.searchGroup.getSearchTypes()) {
            Node[] nodeArray2 = searchType.getDetails(object);
            if (nodeArray2 == null || nodeArray2.length == 0) continue;
            if (nodeArray == null) {
                nodeArray = nodeArray2;
                continue;
            }
            Node[] nodeArray3 = nodeArray;
            nodeArray = new Node[nodeArray.length + nodeArray2.length];
            System.arraycopy(nodeArray3, 0, nodeArray, 0, nodeArray3.length);
            System.arraycopy(nodeArray2, 0, nodeArray, nodeArray3.length, nodeArray2.length);
        }
        return nodeArray;
    }

    synchronized int size() {
        return this.size;
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    SearchGroup getSearchGroup() {
        return this.searchGroup;
    }

    List getEnabledSearchTypes() {
        return this.searchTypeList;
    }

    SearchType[] getQueriedSearchTypes() {
        return this.searchGroup.getSearchTypes();
    }

    boolean wasLimitReached() {
        return this.limitReached;
    }

    void searchException(RuntimeException runtimeException) {
        ErrorManager.Annotation[] annotationArray = ErrorManager.getDefault().findAnnotations((Throwable)runtimeException);
        for (int i = 0; i < annotationArray.length; ++i) {
            ErrorManager.Annotation annotation = annotationArray[i];
            if (annotation.getSeverity() != 256) continue;
            this.finishMessage = annotation.getLocalizedMessage();
            if (this.finishMessage == null) continue;
            return;
        }
        this.finishMessage = runtimeException.getLocalizedMessage();
    }

    String getExceptionMsg() {
        return this.finishMessage;
    }
}

