/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.netbeans.modules.search.ContextView;
import org.netbeans.modules.search.IssuesPanel;
import org.netbeans.modules.search.Manager;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.NodeListener;
import org.netbeans.modules.search.NodeRenderer;
import org.netbeans.modules.search.ReplaceTask;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ResultTreeModel;
import org.netbeans.modules.search.SearchPanel;
import org.netbeans.modules.search.SearchTask;
import org.netbeans.modules.search.Utils;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openidex.search.SearchType;

final class ResultView
extends TopComponent {
    private static final boolean SHOW_CONTEXT_BY_DEFAULT = true;
    private static final String RESULTS_CARD = "results";
    private static final String ISSUES_CARD = "issues";
    private boolean contextViewEnabled = true;
    private boolean contextViewVisible = false;
    private double dividerLocation = -1.0;
    private boolean ignoreContextButtonToggle = false;
    private boolean hasResults = false;
    private int objectsCount = 0;
    private volatile boolean hasDetails = false;
    private volatile boolean searchInProgress = false;
    private static final String ID = "search-results";
    private static WeakReference instance = null;
    private final JScrollPane treeView;
    private ResultModel resultModel = null;
    private ResultTreeModel treeModel = null;
    private final JTree tree;
    private final NodeListener nodeListener;
    private Node[] lastSearchNodes;
    private List lastEnabledSearchTypes;
    private MessageFormat nodeCountFormat;
    private MessageFormat nodeCountFormatFullText;
    private final CardLayout contentCards;
    private final CardLayout resultViewCards;
    private final JPanel mainPanel;
    private final JPanel resultsPanel;
    private final JButton btnReplace;
    private final JButton btnModifySearch;
    private final JButton btnShowDetails;
    private final JButton btnStop;
    private final JButton btnPrev;
    private final JButton btnNext;
    private final JToggleButton btnDisplayContext;
    private JSplitPane splitPane;
    private ContextView contextView;
    private IssuesPanel issuesPanel;
    private MatchingObject matchingObjIndexCacheObj = null;
    private int matchingObjIndexCacheIndex = -1;

    static synchronized ResultView getInstance() {
        ResultView resultView = (ResultView)WindowManager.getDefault().findTopComponent(ID);
        if (resultView == null) {
            resultView = ResultView.getDefault();
        }
        return resultView;
    }

    public static synchronized ResultView getDefault() {
        ResultView resultView;
        if (instance == null) {
            resultView = new ResultView();
            instance = new WeakReference<ResultView>(resultView);
        } else {
            resultView = (ResultView)((Object)instance.get());
            if (resultView == null) {
                resultView = new ResultView();
                instance = new WeakReference<ResultView>(resultView);
            }
        }
        return resultView;
    }

    private ResultView() {
        JToolBar jToolBar = new JToolBar(1);
        this.btnDisplayContext = new JToggleButton();
        this.btnDisplayContext.setIcon(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/search/res/context.gif", (boolean)true)));
        this.btnDisplayContext.setToolTipText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TOOLTIP_ShowContext"));
        this.btnDisplayContext.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ACSD_ShowContext"));
        this.btnDisplayContext.setSelected(true);
        this.btnPrev = new JButton();
        this.btnPrev.setIcon(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/search/res/prev.png", (boolean)true)));
        this.btnNext = new JButton();
        this.btnNext.setIcon(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/search/res/next.png", (boolean)true)));
        jToolBar.add(this.btnDisplayContext);
        jToolBar.add(new JToolBar.Separator());
        jToolBar.add(this.btnPrev);
        jToolBar.add(this.btnNext);
        jToolBar.setRollover(true);
        jToolBar.setFloatable(false);
        this.treeModel = ResultView.createTreeModel();
        this.nodeListener = new NodeListener();
        this.tree = ResultView.createTree(this.treeModel, this.nodeListener);
        this.treeView = new JScrollPane(this.tree);
        this.treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResultView.class, (String)"ACS_TREEVIEW"));
        this.treeView.setBorder(BorderFactory.createEmptyBorder());
        this.resultViewCards = new CardLayout();
        this.resultsPanel = new JPanel(this.resultViewCards);
        this.btnShowDetails = new JButton();
        this.btnModifySearch = new JButton();
        this.btnStop = new JButton();
        this.btnReplace = new JButton();
        ButtonListener buttonListener = new ButtonListener();
        this.btnShowDetails.addActionListener(buttonListener);
        this.btnModifySearch.addActionListener(buttonListener);
        this.btnStop.addActionListener(buttonListener);
        this.btnReplace.addActionListener(buttonListener);
        this.btnPrev.addActionListener(buttonListener);
        this.btnNext.addActionListener(buttonListener);
        this.btnDisplayContext.addItemListener(buttonListener);
        Mnemonics.setLocalizedText((AbstractButton)this.btnStop, (String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TEXT_BUTTON_STOP"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnShowDetails, (String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TEXT_BUTTON_FILL"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnReplace, (String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TEXT_BUTTON_REPLACE"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnModifySearch, (String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TEXT_BUTTON_CUSTOMIZE"));
        this.btnStop.setEnabled(false);
        this.btnShowDetails.setEnabled(false);
        this.btnReplace.setVisible(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.btnReplace);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.btnShowDetails);
        jPanel.add(this.btnModifySearch);
        jPanel.add(this.btnStop);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout(0, 5));
        this.mainPanel.add((Component)jToolBar, "West");
        this.mainPanel.add((Component)this.resultsPanel, "Center");
        this.mainPanel.add((Component)jPanel, "South");
        this.mainPanel.setOpaque(true);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        this.contentCards = new CardLayout();
        this.setLayout(this.contentCards);
        this.add(this.mainPanel, RESULTS_CARD);
        this.setName("Search Results");
        this.setDisplayName(NbBundle.getMessage(ResultView.class, (String)"TITLE_SEARCH_RESULTS"));
        this.setToolTipText(NbBundle.getMessage(ResultView.class, (String)"TOOLTIP_SEARCH_RESULTS"));
        this.setIcon(Utilities.loadImage((String)"org/netbeans/modules/search/res/find.gif"));
        this.initAccessibility();
        this.resultModelChanged();
    }

    private static ResultTreeModel createTreeModel() {
        ResultTreeModel resultTreeModel = new ResultTreeModel(null);
        resultTreeModel.setRootDisplayName(ResultView.getInitialRootNodeText());
        return resultTreeModel;
    }

    private static JTree createTree(ResultTreeModel resultTreeModel, NodeListener nodeListener) {
        JTree jTree = new JTree(resultTreeModel);
        jTree.setCellRenderer(new NodeRenderer(false));
        jTree.putClientProperty("JTree.lineStyle", "Angled");
        jTree.addMouseListener(nodeListener);
        jTree.addKeyListener(nodeListener);
        jTree.addTreeWillExpandListener(nodeListener);
        jTree.addTreeExpansionListener(nodeListener);
        jTree.setToggleClickCount(0);
        return jTree;
    }

    private static String getInitialRootNodeText() {
        return NbBundle.getMessage(ResultView.class, (String)"TEXT_Search_in_filesystems");
    }

    public int getPersistenceType() {
        return 0;
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    private Object readResolve() throws ObjectStreamException {
        return ResultView.getDefault();
    }

    private void initAccessibility() {
        ResourceBundle resourceBundle = NbBundle.getBundle(ResultView.class);
        this.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_ResultViewTopComponent"));
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ResultViewTopComponent"));
        AccessibleContext accessibleContext = this.treeView.getHorizontalScrollBar().getAccessibleContext();
        accessibleContext.setAccessibleName(resourceBundle.getString("ACSN_HorizontalScrollbar"));
        accessibleContext = this.treeView.getVerticalScrollBar().getAccessibleContext();
        accessibleContext.setAccessibleName(resourceBundle.getString("ACSN_VerticalScrollbar"));
        accessibleContext = this.treeView.getAccessibleContext();
        accessibleContext.setAccessibleName(resourceBundle.getString("ACSN_ResultTree"));
        accessibleContext.setAccessibleDescription(resourceBundle.getString("ACSD_ResultTree"));
        this.btnReplace.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_TEXT_BUTTON_REPLACE"));
        this.btnModifySearch.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_TEXT_BUTTON_CUSTOMIZE"));
        this.btnShowDetails.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_TEXT_BUTTON_FILL"));
        this.btnStop.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_TEXT_BUTTON_STOP"));
    }

    void closeResults() {
        this.close();
    }

    public void fillOutput() {
        this.btnShowDetails.setEnabled(false);
        Manager.getInstance().schedulePrintingDetails(this.resultModel.getFoundObjects(), this.resultModel.getSearchGroup());
    }

    private void setRootDisplayName(String string) {
        this.treeModel.setRootDisplayName(string);
    }

    protected void componentOpened() {
        assert (EventQueue.isDispatchThread());
        Manager.getInstance().searchWindowOpened();
        this.setRootDisplayName(ResultView.getInitialRootNodeText());
        if (this.lastSearchNodes == null) {
            this.btnModifySearch.setEnabled(false);
        }
    }

    protected void componentClosed() {
        assert (EventQueue.isDispatchThread());
        this.rememberInput(null, null);
        Manager.getInstance().searchWindowClosed();
        if (this.contextView != null) {
            this.contextView.unbindFromTreeSelection(this.tree);
            this.contextView = null;
        }
        if (this.splitPane != null) {
            this.rememberDividerLocation();
            this.resultsPanel.remove(this.splitPane);
            this.splitPane = null;
        }
        if (this.issuesPanel != null) {
            this.removeIssuesPanel();
        }
        this.contextViewVisible = false;
        this.contextViewEnabled = true;
    }

    void notifySearchPending(int n) {
        assert (EventQueue.isDispatchThread());
        this.removeIssuesPanel();
        String string = null;
        switch (n) {
            case 1: {
                string = "TEXT_FINISHING_PREV_SEARCH";
                break;
            }
            case 2: {
                string = "TEXT_CLEANING_RESULT";
                break;
            }
            case 4: {
                string = "TEXT_PRINTING_DETAILS";
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.setRootDisplayName(NbBundle.getMessage(ResultView.class, (String)string));
        this.btnStop.setEnabled(true);
        this.btnReplace.setEnabled(false);
    }

    void searchTaskStateChanged(int n) {
        switch (n) {
            case 1: {
                this.searchStarted();
                break;
            }
            case 2: {
                this.searchFinished();
                break;
            }
            case 3: {
                this.searchInterrupted();
                break;
            }
            case 4: {
                this.searchCancelled();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    void showAllDetailsFinished() {
        assert (EventQueue.isDispatchThread());
        this.updateShowAllDetailsBtn();
    }

    private void searchStarted() {
        assert (EventQueue.isDispatchThread());
        this.removeIssuesPanel();
        this.setRootDisplayName(NbBundle.getMessage(ResultView.class, (String)"TEXT_SEARCHING___"));
        this.nodeCountFormat = new MessageFormat(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TXT_RootSearchedNodes"));
        this.nodeCountFormatFullText = new MessageFormat(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TXT_RootSearchedNodesFulltext"));
        this.searchInProgress = true;
        this.updateShowAllDetailsBtn();
        this.btnModifySearch.setEnabled(true);
        this.btnStop.setEnabled(true);
        this.btnReplace.setEnabled(false);
    }

    private void searchFinished() {
        assert (EventQueue.isDispatchThread());
        this.setFinalRootNodeText();
        this.searchInProgress = false;
        this.hasDetails = this.resultModel != null ? this.resultModel.hasDetails() : false;
        this.updateShowAllDetailsBtn();
        this.btnStop.setEnabled(false);
        this.btnReplace.setEnabled(true);
    }

    private void searchInterrupted() {
        assert (EventQueue.isDispatchThread());
        this.searchFinished();
    }

    private void searchCancelled() {
        assert (EventQueue.isDispatchThread());
        this.setRootDisplayName(NbBundle.getMessage(ResultView.class, (String)"TEXT_TASK_CANCELLED"));
        this.searchInProgress = true;
        this.updateShowAllDetailsBtn();
        this.btnStop.setEnabled(false);
        this.btnReplace.setEnabled(true);
    }

    private void setFinalRootNodeText() {
        Object[] objectArray;
        String string;
        String string2;
        assert (EventQueue.isDispatchThread());
        int n = this.resultModel.size();
        if (this.resultModel.wasLimitReached()) {
            this.setRootDisplayName(NbBundle.getMessage(ResultView.class, (String)"TEXT_MSG_FOUND_X_NODES_LIMIT", (Object)new Integer(n)));
            return;
        }
        if (n == 0) {
            string2 = NbBundle.getMessage(ResultView.class, (String)"TEXT_MSG_NO_NODE_FOUND");
        } else {
            if (this.resultModel.searchAndReplace) {
                string = "TEXT_MSG_FOUND_X_NODES_REPLACE";
                objectArray = new Object[4];
            } else if (this.resultModel.fullTextOnly) {
                string = "TEXT_MSG_FOUND_X_NODES_FULLTEXT";
                objectArray = new Object[2];
            } else {
                string = "TEXT_MSG_FOUND_X_NODES";
                objectArray = new Object[]{new Integer(this.objectsCount)};
            }
            if (objectArray.length > 1) {
                objectArray[1] = new Integer(this.resultModel.getTotalDetailsCount());
            }
            if (objectArray.length > 2) {
                objectArray[2] = this.resultModel.fullTextSearchType.getMatchTemplateDescr();
                objectArray[3] = this.resultModel.fullTextSearchType.getReplaceString();
            }
            string2 = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)string, (Object[])objectArray);
        }
        string = this.resultModel.getExceptionMsg();
        objectArray = string == null ? string2 : string2 + " (" + string + ")";
        this.setRootDisplayName((String)objectArray);
    }

    private void updateShowAllDetailsBtn() {
        assert (EventQueue.isDispatchThread());
        this.btnShowDetails.setEnabled(this.hasResults && !this.searchInProgress && this.hasDetails);
    }

    void setResultModel(ResultModel resultModel) {
        assert (EventQueue.isDispatchThread());
        if (this.resultModel == null && resultModel == null) {
            return;
        }
        boolean bl = this.resultModel != null && this.resultModel.searchAndReplace;
        boolean bl2 = resultModel != null && resultModel.searchAndReplace;
        this.resultModel = resultModel;
        this.treeModel = new ResultTreeModel(resultModel);
        this.tree.setModel(this.treeModel);
        if (bl2 != bl) {
            this.tree.setCellRenderer(new NodeRenderer(bl2));
            this.btnReplace.setVisible(bl2);
        }
        if (resultModel != null) {
            this.hasResults = !resultModel.isEmpty();
            this.hasDetails = this.hasResults && resultModel.hasDetails();
            resultModel.setObserver(this);
        } else {
            this.hasResults = false;
            this.hasDetails = false;
        }
        this.resultModelChanged();
        this.updateShowAllDetailsBtn();
    }

    private void resultModelChanged() {
        this.updateDisplayContextButton();
        this.updateContextViewVisibility();
        if (this.contextView != null) {
            this.contextView.setResultModel(this.resultModel);
        }
        this.nodeListener.setSelectionChangeEnabled(true);
        this.btnPrev.setEnabled(this.resultModel != null);
        this.btnNext.setEnabled(this.resultModel != null);
        this.resetMatchingObjIndexCache();
        this.objectsCount = 0;
    }

    private boolean isSearchAndReplace() {
        return this.resultModel != null && this.resultModel.searchAndReplace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDisplayContextButton() {
        boolean bl = this.isSearchAndReplace();
        this.btnDisplayContext.setEnabled(bl);
        this.ignoreContextButtonToggle = true;
        try {
            this.btnDisplayContext.setSelected(bl && this.contextViewEnabled);
        }
        finally {
            this.ignoreContextButtonToggle = false;
        }
    }

    private void updateContextViewVisibility() {
        this.setContextViewVisible(this.isSearchAndReplace() && this.contextViewEnabled);
    }

    private void setContextViewVisible(boolean bl) {
        String string;
        assert (EventQueue.isDispatchThread());
        assert (this.splitPane == null == (this.contextView == null));
        int n = this.resultsPanel.getComponentCount();
        if (bl == this.contextViewVisible && n != 0) {
            return;
        }
        this.contextViewVisible = bl;
        if (!bl) {
            string = "tree only";
            assert (n < 2);
            this.resultsPanel.add((Component)this.treeView, string);
            if (this.contextView != null) {
                this.contextView.unbindFromTreeSelection(this.tree);
                this.rememberDividerLocation();
            }
        } else {
            assert (this.resultModel != null);
            string = "tree and context";
            if (this.splitPane == null) {
                this.contextView = new ContextView(this.resultModel);
                this.splitPane = new JSplitPane(1, true, this.treeView, this.contextView);
                this.splitPane.setBorder(BorderFactory.createEmptyBorder());
                this.splitPane.setResizeWeight(0.4);
                this.resultsPanel.add((Component)this.splitPane, string);
            } else {
                this.splitPane.setLeftComponent(this.treeView);
            }
            this.setDividerLocation();
            this.contextView.bindToTreeSelection(this.tree);
        }
        this.resultViewCards.show(this.resultsPanel, string);
        this.treeView.setVisible(true);
    }

    private void rememberDividerLocation() {
        if (this.splitPane == null) {
            return;
        }
        this.dividerLocation = (double)this.splitPane.getDividerLocation() / (double)(this.splitPane.getWidth() - this.splitPane.getDividerSize());
    }

    private void setDividerLocation() {
        assert (this.splitPane != null);
        if (this.dividerLocation != -1.0) {
            this.splitPane.setDividerLocation(this.dividerLocation);
        }
    }

    void objectFound(Object object, final int n) {
        assert (!EventQueue.isDispatchThread());
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ResultView.this.updateObjectsCount(n);
            }
        });
    }

    private void updateObjectsCount(int n) {
        assert (EventQueue.isDispatchThread());
        ++this.objectsCount;
        this.hasResults = true;
        this.setRootDisplayName(this.resultModel.fullTextOnly ? this.nodeCountFormatFullText.format(new Object[]{new Integer(this.objectsCount), new Integer(n)}) : this.nodeCountFormat.format(new Object[]{new Integer(this.objectsCount)}));
    }

    void removeIssuesPanel() {
        if (this.issuesPanel != null) {
            this.remove(this.issuesPanel);
            this.issuesPanel = null;
        }
        this.contentCards.show((Container)((Object)this), RESULTS_CARD);
    }

    private void goToNext(boolean bl) {
        TreePath treePath;
        assert (EventQueue.isDispatchThread());
        assert (this.resultModel != null);
        if (!this.hasResults) {
            return;
        }
        TreePath treePath2 = this.tree.getLeadSelectionPath();
        if (treePath2 == null) {
            treePath2 = new TreePath(this.tree.getModel().getRoot());
        }
        if ((treePath = this.findNextPath(treePath2, bl)) != null) {
            this.tree.expandPath(treePath.getParentPath());
            this.tree.setSelectionPath(treePath);
            this.tree.scrollRectToVisible(this.tree.getPathBounds(treePath));
        }
    }

    private TreePath findNextPath(TreePath treePath, boolean bl) {
        TreePath treePath2;
        TreePath treePath3 = treePath.getParentPath();
        if (treePath3 == null) {
            Object object = treePath.getLastPathComponent();
            treePath2 = bl ? this.getNextDetail(object, null, -1, bl) : null;
        } else {
            Object object = treePath.getLastPathComponent();
            if (object.getClass() == MatchingObject.class) {
                Object object2 = treePath3.getLastPathComponent();
                MatchingObject matchingObject = (MatchingObject)object;
                treePath2 = this.getNextDetail(object2, matchingObject, -1, bl);
            } else {
                Object object3 = treePath3.getParentPath().getLastPathComponent();
                Object object4 = treePath3.getLastPathComponent();
                assert (object4.getClass() == MatchingObject.class);
                MatchingObject matchingObject = (MatchingObject)object4;
                int n = this.tree.getRowForPath(treePath3);
                int n2 = this.tree.getRowForPath(treePath);
                int n3 = n2 - n - 1;
                treePath2 = this.getNextDetail(object3, matchingObject, n3, bl);
            }
        }
        return treePath2;
    }

    private TreePath getNextDetail(Object object, MatchingObject matchingObject, int n, boolean bl) {
        if (matchingObject != null) {
            int n2;
            int n3 = n2 = bl ? n + 1 : n - 1;
            if (n2 >= 0 && n2 < this.resultModel.getDetailsCount(matchingObject)) {
                return new TreePath(new Object[]{object, matchingObject, this.resultModel.getDetails(matchingObject)[n2]});
            }
        } else if (!bl) {
            return null;
        }
        MatchingObject[] matchingObjectArray = this.resultModel.getMatchingObjects();
        int n4 = this.getMatchingObjIndex(matchingObjectArray, matchingObject, bl);
        if (bl) {
            for (int i = n4 + 1; i < matchingObjectArray.length; ++i) {
                MatchingObject matchingObject2 = matchingObjectArray[i];
                if (!this.resultModel.hasDetails(matchingObject2)) continue;
                return new TreePath(new Object[]{object, matchingObject2, this.resultModel.getDetails(matchingObject2)[0]});
            }
        } else {
            for (int i = n4 - 1; i >= 0; --i) {
                MatchingObject matchingObject3 = matchingObjectArray[i];
                if (!this.resultModel.hasDetails(matchingObject3)) continue;
                Node[] nodeArray = this.resultModel.getDetails(matchingObject3);
                return new TreePath(new Object[]{object, matchingObject3, nodeArray[nodeArray.length - 1]});
            }
        }
        return null;
    }

    private void resetMatchingObjIndexCache() {
        this.matchingObjIndexCacheObj = null;
        this.matchingObjIndexCacheIndex = -1;
    }

    private int getMatchingObjIndex(MatchingObject[] matchingObjectArray, MatchingObject matchingObject, boolean bl) {
        if (matchingObject == null) {
            return -1;
        }
        if (matchingObject == this.matchingObjIndexCacheObj) {
            assert (this.matchingObjIndexCacheIndex != -1);
            return this.matchingObjIndexCacheIndex;
        }
        int n = -1;
        if (this.matchingObjIndexCacheIndex != -1) {
            int n2;
            int n3;
            int n4;
            if (bl) {
                n4 = Math.min(this.matchingObjIndexCacheIndex + 1, matchingObjectArray.length - 1);
                n3 = Math.min(this.matchingObjIndexCacheIndex + 3, matchingObjectArray.length - 1);
                for (n2 = n4; n2 <= n3; ++n2) {
                    if (matchingObjectArray[n2] != matchingObject) continue;
                    n = n2;
                    break;
                }
                if (n == -1 && this.matchingObjIndexCacheIndex > 0 && matchingObjectArray[n2 = this.matchingObjIndexCacheIndex - 1] == matchingObject) {
                    n = n2;
                }
            } else {
                n4 = Math.max(this.matchingObjIndexCacheIndex - 1, 0);
                n3 = Math.max(this.matchingObjIndexCacheIndex - 3, 0);
                for (n2 = n4; n2 >= n3; --n2) {
                    if (matchingObjectArray[n2] != matchingObject) continue;
                    n = n2;
                    break;
                }
                if (n == -1 && this.matchingObjIndexCacheIndex < matchingObjectArray.length - 1 && matchingObjectArray[n2 = this.matchingObjIndexCacheIndex + 1] == matchingObject) {
                    n = n2;
                }
            }
        }
        if (n == -1) {
            for (int i = 0; i < matchingObjectArray.length; ++i) {
                if (matchingObject != matchingObjectArray[i]) continue;
                n = i;
                break;
            }
        }
        if (n != -1) {
            this.matchingObjIndexCacheObj = matchingObject;
            this.matchingObjIndexCacheIndex = n;
        }
        return n;
    }

    void rememberInput(Node[] nodeArray, List list) {
        this.lastSearchNodes = nodeArray;
        this.lastEnabledSearchTypes = list;
    }

    private void customizeCriteria() {
        assert (EventQueue.isDispatchThread());
        assert (this.lastSearchNodes != null);
        Node[] nodeArray = this.lastSearchNodes;
        List list = this.lastEnabledSearchTypes;
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        Object object = list.iterator();
        while (object.hasNext()) {
            arrayList.add(((SearchType)object.next()).clone());
        }
        this.lastEnabledSearchTypes = arrayList;
        object = new SearchPanel(arrayList, true);
        ((SearchPanel)object).showDialog();
        if (((SearchPanel)object).getReturnStatus() != 1) {
            return;
        }
        this.rememberInput(nodeArray, Utils.cloneSearchTypes(arrayList));
        Manager.getInstance().scheduleSearchTask(new SearchTask(nodeArray, arrayList, ((SearchPanel)object).getCustomizedSearchTypes()));
    }

    private void replaceMatches() {
        assert (EventQueue.isDispatchThread());
        this.nodeListener.setSelectionChangeEnabled(false);
        this.btnReplace.setEnabled(false);
        Manager.getInstance().scheduleReplaceTask(new ReplaceTask(this.resultModel.getMatchingObjects()));
    }

    void closeAndSendFocusToEditor() {
        TopComponent topComponent;
        assert (EventQueue.isDispatchThread());
        this.close();
        Mode mode = WindowManager.getDefault().findMode("editor");
        if (mode != null && (topComponent = mode.getSelectedTopComponent()) != null) {
            topComponent.requestActive();
        }
    }

    void displayIssuesToUser(String string, String[] stringArray, boolean bl) {
        assert (EventQueue.isDispatchThread());
        assert (this.issuesPanel == null);
        this.issuesPanel = new IssuesPanel(string, stringArray);
        this.add(this.issuesPanel, ISSUES_CARD);
        this.contentCards.show((Container)((Object)this), ISSUES_CARD);
        if (!this.isOpened()) {
            this.open();
        }
        if (bl) {
            this.requestAttention(true);
        }
    }

    void rescan() {
        assert (EventQueue.isDispatchThread());
        this.removeIssuesPanel();
        Manager.getInstance().scheduleSearchTaskRerun();
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private class ButtonListener
    implements ActionListener,
    ItemListener {
        private ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == ResultView.this.btnStop) {
                Manager.getInstance().stopSearching();
            } else if (object == ResultView.this.btnModifySearch) {
                ResultView.this.customizeCriteria();
            } else if (object == ResultView.this.btnShowDetails) {
                ResultView.this.fillOutput();
            } else if (object == ResultView.this.btnReplace) {
                ResultView.this.replaceMatches();
            } else if (object == ResultView.this.btnPrev) {
                ResultView.this.goToNext(false);
            } else if (object == ResultView.this.btnNext) {
                ResultView.this.goToNext(true);
            } else assert (false);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            assert (itemEvent.getSource() == ResultView.this.btnDisplayContext);
            if (!ResultView.this.ignoreContextButtonToggle) {
                ResultView.this.contextViewEnabled = itemEvent.getStateChange() == 1;
                ResultView.this.updateContextViewVisibility();
            }
        }
    }

    public static final class ResolvableHelper
    implements Serializable {
        static final long serialVersionUID = 7398708142639457544L;

        public Object readResolve() {
            return ResultView.getDefault();
        }
    }
}

