/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.types.FullTextType;
import org.openide.LifecycleManager;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openidex.search.SearchGroup;
import org.openidex.search.SearchType;

final class SearchTask
implements Runnable,
Cancellable {
    private final Node[] nodes;
    private final SearchType[] customizedSearchTypes;
    private final List searchTypeList;
    private ResultModel resultModel;
    private SearchGroup searchGroup;
    private PropertyChangeListener searchGroupListener;
    private boolean notifyWhenFinished = true;
    private volatile boolean interrupted = false;
    private volatile boolean finished = false;
    private final String replaceString;

    public SearchTask(Node[] nodeArray, List list, SearchType[] searchTypeArray) {
        this.nodes = nodeArray;
        this.searchTypeList = list;
        this.customizedSearchTypes = searchTypeArray;
        this.replaceString = SearchTask.getReplaceString(searchTypeArray);
    }

    private static String getReplaceString(SearchType[] searchTypeArray) {
        for (SearchType searchType : searchTypeArray) {
            if (searchType.getClass() != FullTextType.class) continue;
            return ((FullTextType)searchType).getReplaceString();
        }
        return null;
    }

    private boolean isSearchAndReplace() {
        return this.replaceString != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.isSearchAndReplace()) {
            LifecycleManager.getDefault().saveAll();
        }
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ResultView.class, (String)"TEXT_SEARCHING___"), (Cancellable)this);
        progressHandle.start();
        this.ensureResultModelExists();
        if (this.searchGroup == null) {
            return;
        }
        this.searchGroupListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("org.openidex.search.found".equals(propertyChangeEvent.getPropertyName())) {
                    SearchTask.this.matchingObjectFound(propertyChangeEvent.getNewValue());
                }
            }
        };
        this.searchGroup.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.searchGroupListener, (Object)this.searchGroup));
        this.searchGroup.setSearchRootNodes(this.nodes);
        try {
            this.searchGroup.search();
        }
        catch (RuntimeException runtimeException) {
            this.resultModel.searchException(runtimeException);
            runtimeException.printStackTrace();
        }
        finally {
            this.finished = true;
            progressHandle.finish();
        }
    }

    SearchTask createNewGeneration() {
        return new SearchTask(this.nodes, this.searchTypeList, this.customizedSearchTypes);
    }

    ResultModel getResultModel() {
        this.ensureResultModelExists();
        return this.resultModel;
    }

    private void ensureResultModelExists() {
        if (this.resultModel == null) {
            SearchGroup[] searchGroupArray = SearchGroup.createSearchGroups((SearchType[])this.customizedSearchTypes);
            this.searchGroup = searchGroupArray.length != 0 ? searchGroupArray[0] : null;
            this.resultModel = new ResultModel(this.searchTypeList, this.searchGroup, this.replaceString);
        }
    }

    private void matchingObjectFound(Object object) {
        boolean bl = this.resultModel.objectFound(object);
        if (!bl) {
            this.searchGroup.stopSearch();
        }
    }

    void stop(boolean bl) {
        if (!bl) {
            this.notifyWhenFinished = bl;
        }
        this.stop();
    }

    void stop() {
        if (!this.finished) {
            this.interrupted = true;
        }
        if (this.searchGroup != null) {
            this.searchGroup.stopSearch();
        }
    }

    public boolean cancel() {
        this.stop();
        return true;
    }

    boolean notifyWhenFinished() {
        return this.notifyWhenFinished;
    }

    boolean wasInterrupted() {
        return this.interrupted;
    }
}

