/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import org.netbeans.modules.search.Item;
import org.netbeans.modules.search.TextDisplayer;
import org.netbeans.modules.search.types.TextDetail;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

final class TextFetcher
implements Runnable {
    private final Item source;
    private final TextDisplayer textDisplayer;
    private final RequestProcessor.Task task;
    private TextDetail location;
    private boolean done = false;
    private boolean cancelled = false;
    private volatile String text = null;

    TextFetcher(Item item, TextDisplayer textDisplayer, RequestProcessor requestProcessor) {
        assert (EventQueue.isDispatchThread());
        this.source = item;
        this.textDisplayer = textDisplayer;
        this.location = item.getLocation();
        this.task = requestProcessor.post((Runnable)this, 50);
    }

    void cancel() {
        assert (EventQueue.isDispatchThread());
        this.cancelled = true;
        this.task.cancel();
    }

    public void run() {
        if (EventQueue.isDispatchThread()) {
            if (this.cancelled) {
                return;
            }
            FileObject fileObject = FileUtil.toFileObject((File)this.source.matchingObj.getFile());
            String string = fileObject.getMIMEType();
            if ("text/html".equals(string)) {
                string = "text/plain";
            }
            this.textDisplayer.setText(this.text, fileObject.getMIMEType(), this.getLocation());
            this.done = true;
        } else {
            if (Thread.interrupted()) {
                return;
            }
            String string = this.source.matchingObj.getInvalidityDescription();
            if (string != null) {
                this.text = string;
            } else {
                try {
                    this.text = this.source.matchingObj.getText();
                }
                catch (ClosedByInterruptException closedByInterruptException) {
                    this.cancelled = true;
                    return;
                }
                catch (IOException iOException) {
                    this.text = iOException.getLocalizedMessage();
                }
            }
            if (Thread.interrupted()) {
                return;
            }
            EventQueue.invokeLater(this);
        }
    }

    boolean replaceLocation(Item item, TextDisplayer textDisplayer) {
        assert (EventQueue.isDispatchThread());
        if (this.done || textDisplayer != this.textDisplayer) {
            return false;
        }
        boolean bl = this.source.matchingObj.getFile().equals(item.matchingObj.getFile());
        if (bl) {
            this.setLocation(item.getLocation());
            this.task.schedule(50);
        }
        return bl;
    }

    private synchronized void setLocation(TextDetail textDetail) {
        assert (EventQueue.isDispatchThread());
        this.location = textDetail;
    }

    private synchronized TextDetail getLocation() {
        assert (EventQueue.isDispatchThread());
        return this.location;
    }
}

