/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.types;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.search.DialogLifetime;
import org.netbeans.modules.search.FindDialogMemory;
import org.netbeans.modules.search.types.TextType;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openidex.search.SearchPattern;

public abstract class TextCustomizer
extends JPanel
implements Customizer,
DialogLifetime,
ItemListener,
KeyListener {
    private final JComboBox substringComboBox = new JComboBox();
    private final JCheckBox caseSensitiveCheckBox = new JCheckBox();
    private final JCheckBox regexpCheckBox = new JCheckBox();
    private final JCheckBox wholeWordsCheckBox = new JCheckBox();
    private final JPanel contentPanel = new JPanel();
    private int replacePanelIndex = -1;
    private boolean replacePanelPresent = false;
    protected TextType peer;

    public TextCustomizer() {
        this.initComponents();
        this.initAccessibility();
        this.initTextFieldListeners();
        TitledBorder titledBorder = new TitledBorder(this.getBorderLabel());
        titledBorder.setBorder(new CompoundBorder());
        this.setBorder(titledBorder);
        this.initHistory();
    }

    protected String getBorderLabel() {
        return null;
    }

    private void initAccessibility() {
        ResourceBundle resourceBundle = NbBundle.getBundle(TextCustomizer.class);
        this.substringComboBox.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_PROP_SUBSTRING"));
        this.substringComboBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_PROP_SUBSTRING"));
        this.caseSensitiveCheckBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_TEXT_LABEL_CASE_SENSITIVE"));
        this.wholeWordsCheckBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_TEXT_LABEL_WHOLE_WORDS"));
        this.regexpCheckBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_TEXT_LABEL_RE"));
    }

    private void initTextFieldListeners() {
        class TextChangeListener
        implements DocumentListener {
            private JTextField textField;

            TextChangeListener(JTextField jTextField) {
                this.textField = jTextField;
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.documentChanged();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.documentChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.documentChanged();
            }

            private void documentChanged() {
                TextCustomizer.this.stringChanged();
            }
        }
        ((JTextField)this.substringComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(new TextChangeListener((JTextField)this.substringComboBox.getEditor().getEditorComponent()));
    }

    private void initHistory() {
        List list = this.getSearchPatterns();
        if (!list.isEmpty()) {
            HashSet<String> hashSet = new HashSet<String>(list.size());
            Vector<String> vector = new Vector<String>(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = ((SearchPattern)iterator.next()).getSearchExpression();
                if (!hashSet.add(string)) continue;
                vector.add(string);
            }
            this.substringComboBox.setModel(new DefaultComboBoxModel(vector));
            this.substringComboBox.setSelectedIndex(-1);
        }
    }

    public void initFromHistory() {
        Object e = this.getSearchPatterns().get(0);
        if (e != null) {
            this.putCurrentSearchPattern((SearchPattern)e);
        }
    }

    private void initComponents() {
        this.substringComboBox.setEditable(true);
        this.substringComboBox.addItemListener(this);
        this.activateEnterKeyBypass(this.substringComboBox);
        Mnemonics.setLocalizedText((AbstractButton)this.wholeWordsCheckBox, (String)NbBundle.getMessage(TextCustomizer.class, (String)"TEXT_LABEL_WHOLE_WORDS"));
        this.wholeWordsCheckBox.setBorder(null);
        this.wholeWordsCheckBox.addItemListener(this);
        Mnemonics.setLocalizedText((AbstractButton)this.caseSensitiveCheckBox, (String)NbBundle.getMessage(TextCustomizer.class, (String)"TEXT_LABEL_CASE_SENSITIVE"));
        this.caseSensitiveCheckBox.setBorder(null);
        this.caseSensitiveCheckBox.addItemListener(this);
        Mnemonics.setLocalizedText((AbstractButton)this.regexpCheckBox, (String)NbBundle.getMessage(TextCustomizer.class, (String)"TEXT_LABEL_RE"));
        this.regexpCheckBox.setBorder(null);
        this.regexpCheckBox.addItemListener(this);
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 2));
        jPanel.add(this.wholeWordsCheckBox);
        jPanel.add(this.caseSensitiveCheckBox);
        jPanel.add(this.regexpCheckBox);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0));
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.contentPanel.add(this.substringComboBox);
        this.contentPanel.add(Box.createVerticalStrut(6));
        this.replacePanelIndex = this.contentPanel.getComponentCount();
        this.contentPanel.add(jPanel);
        this.substringComboBox.setAlignmentX(0.0f);
        jPanel.setAlignmentX(0.0f);
        this.setLayout(new BorderLayout());
        this.add((Component)this.contentPanel, "North");
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 0, 6));
    }

    protected void addReplacePanel(Box box) {
        if (this.replacePanelPresent) {
            throw new IllegalStateException();
        }
        this.replacePanelPresent = true;
        assert (this.replacePanelIndex >= 0);
        int n = this.replacePanelIndex;
        for (Component component : box.getComponents()) {
            this.contentPanel.add(component, n++);
            if (!(component instanceof JComponent)) continue;
            ((JComponent)component).setAlignmentX(0.0f);
        }
        this.contentPanel.add(Box.createVerticalStrut(6), n);
    }

    protected void activateEnterKeyBypass(JComboBox jComboBox) {
        Component component = jComboBox.getEditor().getEditorComponent();
        if (!(component instanceof JTextField)) {
            assert (false);
            return;
        }
        ((JTextField)component).addKeyListener(this);
    }

    public void keyPressed(KeyEvent keyEvent) {
        JButton jButton;
        JRootPane jRootPane;
        if (keyEvent.getKeyCode() == 10 && keyEvent.getModifiersEx() == 0 && (jRootPane = SwingUtilities.getRootPane(this)) != null && (jButton = jRootPane.getDefaultButton()) != null && jButton.isEnabled()) {
            keyEvent.consume();
            jButton.doClick();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    protected String getComboText(JComboBox jComboBox) {
        return ((JTextField)jComboBox.getEditor().getEditorComponent()).getText();
    }

    private void regexpChkBoxChanged() {
        this.enableUI();
        if (this.peer == null) {
            return;
        }
        String string = this.getComboText(this.substringComboBox);
        if (string == null || string.length() == 0) {
            return;
        }
        if (!this.regexpCheckBox.isSelected()) {
            this.peer.setMatchString(string);
            this.substringComboBox.getEditor().getEditorComponent().setForeground(this.getForegroundColor());
        } else {
            try {
                this.peer.setRe(string);
                this.substringComboBox.getEditor().getEditorComponent().setForeground(this.getForegroundColor());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.substringComboBox.getEditor().getEditorComponent().setForeground(this.getErrorForegroundColor());
            }
        }
    }

    private void stringChanged() {
        if (this.peer == null) {
            return;
        }
        String string = this.getComboText(this.substringComboBox);
        if (!this.regexpCheckBox.isSelected()) {
            this.peer.setMatchString(string);
            this.substringComboBox.getEditor().getEditorComponent().setForeground(this.getForegroundColor());
        } else {
            try {
                this.peer.setRe(string);
                this.substringComboBox.getEditor().getEditorComponent().setForeground(this.getForegroundColor());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.substringComboBox.getEditor().getEditorComponent().setForeground(this.getErrorForegroundColor());
            }
        }
    }

    public void setObject(Object object) {
        this.peer = (TextType)((Object)object);
        this.substringComboBox.setForeground(this.getForegroundColor());
        Boolean bl = null;
        String string = this.peer.getRe();
        if (string.length() != 0) {
            bl = Boolean.TRUE;
        } else {
            string = this.peer.getMatchString();
            if (string.length() != 0) {
                bl = Boolean.FALSE;
            } else {
                string = this.getComboText(this.substringComboBox);
            }
        }
        if (bl != null) {
            this.substringComboBox.setSelectedItem(string);
            this.regexpCheckBox.setSelected(bl);
            this.caseSensitiveCheckBox.setSelected(this.peer.isCaseSensitive());
            this.wholeWordsCheckBox.setSelected(this.peer.getWholeWords());
        } else if (string != null && string.length() != 0) {
            this.stringChanged();
        }
        this.enableUI();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void requestFocus() {
        JTextField jTextField = (JTextField)this.substringComboBox.getEditor().getEditorComponent();
        int n = jTextField.getText().length();
        if (n > 0) {
            jTextField.setCaretPosition(0);
            jTextField.moveCaretPosition(n);
        }
        jTextField.requestFocus();
    }

    private Color findColor(String string, Color color) {
        Color color2 = UIManager.getDefaults().getColor(string);
        if (color2 != null) {
            return color2;
        }
        return color;
    }

    private Color getForegroundColor() {
        return this.findColor("TextField.foreground", Color.black);
    }

    private Color getErrorForegroundColor() {
        return this.findColor("TextField.errorForeground", Color.red);
    }

    private void enableUI() {
        boolean bl = this.regexpCheckBox.isSelected();
        this.regexpCheckBox.setEnabled(true);
        this.caseSensitiveCheckBox.setEnabled(!bl);
        this.wholeWordsCheckBox.setEnabled(!bl);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.substringComboBox) {
            this.stringChanged();
        } else if (object == this.wholeWordsCheckBox) {
            this.peer.setWholeWords(this.wholeWordsCheckBox.isSelected());
        } else if (object == this.caseSensitiveCheckBox) {
            this.peer.setCaseSensitive(this.caseSensitiveCheckBox.isSelected());
        } else if (object == this.regexpCheckBox) {
            this.regexpChkBoxChanged();
        } else assert (false);
    }

    private SearchPattern getCurrentSearchPattern() {
        return SearchPattern.create((String)this.getComboText(this.substringComboBox), (boolean)this.wholeWordsCheckBox.isSelected(), (boolean)this.caseSensitiveCheckBox.isSelected(), (boolean)this.regexpCheckBox.isSelected());
    }

    private void putCurrentSearchPattern(SearchPattern searchPattern) {
        assert (searchPattern != null);
        this.substringComboBox.setSelectedItem(searchPattern.getSearchExpression());
        this.wholeWordsCheckBox.setSelected(searchPattern.isWholeWords());
        this.caseSensitiveCheckBox.setSelected(searchPattern.isMatchCase());
        this.regexpCheckBox.setSelected(searchPattern.isRegExp());
        this.enableUI();
    }

    private void initCheckBoxes(SearchPattern searchPattern) {
        this.wholeWordsCheckBox.setSelected(searchPattern.isWholeWords());
        this.caseSensitiveCheckBox.setSelected(searchPattern.isMatchCase());
        this.regexpCheckBox.setSelected(searchPattern.isRegExp());
        this.enableUI();
    }

    protected abstract List getSearchPatterns();

    protected abstract void addSearchPattern(SearchPattern var1);

    public void onOk() {
        SearchPattern searchPattern = this.getCurrentSearchPattern();
        if (searchPattern != null) {
            this.addSearchPattern(searchPattern);
            String string = searchPattern.getSearchExpression();
            if (string != null && string.length() != 0) {
                FindDialogMemory.getDefault().setSearchTypeUsed(((Object)((Object)this.peer)).getClass().getName(), true);
            }
        }
    }

    public void onCancel() {
    }
}

