/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.types;

import java.awt.Toolkit;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openidex.search.SearchHistory;
import org.openidex.search.SearchPattern;

public class TextDetail {
    public static final int DH_SHOW = 1;
    public static final int DH_GOTO = 2;
    public static final int DH_HIDE = 3;
    private DataObject dobj;
    private int line;
    private String lineText;
    private int column;
    private int markLength;
    private Line lineObj;
    private SearchPattern searchPattern;

    public TextDetail(DataObject dataObject, SearchPattern searchPattern) {
        this.dobj = dataObject;
        this.searchPattern = searchPattern;
    }

    public void showDetail(int n) {
        JEditorPane[] jEditorPaneArray;
        LineCookie lineCookie;
        if (this.dobj == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (this.lineObj == null) {
            lineCookie = (LineCookie)this.dobj.getCookie(LineCookie.class);
            if (lineCookie != null) {
                jEditorPaneArray = lineCookie.getLineSet();
                try {
                    this.lineObj = jEditorPaneArray.getOriginal(this.line - 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    this.lineObj = jEditorPaneArray.getOriginal(TextDetail.findMaxLine((Line.Set)jEditorPaneArray));
                    this.markLength = 0;
                    this.column = 0;
                }
            }
            if (this.lineObj == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
        }
        if (n == 3) {
            return;
        }
        lineCookie = (EditorCookie)this.dobj.getCookie(EditorCookie.class);
        if (lineCookie != null) {
            lineCookie.open();
        }
        if (n == 1) {
            this.lineObj.show(0, this.column - 1);
        } else if (n == 2) {
            this.lineObj.show(2, this.column - 1);
        }
        if (this.markLength > 0 && lineCookie != null && (jEditorPaneArray = lineCookie.getOpenedPanes()) != null && jEditorPaneArray.length > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Caret caret = jEditorPaneArray[0].getCaret();
                    caret.moveDot(caret.getDot() + TextDetail.this.markLength);
                }
            });
        }
        SearchHistory.getDefault().setLastSelected(this.searchPattern);
    }

    public String getLineText() {
        return this.lineText;
    }

    public void setLineText(String string) {
        this.lineText = string;
    }

    public DataObject getDataObject() {
        return this.dobj;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int n) {
        this.line = n;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int n) {
        this.column = n;
    }

    public void setMarkLength(int n) {
        this.markLength = n;
    }

    public int getMarkLength() {
        return this.markLength;
    }

    private static int findMaxLine(Line.Set set) {
        int n = 0;
        int n2 = 32000;
        try {
            while (true) {
                set.getOriginal(n2);
                n = n2;
                n2 *= 2;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            while (n < n2) {
                int n3 = (n + n2 + 1) / 2;
                try {
                    set.getOriginal(n3);
                    n = n3;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException2) {
                    n2 = n3 - 1;
                }
            }
            return n;
        }
    }
}

