/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.types;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.modules.search.types.DataObjectType;

public abstract class TextType
extends DataObjectType {
    private static final long serialVersionUID = 3L;
    private static final String WORD_SEPARATORS = " \t,;.:+-*/\\()[]{}<>=&|\"'`~!?@#%^\n\r";
    protected boolean caseSensitive;
    protected boolean wholeWords;
    protected transient String ciMatchString;
    protected String matchString;
    protected String reString;
    protected transient Pattern pattern;
    private transient Matcher matcher;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (!this.caseSensitive && this.matchString != null) {
            this.ciMatchString = this.matchString.toUpperCase();
        }
        if (this.reString != null) {
            this.setRe(this.reString);
        }
    }

    protected boolean match(String string) {
        if (this.matchString != null) {
            int n;
            if (string.length() < this.matchString.length()) {
                return false;
            }
            if (!this.caseSensitive) {
                string = string.toUpperCase();
            }
            int n2 = 1;
            int n3 = string.length() - this.matchString.length() + 1;
            do {
                n = this.matchString(string, n2);
                n2 = Math.abs(n) + 1;
            } while (n < 0 && n2 <= n3);
            return n > 0;
        }
        return this.matchRE(string);
    }

    protected boolean matchRE(String string) {
        this.matcher = this.pattern.matcher(string);
        return this.matcher.find();
    }

    protected Matcher getMatcher() {
        return this.matcher;
    }

    protected int matchString(String string, int n) {
        int n2;
        assert (n >= 1);
        int n3 = string.indexOf(this.caseSensitive ? this.matchString : this.ciMatchString, n - 1);
        int n4 = n3 + 1;
        if (this.wholeWords && n4 != 0 && ((n2 = n3 - 1) >= 0 && WORD_SEPARATORS.indexOf(string.charAt(n2)) < 0 || (n2 = n3 + this.matchString.length()) < string.length() && WORD_SEPARATORS.indexOf(string.charAt(n2)) < 0)) {
            n4 = -n4;
        }
        return n4;
    }

    public String getMatchString() {
        if (this.matchString == null) {
            return "";
        }
        return this.matchString;
    }

    public void setMatchString(String string) {
        if (string == null) {
            this.setValid(false);
            throw new IllegalArgumentException();
        }
        if (string.length() == 0) {
            string = null;
        } else if (!this.caseSensitive) {
            this.ciMatchString = string.toUpperCase();
        }
        this.matchString = string;
        this.pattern = null;
        this.reString = null;
        this.setValid(string != null);
    }

    public String getRe() {
        if (this.reString == null) {
            return "";
        }
        return this.reString;
    }

    public String getMatchTemplateDescr() {
        return this.matchString != null ? this.matchString : this.reString;
    }

    public Pattern getSearchPattern() {
        if (this.pattern == null) {
            String string;
            assert (this.matchString != null);
            String string2 = TextType.quoteString(this.matchString);
            if (!this.wholeWords) {
                string = string2;
            } else {
                StringBuilder stringBuilder = new StringBuilder(string2.length() + 6);
                if (this.wholeWords) {
                    stringBuilder.append("\\b");
                }
                stringBuilder.append(string2);
                if (this.wholeWords) {
                    stringBuilder.append("\\b");
                }
                string = stringBuilder.toString();
            }
            int n = 64;
            if (!this.caseSensitive) {
                n |= 2;
            }
            this.pattern = Pattern.compile(string, n);
        }
        return this.pattern;
    }

    private static String quoteString(String string) {
        StringBuilder stringBuilder;
        if (string.length() == 0) {
            return string;
        }
        int n = 0;
        int n2 = string.indexOf(92);
        if (n2 == -1) {
            stringBuilder = new StringBuilder(string.length() + 4);
            stringBuilder.append("\\Q").append(string).append("\\E");
        } else {
            stringBuilder = new StringBuilder(string.length() + 16);
            do {
                if (n2 != n) {
                    stringBuilder.append("\\Q");
                    stringBuilder.append(string.substring(n, n2));
                    stringBuilder.append("\\E");
                }
                stringBuilder.append('\\').append('\\');
            } while ((n2 = string.indexOf(92, n = n2 + 1)) != -1);
            if (n != string.length()) {
                stringBuilder.append("\\Q");
                stringBuilder.append(string.substring(n));
                stringBuilder.append("\\E");
            }
        }
        return stringBuilder.toString();
    }

    public void setRe(String string) {
        this.setReImpl(string);
    }

    private void setReImpl(String string) {
        if (string == null) {
            this.setValid(false);
            throw new IllegalArgumentException();
        }
        if (string.length() == 0) {
            string = null;
        } else {
            try {
                this.pattern = Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.setValid(false);
                throw new IllegalArgumentException();
            }
        }
        this.reString = string;
        this.matchString = null;
        this.setValid(string != null);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        if (bl == this.caseSensitive) {
            return;
        }
        this.caseSensitive = bl;
        if (this.matchString != null) {
            this.ciMatchString = bl ? null : this.matchString.toUpperCase();
        }
    }

    public boolean getWholeWords() {
        return this.wholeWords;
    }

    public void setWholeWords(boolean bl) {
        if (bl == this.wholeWords) {
            return;
        }
        this.wholeWords = bl;
    }
}

