/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.guards;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.api.editor.guards.InteriorSection;
import org.netbeans.api.editor.guards.SimpleSection;
import org.netbeans.modules.editor.guards.GuardedPositionComparator;
import org.netbeans.modules.editor.guards.GuardedReader;
import org.netbeans.modules.editor.guards.GuardedSectionImpl;
import org.netbeans.modules.editor.guards.GuardedWriter;
import org.netbeans.modules.editor.guards.GuardsAccessor;
import org.netbeans.modules.editor.guards.InteriorSectionImpl;
import org.netbeans.modules.editor.guards.NewLine;
import org.netbeans.modules.editor.guards.PositionBounds;
import org.netbeans.modules.editor.guards.SimpleSectionImpl;
import org.netbeans.spi.editor.guards.GuardedEditorSupport;
import org.netbeans.spi.editor.guards.support.AbstractGuardedSectionsProvider;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GuardedSectionsImpl {
    Map<String, GuardedSectionImpl> sections = new HashMap<String, GuardedSectionImpl>(10);
    final GuardedEditorSupport editor;
    private NewLine newLineType;

    public GuardedSectionsImpl(GuardedEditorSupport guardedEditorSupport) {
        this.editor = guardedEditorSupport;
    }

    public Reader createGuardedReader(AbstractGuardedSectionsProvider abstractGuardedSectionsProvider, InputStream inputStream, String string) throws UnsupportedEncodingException {
        GuardedReader guardedReader = new GuardedReader(abstractGuardedSectionsProvider, inputStream, false, string, this);
        StyledDocument styledDocument = this.getDocument();
        if (styledDocument.getProperty(GuardedSectionManager.class) == null) {
            GuardedSectionManager guardedSectionManager = GuardsAccessor.DEFAULT.createGuardedSections(this);
            styledDocument.putProperty(GuardedSectionManager.class, guardedSectionManager);
        }
        return guardedReader;
    }

    public Writer createGuardedWriter(AbstractGuardedSectionsProvider abstractGuardedSectionsProvider, OutputStream outputStream, String string) throws UnsupportedEncodingException {
        Object object;
        NewLineOutputStream newLineOutputStream = new NewLineOutputStream(outputStream, this.newLineType);
        if (this.sections != null && (object = new ArrayList<GuardedSection>(this.getGuardedSections())).size() > 0) {
            GuardedWriter guardedWriter = new GuardedWriter(abstractGuardedSectionsProvider, newLineOutputStream, (List<GuardedSection>)object, string);
            return guardedWriter;
        }
        object = string == null ? new OutputStreamWriter(newLineOutputStream) : new OutputStreamWriter((OutputStream)newLineOutputStream, string);
        return object;
    }

    public StyledDocument getDocument() {
        return this.editor.getDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GuardedSection findSection(String string) {
        StyledDocument styledDocument = this.editor.getDocument();
        Map<String, GuardedSectionImpl> map = this.sections;
        synchronized (map) {
            GuardedSectionImpl guardedSectionImpl = this.sections.get(string);
            if (guardedSectionImpl != null) {
                return guardedSectionImpl.guard;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<GuardedSection> getGuardedSections() {
        StyledDocument styledDocument = this.editor.getDocument();
        Map<String, GuardedSectionImpl> map = this.sections;
        synchronized (map) {
            TreeSet<GuardedSection> treeSet = new TreeSet<GuardedSection>(new GuardedPositionComparator());
            for (GuardedSectionImpl guardedSectionImpl : this.sections.values()) {
                treeSet.add(guardedSectionImpl.guard);
            }
            return treeSet;
        }
    }

    public SimpleSection createSimpleSectionObject(String string, PositionBounds positionBounds) {
        return (SimpleSection)this.createSimpleSectionImpl((String)string, (PositionBounds)positionBounds).guard;
    }

    public InteriorSection createInteriorSectionObject(String string, PositionBounds positionBounds, PositionBounds positionBounds2, PositionBounds positionBounds3) {
        return (InteriorSection)this.createInteriorSectionImpl((String)string, (PositionBounds)positionBounds, (PositionBounds)positionBounds2, (PositionBounds)positionBounds3).guard;
    }

    public SimpleSection createSimpleSection(Position position, String string) throws BadLocationException {
        this.checkNewSection(position, string);
        return this.doCreateSimpleSection(position, string);
    }

    public InteriorSection createInteriorSection(Position position, String string) throws BadLocationException {
        this.checkNewSection(position, string);
        return this.doCreateInteriorSection(position, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleSection doCreateSimpleSection(final Position position, final String string) throws BadLocationException {
        StyledDocument styledDocument = null;
        final StyledDocument styledDocument2 = styledDocument = this.editor.getDocument();
        final SimpleSectionImpl[] simpleSectionImplArray = new SimpleSectionImpl[1];
        final BadLocationException[] badLocationExceptionArray = new BadLocationException[1];
        NbDocument.runAtomic((StyledDocument)styledDocument2, (Runnable)new Runnable(){

            public void run() {
                try {
                    int n = position.getOffset();
                    styledDocument2.insertString(n, "\n \n", null);
                    simpleSectionImplArray[0] = GuardedSectionsImpl.this.createSimpleSectionImpl(string, PositionBounds.create(n + 1, n + 2, GuardedSectionsImpl.this));
                    simpleSectionImplArray[0].markGuarded(styledDocument2);
                }
                catch (BadLocationException badLocationException) {
                    badLocationExceptionArray[0] = badLocationException;
                }
            }
        });
        if (badLocationExceptionArray[0] == null) {
            Map<String, GuardedSectionImpl> map = this.sections;
            synchronized (map) {
                this.sections.put(string, simpleSectionImplArray[0]);
                return (SimpleSection)simpleSectionImplArray[0].guard;
            }
        }
        throw (BadLocationException)new BadLocationException("wrong offset", badLocationExceptionArray[0].offsetRequested()).initCause(badLocationExceptionArray[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InteriorSection doCreateInteriorSection(final Position position, final String string) throws IllegalArgumentException, BadLocationException {
        StyledDocument styledDocument = null;
        final StyledDocument styledDocument2 = styledDocument = this.editor.getDocument();
        final InteriorSectionImpl[] interiorSectionImplArray = new InteriorSectionImpl[1];
        final BadLocationException[] badLocationExceptionArray = new BadLocationException[1];
        NbDocument.runAtomic((StyledDocument)styledDocument2, (Runnable)new Runnable(){

            public void run() {
                try {
                    int n = position.getOffset();
                    styledDocument2.insertString(n, "\n \n \n \n", null);
                    interiorSectionImplArray[0] = GuardedSectionsImpl.this.createInteriorSectionImpl(string, PositionBounds.create(n + 1, n + 2, GuardedSectionsImpl.this), PositionBounds.createBodyBounds(n + 3, n + 4, GuardedSectionsImpl.this), PositionBounds.create(n + 5, n + 6, GuardedSectionsImpl.this));
                    GuardedSectionsImpl.this.sections.put(interiorSectionImplArray[0].getName(), interiorSectionImplArray[0]);
                    interiorSectionImplArray[0].markGuarded(styledDocument2);
                }
                catch (BadLocationException badLocationException) {
                    badLocationExceptionArray[0] = badLocationException;
                }
            }
        });
        if (badLocationExceptionArray[0] == null) {
            Map<String, GuardedSectionImpl> map = this.sections;
            synchronized (map) {
                this.sections.put(string, interiorSectionImplArray[0]);
                return (InteriorSection)interiorSectionImplArray[0].guard;
            }
        }
        throw (BadLocationException)new BadLocationException("wrong offset", badLocationExceptionArray[0].offsetRequested()).initCause(badLocationExceptionArray[0]);
    }

    void fillSections(List<GuardedSection> list, NewLine newLine) {
        this.newLineType = newLine;
        this.sections.clear();
        for (GuardedSection guardedSection : list) {
            try {
                GuardedSectionImpl guardedSectionImpl = GuardsAccessor.DEFAULT.getImpl(guardedSection);
                guardedSectionImpl.resolvePositions();
                this.sections.put(guardedSection.getName(), guardedSectionImpl);
                StyledDocument styledDocument = this.getDocument();
                guardedSectionImpl.markGuarded(styledDocument);
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger(GuardedSectionsImpl.class.getName()).log(Level.SEVERE, badLocationException.getLocalizedMessage(), badLocationException);
            }
        }
    }

    private SimpleSectionImpl createSimpleSectionImpl(String string, PositionBounds positionBounds) {
        SimpleSectionImpl simpleSectionImpl = new SimpleSectionImpl(string, positionBounds, this);
        GuardsAccessor.DEFAULT.createSimpleSection(simpleSectionImpl);
        return simpleSectionImpl;
    }

    private InteriorSectionImpl createInteriorSectionImpl(String string, PositionBounds positionBounds, PositionBounds positionBounds2, PositionBounds positionBounds3) {
        InteriorSectionImpl interiorSectionImpl = new InteriorSectionImpl(string, positionBounds, positionBounds2, positionBounds3, this);
        GuardsAccessor.DEFAULT.createInteriorSection(interiorSectionImpl);
        return interiorSectionImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNewSection(Position position, String string) {
        Map<String, GuardedSectionImpl> map = this.sections;
        synchronized (map) {
            this.checkOverlap(position);
            GuardedSectionImpl guardedSectionImpl = this.sections.get(string);
            if (guardedSectionImpl != null) {
                throw new IllegalArgumentException("name exists");
            }
        }
    }

    private void checkOverlap(Position position) throws IllegalArgumentException {
        for (GuardedSectionImpl guardedSectionImpl : this.sections.values()) {
            if (!guardedSectionImpl.contains(position, false)) continue;
            throw new IllegalArgumentException("Sections overlap");
        }
    }

    private static class NewLineOutputStream
    extends OutputStream {
        OutputStream stream;
        NewLine newLineType;

        public NewLineOutputStream(OutputStream outputStream, NewLine newLine) {
            this.stream = outputStream;
            this.newLineType = newLine;
        }

        public void write(int n) throws IOException {
            if (n == 10) {
                switch (this.newLineType) {
                    case R: {
                        this.stream.write(13);
                        break;
                    }
                    case RN: {
                        this.stream.write(13);
                    }
                    case N: {
                        this.stream.write(10);
                    }
                }
            } else {
                this.stream.write(n);
            }
        }

        public void close() throws IOException {
            super.close();
            this.stream.close();
        }

        public void flush() throws IOException {
            this.stream.flush();
        }
    }
}

