/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.tools.ant.module.AntSettings;
import org.jdesktop.layout.GroupLayout;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.execution.NbClassPath;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;

public class AntCustomizer
extends JPanel
implements ActionListener {
    private List<File> classpath;
    private Map<String, String> properties;
    private boolean changed = false;
    private boolean listen = false;
    private File originalAntHome;
    private boolean initialized = false;
    private JButton bAntHome;
    private JButton bAntHomeDefault;
    private JButton bClasspath;
    private JButton bProperties;
    private JCheckBox cbAlwaysShowOutput;
    private JCheckBox cbReuseOutput;
    private JCheckBox cbSaveFiles;
    private JComboBox cbVerbosity;
    private JLabel lAntVersion;
    private JTextField tfAntHome;

    public AntCustomizer() {
        this.initComponents();
        this.bAntHome.addActionListener(this);
        ((DefaultComboBoxModel)this.cbVerbosity.getModel()).removeAllElements();
        this.cbVerbosity.addItem(NbBundle.getMessage(AntCustomizer.class, (String)"LBL_verbosity_warn"));
        this.cbVerbosity.addItem(NbBundle.getMessage(AntCustomizer.class, (String)"LBL_verbosity_info"));
        this.cbVerbosity.addItem(NbBundle.getMessage(AntCustomizer.class, (String)"LBL_verbosity_verbose"));
        this.cbVerbosity.addItem(NbBundle.getMessage(AntCustomizer.class, (String)"LBL_verbosity_debug"));
        this.bProperties.addActionListener(this);
        this.bClasspath.addActionListener(this);
        this.cbSaveFiles.addActionListener(this);
        this.cbReuseOutput.addActionListener(this);
        this.cbAlwaysShowOutput.addActionListener(this);
        this.cbVerbosity.addActionListener(this);
    }

    void update() {
        this.listen = false;
        this.classpath = AntSettings.getExtraClasspath();
        this.properties = AntSettings.getProperties();
        this.originalAntHome = AntSettings.getAntHome();
        this.tfAntHome.setText(this.originalAntHome != null ? this.originalAntHome.toString() : null);
        this.cbSaveFiles.setSelected(AntSettings.getSaveAll());
        this.cbReuseOutput.setSelected(AntSettings.getAutoCloseTabs());
        this.cbAlwaysShowOutput.setSelected(AntSettings.getAlwaysShowOutput());
        this.cbVerbosity.setSelectedIndex(AntSettings.getVerbosity() - 1);
        this.lAntVersion.setText("(" + AntSettings.getAntVersion() + ")");
        this.changed = false;
        this.initialized = true;
        this.listen = true;
    }

    void applyChanges() {
        if (!this.initialized) {
            return;
        }
        String string = this.tfAntHome.getText().trim();
        AntSettings.setAntHome(new File(string));
        if (AntSettings.getAutoCloseTabs() != this.cbReuseOutput.isSelected()) {
            AntSettings.setAutoCloseTabs(this.cbReuseOutput.isSelected());
        }
        if (AntSettings.getSaveAll() != this.cbSaveFiles.isSelected()) {
            AntSettings.setSaveAll(this.cbSaveFiles.isSelected());
        }
        if (AntSettings.getAlwaysShowOutput() != this.cbAlwaysShowOutput.isSelected()) {
            AntSettings.setAlwaysShowOutput(this.cbAlwaysShowOutput.isSelected());
        }
        if (AntSettings.getVerbosity() != this.cbVerbosity.getSelectedIndex() + 1) {
            AntSettings.setVerbosity(this.cbVerbosity.getSelectedIndex() + 1);
        }
        if (!((Object)AntSettings.getProperties()).equals(this.properties)) {
            AntSettings.setProperties(this.properties);
        }
        if (!((Object)AntSettings.getExtraClasspath()).equals(this.classpath)) {
            AntSettings.setExtraClasspath(this.classpath);
        }
        this.changed = false;
    }

    void cancel() {
        if (AntSettings.getAntHome() != this.originalAntHome) {
            AntSettings.setAntHome(this.originalAntHome);
        }
        this.changed = false;
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        return this.changed;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.listen) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.cbAlwaysShowOutput) {
            this.changed = true;
        } else if (object == this.cbReuseOutput) {
            this.changed = true;
        } else if (object == this.cbSaveFiles) {
            this.changed = true;
        } else if (object == this.cbVerbosity) {
            this.changed = true;
        } else if (object == this.bAntHome) {
            JFileChooser jFileChooser = new JFileChooser(this.tfAntHome.getText());
            jFileChooser.setFileSelectionMode(1);
            int n = jFileChooser.showDialog(SwingUtilities.getWindowAncestor(this), NbBundle.getMessage(AntCustomizer.class, (String)"Select_Directory"));
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                if (!new File(new File(file, "lib"), "ant.jar").isFile()) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(AntCustomizer.class, (String)"Not_a_ant_home", (Object)file), 2));
                    return;
                }
                this.tfAntHome.setText(file.getAbsolutePath());
                AntSettings.setAntHome(file);
                this.lAntVersion.setText("(" + AntSettings.getAntVersion() + ")");
                this.changed = true;
            }
        } else if (object == this.bClasspath) {
            PropertyEditor propertyEditor = PropertyEditorManager.findEditor(NbClassPath.class);
            propertyEditor.setValue(new NbClassPath(this.classpath.toArray(new File[this.classpath.size()])));
            Component component = propertyEditor.getCustomEditor();
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)component, NbBundle.getMessage(AntCustomizer.class, (String)"Classpath_Editor_Title"));
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
            if (dialogDescriptor.getValue() == NotifyDescriptor.OK_OPTION) {
                String string = ((NbClassPath)propertyEditor.getValue()).getClassPath();
                if (string.startsWith("\"") && string.endsWith("\"")) {
                    string = string.substring(1, string.length() - 1);
                }
                this.classpath = new ArrayList<File>();
                for (String string2 : string.split(Pattern.quote(File.pathSeparator))) {
                    this.classpath.add(new File(string2));
                }
                this.changed = true;
            }
        } else if (object == this.bProperties) {
            PropertyEditor propertyEditor = PropertyEditorManager.findEditor(Properties.class);
            Properties properties = new Properties();
            properties.putAll(this.properties);
            propertyEditor.setValue(properties);
            Component component = propertyEditor.getCustomEditor();
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)component, NbBundle.getMessage(AntCustomizer.class, (String)"Properties_Editor_Title"));
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
            if (dialogDescriptor.getValue() == NotifyDescriptor.OK_OPTION) {
                this.properties = NbCollections.checkedMapByCopy((Map)((Properties)propertyEditor.getValue()), String.class, String.class, (boolean)true);
                this.changed = true;
            }
        }
    }

    private void initComponents() {
        JLabel jLabel = new JLabel();
        this.tfAntHome = new JTextField();
        this.bAntHome = new JButton();
        this.bAntHomeDefault = new JButton();
        this.lAntVersion = new JLabel();
        this.cbSaveFiles = new JCheckBox();
        this.cbReuseOutput = new JCheckBox();
        this.cbAlwaysShowOutput = new JCheckBox();
        this.cbVerbosity = new JComboBox();
        JLabel jLabel2 = new JLabel();
        JPanel jPanel = new JPanel();
        JLabel jLabel3 = new JLabel();
        this.bProperties = new JButton();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel4 = new JLabel();
        this.bClasspath = new JButton();
        this.setBackground(Color.white);
        jLabel.setLabelFor(this.tfAntHome);
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Ant_Home"));
        Mnemonics.setLocalizedText((AbstractButton)this.bAntHome, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Ant_Home_Button"));
        Mnemonics.setLocalizedText((AbstractButton)this.bAntHomeDefault, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Ant_Home_Default_Button"));
        this.bAntHomeDefault.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AntCustomizer.this.bAntHomeDefaultActionPerformed(actionEvent);
            }
        });
        this.lAntVersion.setBackground(Color.white);
        Mnemonics.setLocalizedText((JLabel)this.lAntVersion, (String)"<Ant version here...>");
        this.cbSaveFiles.setBackground(Color.white);
        Mnemonics.setLocalizedText((AbstractButton)this.cbSaveFiles, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Save_Files"));
        this.cbSaveFiles.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbSaveFiles.setMargin(new Insets(0, 0, 0, 0));
        this.cbReuseOutput.setBackground(Color.white);
        Mnemonics.setLocalizedText((AbstractButton)this.cbReuseOutput, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Reuse_Output"));
        this.cbReuseOutput.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbReuseOutput.setMargin(new Insets(0, 0, 0, 0));
        this.cbAlwaysShowOutput.setBackground(Color.white);
        Mnemonics.setLocalizedText((AbstractButton)this.cbAlwaysShowOutput, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Always_Show_Output"));
        this.cbAlwaysShowOutput.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbAlwaysShowOutput.setMargin(new Insets(0, 0, 0, 0));
        this.cbVerbosity.setModel(new DefaultComboBoxModel<String>(new String[]{"Normal"}));
        jLabel2.setLabelFor(this.cbVerbosity);
        Mnemonics.setLocalizedText((JLabel)jLabel2, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Verbosity"));
        jPanel.setBackground(Color.white);
        jPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(AntCustomizer.class, (String)"Properties_Panel")));
        Mnemonics.setLocalizedText((JLabel)jLabel3, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Properties_Text_Area"));
        Mnemonics.setLocalizedText((AbstractButton)this.bProperties, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Properties_Button"));
        GroupLayout groupLayout = new GroupLayout((Container)jPanel);
        jPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)jLabel3).addPreferredGap(0, 25, Short.MAX_VALUE).add((Component)this.bProperties).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)jLabel3).add((Component)this.bProperties)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2.setBackground(Color.white);
        jPanel2.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(AntCustomizer.class, (String)"Classpath_Panel")));
        Mnemonics.setLocalizedText((JLabel)jLabel4, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Classpath_Text_Area"));
        Mnemonics.setLocalizedText((AbstractButton)this.bClasspath, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Classpath_Button"));
        GroupLayout groupLayout2 = new GroupLayout((Container)jPanel2);
        jPanel2.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)jLabel4).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.bClasspath).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)jLabel4).add((Component)this.bClasspath));
        GroupLayout groupLayout3 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)jPanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)jLabel).add((Component)jLabel2)).add(16, 16, 16).add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.cbAlwaysShowOutput).addContainerGap()).add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.lAntVersion, -1, 473, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.cbVerbosity, -2, -1, -2).addContainerGap()).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.cbReuseOutput).addContainerGap()).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.cbSaveFiles).addContainerGap()).add(2, (GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.tfAntHome, -1, 291, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.bAntHome).addPreferredGap(0).add((Component)this.bAntHomeDefault))))).add((Component)jPanel2, -1, -1, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((GroupLayout.Group)groupLayout3.createParallelGroup(3, false).add((Component)jLabel).add((Component)this.bAntHomeDefault).add((Component)this.bAntHome).add((Component)this.tfAntHome, -2, -1, -2)).addPreferredGap(0).add((Component)this.lAntVersion, -2, 15, -2).addPreferredGap(0).add((Component)this.cbSaveFiles).addPreferredGap(0).add((Component)this.cbReuseOutput).addPreferredGap(0).add((Component)this.cbAlwaysShowOutput).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.cbVerbosity, -2, -1, -2).add((Component)jLabel2)).addPreferredGap(0).add((Component)jPanel, -2, -1, -2).addPreferredGap(0).add((Component)jPanel2, -2, 59, -2).addContainerGap()));
    }

    private void bAntHomeDefaultActionPerformed(ActionEvent actionEvent) {
        AntSettings.setAntHome(null);
        File file = AntSettings.getAntHome();
        if (file != null) {
            this.tfAntHome.setText(file.getAbsolutePath());
        } else {
            this.tfAntHome.setText(null);
        }
        this.lAntVersion.setText("(" + AntSettings.getAntVersion() + ")");
        this.changed = true;
    }
}

