/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.loader;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.run.TargetExecutor;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AntActionInstance
implements InstanceCookie,
Action,
Presenter.Menu,
Presenter.Toolbar,
ChangeListener,
PropertyChangeListener {
    private boolean inited;
    private final AntProjectCookie proj;
    private transient PropertyChangeSupport changeSupport;

    public AntActionInstance(AntProjectCookie antProjectCookie) {
        this.proj = antProjectCookie;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    public Class instanceClass() {
        return AntActionInstance.class;
    }

    public String instanceName() {
        FileObject fileObject = this.proj.getFileObject();
        if (fileObject != null) {
            return fileObject.getName();
        }
        return "";
    }

    public Object instanceCreate() {
        this.init();
        return this;
    }

    private void init() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        this.proj.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)this.proj));
        OpenProjects.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjects.getDefault()));
        this.changeSupport = new PropertyChangeSupport(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                TargetExecutor targetExecutor = new TargetExecutor(AntActionInstance.this.proj, null);
                try {
                    targetExecutor.execute();
                }
                catch (IOException iOException) {
                    AntModule.err.notify((Throwable)iOException);
                }
            }
        });
    }

    public boolean isEnabled() {
        if (this.proj.getFile() == null) {
            return false;
        }
        Element element = this.proj.getProjectElement();
        if (element == null) {
            return false;
        }
        NodeList nodeList = element.getElementsByTagName("ant");
        if (nodeList.getLength() == 1) {
            Project project;
            String string;
            Element element2 = (Element)nodeList.item(0);
            String string2 = element2.getAttribute("antfile");
            if (string2.length() == 0 && (string = element2.getAttribute("dir")).length() > 0) {
                string2 = string + File.separatorChar + "build.xml";
            }
            if (string2.length() > 0 && (string = FileUtil.toFileObject((File)new File(string2))) != null && (project = FileOwnerQuery.getOwner((FileObject)string)) != null) {
                return Arrays.asList(OpenProjects.getDefault().getOpenProjects()).contains(project);
            }
        }
        return true;
    }

    public void setEnabled(boolean bl) {
        assert (false);
    }

    public Object getValue(String string) {
        if ("Name".equals(string)) {
            Element element = this.proj.getProjectElement();
            if (element != null) {
                String string2 = element.getAttribute("name");
                return Actions.cutAmpersand((String)string2);
            }
        } else {
            if ("SmallIcon".equals(string)) {
                try {
                    return new ImageIcon(new URL("nbresloc:/org/apache/tools/ant/module/resources/AntIcon.gif"));
                }
                catch (MalformedURLException malformedURLException) {
                    throw new AssertionError((Object)malformedURLException);
                }
            }
            if ("MnemonicKey".equals(string)) {
                String string3;
                int n;
                Element element = this.proj.getProjectElement();
                if (element != null && (n = Mnemonics.findMnemonicAmpersand((String)(string3 = element.getAttribute("name")))) != -1) {
                    return new Integer(string3.charAt(n + 1));
                }
                return new Integer(0);
            }
        }
        return null;
    }

    public void putValue(String string, Object object) {
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public JMenuItem getMenuPresenter() {
        class AntMenuItem
        extends JMenuItem
        implements DynamicMenuContent {
            public AntMenuItem() {
                super(AntActionInstance.this);
            }

            public JComponent[] getMenuPresenters() {
                JComponent[] jComponentArray;
                if (this.isEnabled()) {
                    JComponent[] jComponentArray2 = new JComponent[1];
                    jComponentArray = jComponentArray2;
                    jComponentArray2[0] = this;
                } else {
                    jComponentArray = new JComponent[]{};
                }
                return jComponentArray;
            }

            public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
                return this.getMenuPresenters();
            }
        }
        return new AntMenuItem();
    }

    public Component getToolbarPresenter() {
        class AntButton
        extends JButton
        implements PropertyChangeListener {
            public AntButton() {
                super(AntActionInstance.this);
                this.setVisible(this.isEnabled());
                AntActionInstance.this.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)AntActionInstance.this));
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                    this.setVisible(this.isEnabled());
                }
            }
        }
        return new AntButton();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.changeSupport.firePropertyChange("Name", null, this.getValue("Name"));
        this.changeSupport.firePropertyChange("enabled", null, this.isEnabled() ? Boolean.TRUE : Boolean.FALSE);
        this.changeSupport.firePropertyChange("MnemonicKey", null, this.getValue("MnemonicKey"));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.changeSupport.firePropertyChange("enabled", null, this.isEnabled() ? Boolean.TRUE : Boolean.FALSE);
    }
}

